/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Project;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ProjectOperationCollection
extends ProjectOperation {
    protected final ProjectManager projectManager;
    protected final LinkedList<ProjectOperation> list = new LinkedList();

    public ProjectOperationCollection(ProjectManager projectManager, String label) {
        super(projectManager, label);
        this.projectManager = projectManager;
    }

    public void add(ProjectOperation operation) {
        if (!operation.projectManagerMatches(this.projectManager)) {
            throw new IllegalArgumentException("different ProjectManager");
        }
        if (!operation.isNoEffect()) {
            this.list.add(operation);
        }
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ListIterator it = this.list.listIterator();
        IStatus status = Status.OK_STATUS;
        while (status.isOK() && it.hasNext()) {
            status = ((ProjectOperation)((Object)it.next())).execute(monitor, info);
        }
        if (!status.isOK()) {
            while (it.hasPrevious()) {
                IStatus status2 = ((ProjectOperation)((Object)it.previous())).undo(monitor, info);
                if (status2.isOK()) continue;
                throw new ExecutionException("a operation returns not OK status and failed to revert");
            }
        }
        return status;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ListIterator it = this.list.listIterator();
        IStatus status = Status.OK_STATUS;
        while (status.isOK() && it.hasNext()) {
            status = ((ProjectOperation)((Object)it.next())).redo(monitor, info);
        }
        if (!status.isOK()) {
            while (it.hasPrevious()) {
                IStatus status2 = ((ProjectOperation)((Object)it.previous())).undo(monitor, info);
                if (status2.isOK()) continue;
                throw new ExecutionException("a operation returns not OK status and failed to revert");
            }
        }
        return status;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ListIterator<ProjectOperation> it = this.list.listIterator(this.list.size());
        IStatus status = Status.OK_STATUS;
        while (status.isOK() && it.hasPrevious()) {
            status = it.previous().undo(monitor, info);
        }
        if (!status.isOK()) {
            while (it.hasNext()) {
                IStatus status2 = it.next().redo(monitor, info);
                if (status2.isOK()) continue;
                throw new ExecutionException("a operation returns not OK status and failed to revert");
            }
        }
        return status;
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        throw new UnsupportedOperationException();
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        throw new UnsupportedOperationException();
    }
}

