/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElementDelegate;
import ch.kuramo.javie.core.AnimatableVec2d;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableVec2dElementDelegate
extends AnimatableValueElementDelegate<Vec2d> {
    protected final String unit;
    protected double increment = 1.0;
    protected Vec2dCellEditor editor;

    public AnimatableVec2dElementDelegate(AnimatableValueElement element, String name, AnimatableVec2d avalue) {
        this(element, name, avalue, null);
    }

    public AnimatableVec2dElementDelegate(AnimatableValueElement element, String name, AnimatableVec2d avalue, String unit) {
        super(element, name, avalue);
        this.unit = unit;
    }

    @Override
    protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
        if (this.editor != null) {
            return;
        }
        x = this.drawValue(gc, x, y, height, focused, ((Vec2d)this.value).x, this.unit);
        x = this.drawSeparator(gc, x, y, height, focused);
        x = this.drawValue(gc, x, y, height, focused, ((Vec2d)this.value).y, this.unit);
    }

    protected int drawValue(GC gc, int x, int y, int height, int valueIndex, double value) {
        if (this.editor == null) {
            throw new IllegalStateException("no editor");
        }
        if (this.valueIndex != valueIndex) {
            return this.drawValue(gc, x, y, height, false, value, this.unit);
        }
        Rectangle bounds = this.editor.getTextBounds();
        if (this.unit != null) {
            this.setValueForeground(gc, false);
            return this.drawString(gc, x + bounds.width + (WIN32 ? 0 : 3), y, height, this.unit);
        }
        return x + bounds.width;
    }

    protected int drawSeparator(GC gc, int x, int y, int height, boolean focused) {
        this.setForeground(gc, focused);
        x = this.drawString(gc, x + 2, y, height, ",");
        return x + 4;
    }

    @Override
    protected boolean canDragGestureEdit() {
        return true;
    }

    @Override
    protected Vec2d dragGesture(double dx, double dy) {
        double[] orig = new double[]{((Vec2d)this.originalValue).x, ((Vec2d)this.originalValue).y};
        double[] array = new double[]{((Vec2d)this.value).x, ((Vec2d)this.value).y};
        array[this.valueIndex] = orig[this.valueIndex] + this.increment * dx;
        return new Vec2d(array[0], array[1]);
    }

    @Override
    public boolean canEdit(int columnIndex) {
        if (columnIndex == 1) {
            return this.canInlineEdit;
        }
        return false;
    }

    @Override
    public CellEditor getCellEditor(int columnIndex) {
        if (columnIndex == 1) {
            if (this.editor == null) {
                this.editor = new Vec2dCellEditor((Composite)this.element.viewer.getTree(), 2052);
            }
            return this.editor;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue(int columnIndex) {
        if (columnIndex == 1) {
            double[] array = new double[]{((Vec2d)this.value).x, ((Vec2d)this.value).y};
            return this.formatValue(array[this.valueIndex], 4);
        }
        return null;
    }

    @Override
    public void setCellEditorValue(int columnIndex, Object value) {
        if (columnIndex == 1) {
            double[] array = new double[]{((Vec2d)this.value).x, ((Vec2d)this.value).y};
            if (value.equals(this.formatValue(array[this.valueIndex], 4))) {
                return;
            }
            try {
                array[this.valueIndex] = Double.valueOf((String)value);
                this.modifyValue(new Vec2d(array[0], array[1]));
            }
            catch (NumberFormatException numberFormatException) {
                this.element.viewer.getTree().getDisplay().beep();
            }
        }
    }

    protected class Vec2dCellEditor
    extends TextCellEditor {
        private boolean activated;

        protected Vec2dCellEditor(Composite parent, int style) {
            super(parent, style);
        }

        protected Control createControl(final Composite parent) {
            final Composite composite = new Composite(parent, 0x80000 | (COCOA ? 262144 : 0));
            composite.setFont(parent.getFont());
            composite.setBackground(parent.getBackground());
            composite.setLayout((Layout)new FormLayout());
            super.createControl(composite);
            this.text.setBackground(this.text.getDisplay().getSystemColor(1));
            Rectangle valueBounds = (Rectangle)AnimatableVec2dElementDelegate.this.valueArea.get(AnimatableVec2dElementDelegate.this.valueIndex);
            int left = valueBounds.x - ((Rectangle)AnimatableVec2dElementDelegate.this.valueArea.get((int)0)).x + (WIN32 ? 3 : 0);
            int right = left + Math.max(60, valueBounds.width + 30);
            FormData data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(100, 0);
            data.left = new FormAttachment(0, left);
            data.right = new FormAttachment(0, right);
            this.text.setLayoutData((Object)data);
            composite.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    parent.forceFocus();
                    if (e.button == 1) {
                        int i = 0;
                        int n = ((Vec2dCellEditor)Vec2dCellEditor.this).AnimatableVec2dElementDelegate.this.valueArea.size();
                        while (i < n) {
                            Rectangle r = (Rectangle)((Vec2dCellEditor)Vec2dCellEditor.this).AnimatableVec2dElementDelegate.this.valueArea.get(i);
                            if (r.contains(e.x, e.y)) {
                                ((Vec2dCellEditor)Vec2dCellEditor.this).AnimatableVec2dElementDelegate.this.valueIndex = i < ((Vec2dCellEditor)Vec2dCellEditor.this).AnimatableVec2dElementDelegate.this.valueIndex ? i : i + 1;
                                parent.update();
                                AnimatableVec2dElementDelegate.this.openInlineEditor();
                                break;
                            }
                            ++i;
                        }
                    }
                }
            });
            composite.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC gc = e.gc;
                    int x = WIN32 ? 5 : 2;
                    int height = composite.getBounds().height;
                    x = AnimatableVec2dElementDelegate.this.drawValue(gc, x, 0, height, 0, ((Vec2d)((Vec2dCellEditor)Vec2dCellEditor.this).AnimatableVec2dElementDelegate.this.value).x);
                    x = AnimatableVec2dElementDelegate.this.drawSeparator(gc, x, 0, height, false);
                    x = AnimatableVec2dElementDelegate.this.drawValue(gc, x, 0, height, 1, ((Vec2d)((Vec2dCellEditor)Vec2dCellEditor.this).AnimatableVec2dElementDelegate.this.value).y);
                }
            });
            return composite;
        }

        private Rectangle getTextBounds() {
            return this.text.getBounds();
        }

        public void activate() {
            super.activate();
            this.activated = true;
        }

        public void deactivate() {
            super.deactivate();
            if (this.activated) {
                AnimatableVec2dElementDelegate.this.editor = null;
                this.dispose();
            }
        }
    }
}

