/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.audio;

import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.plugin.PIAnimatableBoolean;
import ch.kuramo.javie.api.plugin.PIAnimatableDouble;
import ch.kuramo.javie.api.plugin.PIAnimatableValue;
import ch.kuramo.javie.api.plugin.PIAudioBuffer;
import ch.kuramo.javie.api.plugin.PIAudioRenderContext;
import com.google.inject.Inject;

@Effect(id="ch.kuramo.javie.StereoMixer", category="ch.kuramo.javie.api.effectCategory.audio")
public class StereoMixer {
    @Property(value="100")
    private PIAnimatableDouble leftLevel;
    @Property(value="100")
    private PIAnimatableDouble rightLevel;
    @Property(value="-100")
    private PIAnimatableDouble leftPan;
    @Property(value="100")
    private PIAnimatableDouble rightPan;
    @Property
    private PIAnimatableBoolean invertPhase;
    private final PIAudioRenderContext context;

    @Inject
    public StereoMixer(PIAudioRenderContext context) {
        this.context = context;
    }

    public PIAudioBuffer doAudioEffect() {
        double leftLevel = Math.max(0.0, Math.min(400.0, (Double)this.context.value((PIAnimatableValue)this.leftLevel)));
        double rightLevel = Math.max(0.0, Math.min(400.0, (Double)this.context.value((PIAnimatableValue)this.rightLevel)));
        double leftPan = Math.max(-100.0, Math.min(100.0, (Double)this.context.value((PIAnimatableValue)this.leftPan)));
        double rightPan = Math.max(-100.0, Math.min(100.0, (Double)this.context.value((PIAnimatableValue)this.rightPan)));
        double phase = (Boolean)this.context.value((PIAnimatableValue)this.invertPhase) != false ? -1.0 : 1.0;
        leftLevel /= 100.0;
        rightLevel /= 100.0;
        leftPan = (leftPan - 100.0) / -200.0;
        rightPan = (rightPan + 100.0) / 200.0;
        PIAudioBuffer ab = this.context.doPreviousEffect();
        Object data = ab.getData();
        int frameCount = ab.getFrameCount();
        switch (ab.getAudioMode().dataType) {
            case SHORT: {
                this.mixer((short[])data, frameCount, leftLevel, rightLevel, leftPan, rightPan, phase);
                break;
            }
            case INT: {
                this.mixer((int[])data, frameCount, leftLevel, rightLevel, leftPan, rightPan, phase);
                break;
            }
            case FLOAT: {
                this.mixer((float[])data, frameCount, leftLevel, rightLevel, leftPan, rightPan, phase);
            }
        }
        return ab;
    }

    private void mixer(short[] data, int frameCount, double leftLevel, double rightLevel, double leftPan, double rightPan, double phase) {
        int i = 0;
        while (i < frameCount) {
            double left = (double)data[i * 2] * leftLevel;
            double right = (double)data[i * 2 + 1] * rightLevel;
            data[i * 2] = this.clampToShort((left * leftPan + right * (1.0 - rightPan)) * phase);
            data[i * 2 + 1] = this.clampToShort((right * rightPan + left * (1.0 - leftPan)) * phase);
            ++i;
        }
    }

    private void mixer(int[] data, int frameCount, double leftLevel, double rightLevel, double leftPan, double rightPan, double phase) {
        int i = 0;
        while (i < frameCount) {
            double left = (double)data[i * 2] * leftLevel;
            double right = (double)data[i * 2 + 1] * rightLevel;
            data[i * 2] = this.clampToInt((left * leftPan + right * (1.0 - rightPan)) * phase);
            data[i * 2 + 1] = this.clampToInt((right * rightPan + left * (1.0 - leftPan)) * phase);
            ++i;
        }
    }

    private void mixer(float[] data, int frameCount, double leftLevel, double rightLevel, double leftPan, double rightPan, double phase) {
        int i = 0;
        while (i < frameCount) {
            double left = (double)data[i * 2] * leftLevel;
            double right = (double)data[i * 2 + 1] * rightLevel;
            data[i * 2] = (float)((left * leftPan + right * (1.0 - rightPan)) * phase);
            data[i * 2 + 1] = (float)((right * rightPan + left * (1.0 - leftPan)) * phase);
            ++i;
        }
    }

    private short clampToShort(double d) {
        return (short)Math.min(Math.max(d, -32768.0), 32767.0);
    }

    private int clampToInt(double d) {
        return (int)Math.min(Math.max(d, -2.147483648E9), 2.147483647E9);
    }
}

