/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.blurSharpen;

import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.plugin.PIShaderProgram;
import ch.kuramo.javie.api.plugin.PIShaderRegistry;
import ch.kuramo.javie.api.plugin.PIVideoBuffer;
import ch.kuramo.javie.effects.VideoEffectUtil;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class BlurUtil {
    private static final int[][] DOWNSAMPLE_FACTORS = new int[][]{{300, 7, 7}, {200, 5, 7}, {150, 5, 5}, {100, 3, 5}, {50, 3, 3}, {30, 5}, {10, 3}};

    public static int[] getDownSampleFactors(double hint) {
        int i = 0;
        while (i < DOWNSAMPLE_FACTORS.length) {
            if (hint >= (double)DOWNSAMPLE_FACTORS[i][0]) {
                int[] factors = new int[DOWNSAMPLE_FACTORS[i].length - 1];
                int j = 0;
                while (j < factors.length) {
                    factors[j] = DOWNSAMPLE_FACTORS[i][j + 1];
                    ++j;
                }
                return factors;
            }
            ++i;
        }
        return new int[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doDownSample(PIVideoBuffer src, PIVideoBuffer dst, int hRatio, int vRatio, GL gl, GLU glu, PIShaderRegistry shaders) {
        PIShaderProgram program;
        int ksize = hRatio * vRatio;
        float[] kernel = new float[ksize];
        float[] offset = new float[ksize * 2];
        int j = 0;
        while (j < vRatio) {
            int i = 0;
            while (i < hRatio) {
                int k = j * hRatio + i;
                kernel[k] = 1.0f / (float)ksize;
                offset[k * 2] = i - hRatio / 2;
                offset[k * 2 + 1] = j - vRatio / 2;
                ++i;
            }
            ++j;
        }
        VideoBounds dstBounds = dst.getBounds();
        float quadWidth = dstBounds.width * hRatio;
        float quadHeight = dstBounds.height * vRatio;
        VideoEffectUtil.ortho2D(gl, glu, dstBounds.width, dstBounds.height);
        gl.glScalef(1.0f / (float)hRatio, 1.0f / (float)vRatio, 1.0f);
        gl.glFramebufferTexture2DEXT(36160, 36064, 34037, dst.getTexture(), 0);
        gl.glDrawBuffer(36064);
        gl.glActiveTexture(33984);
        gl.glBindTexture(34037, src.getTexture());
        PIShaderProgram pIShaderProgram = program = shaders.getProgram(VideoEffectUtil.class, "CONVOLUTION");
        synchronized (pIShaderProgram) {
            gl.glUseProgram(program.getProgram());
            gl.glUniform1i(program.getUniformLocation("texture"), 0);
            gl.glUniform1i(program.getUniformLocation("ksize"), ksize);
            gl.glUniform1fv(program.getUniformLocation("kernel[0]"), ksize, kernel, 0);
            gl.glUniform2fv(program.getUniformLocation("offset[0]"), ksize * 2, offset, 0);
            gl.glBegin(7);
            gl.glTexCoord2f(0.0f, 0.0f);
            gl.glVertex2f(0.0f, 0.0f);
            gl.glTexCoord2f(quadWidth, 0.0f);
            gl.glVertex2f(quadWidth, 0.0f);
            gl.glTexCoord2f(quadWidth, quadHeight);
            gl.glVertex2f(quadWidth, quadHeight);
            gl.glTexCoord2f(0.0f, quadHeight);
            gl.glVertex2f(0.0f, quadHeight);
            gl.glEnd();
            gl.glFinish();
            gl.glUseProgram(0);
        }
        gl.glActiveTexture(33984);
        gl.glBindTexture(34037, 0);
        gl.glFramebufferTexture2DEXT(36160, 36064, 34037, 0, 0);
    }

    public static void doUpSample(PIVideoBuffer src, PIVideoBuffer dst, int hRatio, int vRatio, GL gl, GLU glu) {
        VideoBounds srcBounds = src.getBounds();
        VideoBounds dstBounds = dst.getBounds();
        VideoEffectUtil.ortho2D(gl, glu, dstBounds.width, dstBounds.height);
        gl.glScalef((float)hRatio, (float)vRatio, 1.0f);
        gl.glFramebufferTexture2DEXT(36160, 36064, 34037, dst.getTexture(), 0);
        gl.glDrawBuffer(36064);
        gl.glActiveTexture(33984);
        gl.glBindTexture(34037, src.getTexture());
        gl.glEnable(34037);
        gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex2f(0.0f, 0.0f);
        gl.glTexCoord2f((float)srcBounds.width, 0.0f);
        gl.glVertex2f((float)srcBounds.width, 0.0f);
        gl.glTexCoord2f((float)srcBounds.width, (float)srcBounds.height);
        gl.glVertex2f((float)srcBounds.width, (float)srcBounds.height);
        gl.glTexCoord2f(0.0f, (float)srcBounds.height);
        gl.glVertex2f(0.0f, (float)srcBounds.height);
        gl.glEnd();
        gl.glActiveTexture(33984);
        gl.glBindTexture(34037, 0);
        gl.glDisable(34037);
        gl.glFramebufferTexture2DEXT(36160, 36064, 34037, 0, 0);
    }
}

