/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.RenderContext;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.WrappedOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Quat4d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnimatableValue<V>
implements AnimatableValue<V> {
    private V _staticValue;
    private final SortedMap<Time, Keyframe<V>> _keyframes;
    private String _expression;

    public AbstractAnimatableValue(V staticValue, Collection<Keyframe<V>> keyframes, String expression) {
        this._staticValue = staticValue;
        this._keyframes = Util.newSortedMap();
        this._expression = expression;
        if (keyframes != null) {
            for (Keyframe<V> k : keyframes) {
                this.putKeyframe(k);
            }
        }
    }

    public AbstractAnimatableValue(V staticValue) {
        this(staticValue, null, null);
    }

    @Override
    public V value(RenderContext renderContext) {
        if (this._expression != null && !renderContext.checkCyclicEvaluation(this)) {
            try {
                Object value = renderContext.evaluateExpression(this);
                if (value != null) {
                    return (V)value;
                }
                throw new NullPointerException();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.value(renderContext.getTime());
    }

    @Override
    public V valueAtTime(final Time time, final RenderContext renderContext) {
        if (this._expression != null && !renderContext.checkCyclicEvaluation(this)) {
            try {
                Object value = renderContext.saveAndExecute(new WrappedOperation<V>(){

                    @Override
                    public V execute() {
                        renderContext.setTime(time);
                        return renderContext.evaluateExpression(AbstractAnimatableValue.this);
                    }
                });
                if (value != null) {
                    return (V)value;
                }
                throw new NullPointerException();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.value(time);
    }

    private V value(Time time) {
        SortedMap<Time, Keyframe<V>> headMap;
        if (this._keyframes.isEmpty()) {
            return this._staticValue;
        }
        Keyframe k1 = null;
        Keyframe<V> k2 = null;
        Iterator<Map.Entry<Time, Keyframe<V>>> tail = this._keyframes.tailMap(time).entrySet().iterator();
        if (tail.hasNext()) {
            Map.Entry<Time, Keyframe<V>> entry = tail.next();
            if (entry.getKey().equals((Object)time)) {
                k1 = entry.getValue();
                if (tail.hasNext()) {
                    k2 = tail.next().getValue();
                }
            } else {
                k2 = entry.getValue();
            }
        }
        if (k1 == null && !(headMap = this._keyframes.headMap(time)).isEmpty()) {
            k1 = (Keyframe)headMap.get(headMap.lastKey());
        }
        if (k1 == null) {
            return k2.value;
        }
        if (k2 == null) {
            return k1.value;
        }
        switch (k1.interpolation) {
            case HOLD: {
                return k1.value;
            }
            case LINEAR: {
                return this.valueOf(this.linear(this.toArray(k1.value), this.toArray(k2.value), k1.time, k2.time, time));
            }
            case CATMULL_ROM: {
                headMap = this._keyframes.headMap(k1.time);
                Keyframe k0 = !headMap.isEmpty() ? (Keyframe)headMap.get(headMap.lastKey()) : k1;
                Keyframe<V> k3 = tail.hasNext() ? tail.next().getValue() : k2;
                return this.valueOf(this.catmullRom(this.toArray(k0.value), this.toArray(k1.value), this.toArray(k2.value), this.toArray(k3.value), k1.time, k2.time, time));
            }
            case SLERP: {
                return this.valueOf(this.slerp(this.toArray(k1.value), this.toArray(k2.value), k1.time, k2.time, time));
            }
        }
        throw new UnsupportedOperationException(k1.interpolation.name());
    }

    protected abstract double[] toArray(V var1);

    protected abstract V valueOf(double[] var1);

    protected double[] linear(double[] p1, double[] p2, Time time1, Time time2, Time time) {
        double[] result = new double[p1.length];
        int i = 0;
        int n = result.length;
        while (i < n) {
            double s1 = time1.toSecond();
            double s2 = time2.toSecond();
            double s = time.toSecond();
            double t = (s - s1) / (s2 - s1);
            result[i] = (p2[i] - p1[i]) * t + p1[i];
            ++i;
        }
        return result;
    }

    protected double[] catmullRom(double[] p0, double[] p1, double[] p2, double[] p3, Time time1, Time time2, Time time) {
        double[] result = new double[p0.length];
        int i = 0;
        int n = result.length;
        while (i < n) {
            double s1 = time1.toSecond();
            double s2 = time2.toSecond();
            double s = time.toSecond();
            double t = (s - s1) / (s2 - s1);
            double tt = t * t;
            double ttt = tt * t;
            double v0 = (p2[i] - p0[i]) * 0.5;
            double v1 = (p3[i] - p1[i]) * 0.5;
            result[i] = (2.0 * p1[i] - 2.0 * p2[i] + v0 + v1) * ttt + (-3.0 * p1[i] + 3.0 * p2[i] - 2.0 * v0 - v1) * tt + v0 * t + p1[i];
            ++i;
        }
        return result;
    }

    protected double[] slerp(double[] p1, double[] p2, Time time1, Time time2, Time time) {
        double s1 = time1.toSecond();
        double s2 = time2.toSecond();
        double s = time.toSecond();
        double t = (s - s1) / (s2 - s1);
        Matrix4d m1 = new Matrix4d();
        Matrix4d m2 = new Matrix4d();
        Matrix4d m = new Matrix4d();
        AxisAngle4d aa = new AxisAngle4d();
        m1.setIdentity();
        aa.set(1.0, 0.0, 0.0, Math.toRadians(p1[0]));
        m.set(aa);
        m1.mul(m);
        aa.set(0.0, 1.0, 0.0, Math.toRadians(p1[1]));
        m.set(aa);
        m1.mul(m);
        aa.set(0.0, 0.0, 1.0, Math.toRadians(p1[2]));
        m.set(aa);
        m1.mul(m);
        m2.setIdentity();
        aa.set(1.0, 0.0, 0.0, Math.toRadians(p2[0]));
        m.set(aa);
        m2.mul(m);
        aa.set(0.0, 1.0, 0.0, Math.toRadians(p2[1]));
        m.set(aa);
        m2.mul(m);
        aa.set(0.0, 0.0, 1.0, Math.toRadians(p2[2]));
        m.set(aa);
        m2.mul(m);
        Quat4d q1 = new Quat4d();
        Quat4d q2 = new Quat4d();
        q1.set(m1);
        q2.set(m2);
        q1.interpolate(q2, t);
        m.set(q1);
        double x = Math.toDegrees(Math.atan2(m.m12, m.m22));
        double y = Math.toDegrees(Math.asin(-m.m02));
        double z = Math.toDegrees(Math.atan2(m.m01, m.m00));
        return new double[]{-x, -y, -z};
    }

    @Override
    public V getStaticValue() {
        return this._staticValue;
    }

    @Override
    public boolean hasKeyframe() {
        return !this._keyframes.isEmpty();
    }

    @Override
    public Keyframe<V> getKeyframe(Time time) {
        return (Keyframe)this._keyframes.get(time);
    }

    @Override
    public Collection<Keyframe<V>> getKeyframes() {
        return Collections.unmodifiableCollection(this._keyframes.values());
    }

    @Override
    public Collection<Keyframe<V>> getKeyframes(Time fromTime, Time toTime) {
        return Collections.unmodifiableCollection(this._keyframes.subMap(fromTime, toTime).values());
    }

    @Override
    public SortedMap<Time, Keyframe<V>> headKeyframeMap(Time toTime) {
        return Collections.unmodifiableSortedMap(this._keyframes.headMap(toTime));
    }

    @Override
    public SortedMap<Time, Keyframe<V>> tailKeyframeMap(Time fromTime) {
        return Collections.unmodifiableSortedMap(this._keyframes.tailMap(fromTime));
    }

    public abstract Set<Interpolation> supportedInterpolations();

    @Override
    public Keyframe<V> putKeyframe(Keyframe<V> keyframe) {
        if (!this.supportedInterpolations().contains((Object)keyframe.interpolation)) {
            throw new IllegalArgumentException("unsupported interpolation: " + keyframe.interpolation.name());
        }
        return this._keyframes.put(keyframe.time, keyframe);
    }

    @Override
    public Keyframe<V> putKeyframe(Time time, V value, Interpolation interpolation) {
        return this.putKeyframe(new Keyframe<V>(time, value, interpolation));
    }

    @Override
    public Keyframe<V> removeKeyframe(Time time) {
        Keyframe removed = (Keyframe)this._keyframes.remove(time);
        if (this._keyframes.isEmpty() && removed != null) {
            this._staticValue = removed.value;
        }
        return removed;
    }

    @Override
    public void clearKeyframes() {
        if (!this._keyframes.isEmpty()) {
            this.clearKeyframes(((Keyframe)this._keyframes.get((Object)this._keyframes.firstKey())).value);
        }
    }

    @Override
    public void clearKeyframes(V staticValue) {
        this._staticValue = staticValue;
        this._keyframes.clear();
    }

    @Override
    public String getExpression() {
        return this._expression;
    }

    @Override
    public void setExpression(String expression) {
        this._expression = expression;
    }

    protected V valueAtTime(double t, RenderContext renderContext) {
        int timeScale = renderContext.getTime().timeScale;
        Time time = new Time((long)(t * (double)timeScale), timeScale);
        return this.valueAtTime(time, renderContext);
    }
}

