/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.plugin.PIAnimatableVec3d;
import ch.kuramo.javie.core.AbstractAnimatableValue;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.RenderContext;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.exprelems.DoubleProperty;
import java.util.Collection;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableVec3d
extends AbstractAnimatableValue<Vec3d>
implements PIAnimatableVec3d {
    private static final Set<Interpolation> SUPPORTED_INTERPOLATIONS = Util.unmodifiableSet(Interpolation.HOLD, Interpolation.LINEAR, Interpolation.CATMULL_ROM, Interpolation.SLERP);

    public AnimatableVec3d(Vec3d staticValue, Collection<Keyframe<Vec3d>> keyframes, String expression) {
        super(staticValue, keyframes, expression);
    }

    public AnimatableVec3d(Vec3d staticValue) {
        super(staticValue);
    }

    @Override
    public Vec3d jsToJava(Object jsValue) {
        if (jsValue instanceof NativeJavaArray) {
            Object[] value = (Object[])((NativeJavaArray)jsValue).unwrap();
            double[] array = new double[3];
            int i = 0;
            int n = Math.min(3, value.length);
            while (i < n) {
                array[i] = (Double)Context.jsToJava((Object)value[i], Double.TYPE);
                ++i;
            }
            return this.valueOf(array);
        }
        double[] array = (double[])Context.jsToJava((Object)jsValue, double[].class);
        if (array.length < 3) {
            double[] tmp = array;
            array = new double[3];
            int i = 0;
            while (i < tmp.length) {
                array[i] = tmp[i];
                ++i;
            }
        }
        return this.valueOf(array);
    }

    @Override
    protected double[] toArray(Vec3d value) {
        return new double[]{value.x, value.y, value.z};
    }

    @Override
    protected Vec3d valueOf(double[] d) {
        return new Vec3d(d[0], d[1], d[2]);
    }

    @Override
    public Set<Interpolation> supportedInterpolations() {
        return SUPPORTED_INTERPOLATIONS;
    }

    public Scriptable[] createExpressionElement(final RenderContext renderContext) {
        DoubleProperty x = new DoubleProperty(){

            public double getValue() {
                return ((Vec3d)AnimatableVec3d.this.value((RenderContext)renderContext)).x;
            }

            public double valueAtTime(double t) {
                return ((Vec3d)AnimatableVec3d.this.valueAtTime((double)t, (RenderContext)renderContext)).x;
            }
        };
        DoubleProperty y = new DoubleProperty(){

            public double getValue() {
                return ((Vec3d)AnimatableVec3d.this.value((RenderContext)renderContext)).y;
            }

            public double valueAtTime(double t) {
                return ((Vec3d)AnimatableVec3d.this.valueAtTime((double)t, (RenderContext)renderContext)).y;
            }
        };
        DoubleProperty z = new DoubleProperty(){

            public double getValue() {
                return ((Vec3d)AnimatableVec3d.this.value((RenderContext)renderContext)).z;
            }

            public double valueAtTime(double t) {
                return ((Vec3d)AnimatableVec3d.this.valueAtTime((double)t, (RenderContext)renderContext)).z;
            }
        };
        return new Scriptable[]{renderContext.toNativeJavaObject(x, ScriptRuntime.NumberClass), renderContext.toNativeJavaObject(y, ScriptRuntime.NumberClass), renderContext.toNativeJavaObject(z, ScriptRuntime.NumberClass)};
    }
}

