/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.FrameDuration;

public class TimeCode {
    public static String toTimeCode(Time time, Time frameDuration) {
        return TimeCode.toTimeCode(time, frameDuration, true, true);
    }

    public static String toTimeCode(Time time, Time frameDuration, boolean dropFrame, boolean withZeroHour) {
        if (frameDuration.equals((Object)FrameDuration.FPS_59_94)) {
            return TimeCode.toTimeCode(time, frameDuration, 60, dropFrame ? 4 : 0, withZeroHour);
        }
        if (frameDuration.equals((Object)FrameDuration.FPS_29_97)) {
            return TimeCode.toTimeCode(time, frameDuration, 30, dropFrame ? 2 : 0, withZeroHour);
        }
        double fps = (double)frameDuration.timeScale / (double)frameDuration.timeValue;
        String fpsStr = String.format("%.2f", fps);
        if (fpsStr.equals("59.94")) {
            return TimeCode.toTimeCode(time, frameDuration, 60, dropFrame ? 4 : 0, withZeroHour);
        }
        if (fpsStr.equals("29.97")) {
            return TimeCode.toTimeCode(time, frameDuration, 30, dropFrame ? 2 : 0, withZeroHour);
        }
        return TimeCode.toTimeCode(time, frameDuration, (int)Math.round(fps), 0, withZeroHour);
    }

    private static String toTimeCode(Time time, Time frameDuration, int base, int drop, boolean withZeroHour) {
        long frames = time.toFrameNumber(frameDuration);
        int fpm = base * 60 - drop;
        int fp10m = fpm * 10 + drop;
        int fph = fp10m * 6;
        long h = frames / (long)fph;
        long tenm = (frames %= (long)fph) / (long)fp10m;
        long m = (frames %= (long)fp10m) / (long)fpm;
        long s = (frames %= (long)fpm) / (long)base;
        frames %= (long)base;
        if (drop == 0) {
            return withZeroHour || h != 0L ? String.format("%d:%01d%01d:%02d:%02d", h, tenm, m, s, frames) : String.format("%01d%01d:%02d:%02d", tenm, m, s, frames);
        }
        if (s == 0L && m != 0L && frames < (long)drop) {
            --m;
            s = 59L;
            frames += (long)(base - drop);
        }
        return withZeroHour || h != 0L ? String.format("%d;%01d%01d;%02d;%02d", h, tenm, m, s, frames) : String.format("%01d%01d;%02d;%02d", tenm, m, s, frames);
    }
}

