/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.plugin.PIAudioBuffer;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.services.ArrayPools;
import com.google.inject.Inject;

public class AudioBufferImpl
implements AudioBuffer,
PIAudioBuffer {
    private final AudioMode _audioMode;
    private final int _frameCount;
    private final int _dataLength;
    private final int _dataLengthInBytes;
    private Object _data;
    @Inject
    private ArrayPools _arrayPools;

    public AudioBufferImpl(AudioMode audioMode, int frameCount) {
        this._audioMode = audioMode;
        this._frameCount = frameCount;
        this._dataLength = frameCount * audioMode.channels;
        this._dataLengthInBytes = this._dataLength * audioMode.sampleSize;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this._data != null) {
            this._arrayPools.put(this._data);
            this._data = null;
        }
    }

    public AudioMode getAudioMode() {
        return this._audioMode;
    }

    public int getFrameCount() {
        return this._frameCount;
    }

    public int getDataLength() {
        return this._dataLength;
    }

    public int getDataLengthInBytes() {
        return this._dataLengthInBytes;
    }

    public Object getData() {
        if (this._data == null) {
            switch (this._audioMode.dataType) {
                case SHORT: {
                    this._data = this._arrayPools.getShortArray(this._dataLength);
                    break;
                }
                case INT: {
                    this._data = this._arrayPools.getIntArray(this._dataLength);
                    break;
                }
                case FLOAT: {
                    this._data = this._arrayPools.getFloatArray(this._dataLength);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + this._audioMode.dataType);
                }
            }
        }
        return this._data;
    }
}

