/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.core.DepthBuffer;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DepthBufferImpl
implements DepthBuffer {
    private static final Logger _logger = LoggerFactory.getLogger(DepthBufferImpl.class);
    @Inject
    private VideoRenderSupport _vrSupport;
    private final Size2i _imageSize;
    private int _texture;

    public DepthBufferImpl(Size2i imageSize) {
        this._imageSize = imageSize;
    }

    protected void finalize() throws Throwable {
        if (this._texture != 0) {
            _logger.warn("finalizing a DepthBufferImpl object, but the object is not disposed.");
        }
        super.finalize();
    }

    public void dispose() {
        if (this._texture != 0) {
            this._vrSupport.deleteTexture(this._texture);
            this._texture = 0;
        }
    }

    public int getTexture() {
        if (this._texture == 0) {
            this._texture = this._vrSupport.createDepthTexture(this._imageSize);
        }
        return this._texture;
    }

    public Size2i getImageSize() {
        return this._imageSize;
    }
}

