/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.MediaFileInput;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.services.AudioRenderContext;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.SynchronousTaskThread;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsDirectShowInput
implements MediaFileInput {
    private static final Logger _logger = LoggerFactory.getLogger(WindowsDirectShowInput.class);
    private long _videoInput;
    private long _audioInput;
    private VideoBounds _bounds;
    private Time _duration;
    private Time _videoFrameDuration;
    private AudioMode _audioMode;
    @Inject
    private SynchronousTaskThread _videoThread;
    @Inject
    private SynchronousTaskThread _audioThread;
    @Inject
    private VideoRenderContext _vrContext;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private AudioRenderContext _arContext;
    @Inject
    private AudioRenderSupport _arSupport;

    static {
        System.loadLibrary("DirectShowInput");
    }

    public boolean initialize(final File file) {
        this._videoThread.start();
        this._videoThread.invoke(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                WindowsDirectShowInput.this.initializeVideo(file);
            }
        });
        if (this._videoInput == 0L) {
            this.disposeVideo();
        }
        this._audioThread.start();
        this._audioThread.invoke(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                WindowsDirectShowInput.this.initializeAudio(file);
            }
        });
        if (this._audioInput == 0L) {
            this.disposeAudio();
        }
        return this._videoInput != 0L || this._audioInput != 0L;
    }

    private void initializeVideo(File file) {
        long[] result = this.openVideo(file.getAbsolutePath());
        if (result != null) {
            this._videoInput = result[0];
            this._bounds = new VideoBounds((int)result[1], (int)result[2]);
            this._duration = new Time(result[4], 10000000);
            this._videoFrameDuration = new Time(result[4] / result[3], 10000000);
            this._videoThread.setName(String.valueOf(this.getClass().getSimpleName()) + " (Video): " + file.getName());
        }
    }

    private void initializeAudio(File file) {
        long[] result = this.openAudio(file.getAbsolutePath());
        if (result != null) {
            this._audioInput = result[0];
            if (this._duration == null) {
                this._duration = new Time(result[1], 10000000);
            }
            this._audioThread.setName(String.valueOf(this.getClass().getSimpleName()) + " (Audio): " + file.getName());
        }
    }

    public void dispose() {
        this.disposeVideo();
        this.disposeAudio();
    }

    private void disposeVideo() {
        this._videoThread.exit(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                if (WindowsDirectShowInput.this._videoInput != 0L) {
                    WindowsDirectShowInput.this.closeVideo(WindowsDirectShowInput.this._videoInput);
                    WindowsDirectShowInput.this._videoInput = 0L;
                    WindowsDirectShowInput.this._bounds = null;
                }
            }
        });
    }

    private void disposeAudio() {
        this._audioThread.exit(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                if (WindowsDirectShowInput.this._audioInput != 0L) {
                    WindowsDirectShowInput.this.closeAudio(WindowsDirectShowInput.this._audioInput);
                    WindowsDirectShowInput.this._audioInput = 0L;
                    WindowsDirectShowInput.this._audioMode = null;
                }
            }
        });
    }

    public boolean isVideoAvailable() {
        return this._videoInput != 0L;
    }

    public boolean isAudioAvailable() {
        return this._audioInput != 0L;
    }

    public Time getDuration() {
        return this._duration;
    }

    public Time getVideoFrameDuration() {
        return this._videoFrameDuration;
    }

    public VideoBounds getVideoFrameBounds() {
        return this._bounds;
    }

    public VideoBuffer getVideoFrameImage() {
        if (this._videoInput == 0L) {
            return null;
        }
        VideoBuffer vb = this._vrSupport.createVideoBuffer(ColorMode.RGBA8, this._bounds);
        try {
            vb.allocateAsArray();
            Time time = Time.fromFrameNumber((long)this._vrContext.getTime().toFrameNumber(this._videoFrameDuration), (Time)this._videoFrameDuration);
            long timeValue = time.timeValue + this._videoFrameDuration.timeValue / 2L;
            int timeScale = time.timeScale;
            final long dsTime = timeValue * 10000000L / (long)timeScale;
            final byte[] array = (byte[])vb.getArray();
            int error = this._videoThread.invoke(new SynchronousTaskThread.Task<Integer>(){

                @Override
                public Integer run() throws Exception {
                    int error = WindowsDirectShowInput.this.frameImageAtTime(WindowsDirectShowInput.this._videoInput, dsTime, array);
                    if (error != 0) {
                        _logger.error("frameImageAtTime: error " + error);
                    }
                    return error;
                }
            });
            if (error != 0) {
                return null;
            }
            RenderResolution resolution = this._vrContext.getRenderResolution();
            VideoBuffer vb2 = this._vrSupport.createVideoBuffer(this._vrContext.getColorMode(), resolution.scale(this._bounds));
            this._vrSupport.scaleAndFlipVertical(vb, vb2, resolution.scale(1.0));
            VideoBuffer videoBuffer = vb2;
            return videoBuffer;
        }
        finally {
            vb.dispose();
        }
    }

    public AudioBuffer getAudioChunk() {
        if (this._audioInput == 0L) {
            return null;
        }
        Time time = this._arContext.getTime();
        final long dsTime = time.timeValue * 10000000L / (long)time.timeScale;
        final AudioBuffer ab = this._arSupport.createAudioBuffer();
        int error = this._audioThread.invoke(new SynchronousTaskThread.Task<Integer>(){

            @Override
            public Integer run() throws Exception {
                AudioMode am = ab.getAudioMode();
                int error = WindowsDirectShowInput.this.audioChunkFromTime(WindowsDirectShowInput.this._audioInput, dsTime, ab.getData(), ab.getDataLengthInBytes());
                if (error != 0) {
                    _logger.error("audioChunkFromTime: error " + error);
                }
                return error;
            }
        });
        if (error == 0) {
            return ab;
        }
        ab.dispose();
        return null;
    }

    private native long[] openVideo(String var1);

    private native long[] openAudio(String var1);

    private native void closeVideo(long var1);

    private native void closeAudio(long var1);

    private native int frameImageAtTime(long var1, long var3, byte[] var5);

    private native int audioChunkFromTime(long var1, long var3, Object var5, int var6);

    static /* synthetic */ AudioMode access$12(WindowsDirectShowInput windowsDirectShowInput) {
        return windowsDirectShowInput._audioMode;
    }
}

