/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.core.EffectDescriptor;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.internal.services.EffectDescriptorImpl;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;

class EffectClassProcessor {
    private final ClassLoader cl;
    private final String type;
    private final ClassPool pool;
    private final CtClass ccInterior;
    private final CtClass ccExterior;
    private final CtClass ccExprInterface;
    private int countAEnum;

    EffectClassProcessor(ClassLoader cl, String type, CtClass ccInterior) {
        this.cl = cl;
        this.type = type;
        this.pool = ccInterior.getClassPool();
        this.ccInterior = ccInterior;
        try {
            this.ccExterior = this.pool.getAndRename("ch.kuramo.javie.core.internal.templates.EffectTemplate", String.valueOf(ccInterior.getName()) + "$Exterior");
            this.ccExterior.setModifiers(Modifier.setPublic((int)this.ccExterior.getModifiers()));
            this.ccExprInterface = this.pool.makeInterface(String.valueOf(ccInterior.getName()) + "$ExpressionElement");
        }
        catch (NotFoundException e) {
            throw new JavieRuntimeException(e);
        }
    }

    EffectDescriptor process() {
        try {
            this.processProperties();
            this.setInteriorClass();
            this.setType();
            this.implementsVideoEffect();
            this.implementsAudioEffect();
            Class interiorClass = this.ccInterior.toClass(this.cl, null);
            Class exteriorClass = this.ccExterior.toClass(this.cl, null);
            Class exprInterface = this.ccExprInterface.toClass(this.cl, null);
            return new EffectDescriptorImpl(this.type, interiorClass, exteriorClass, exprInterface);
        }
        catch (ClassNotFoundException e) {
            throw new JavieRuntimeException(e);
        }
        catch (NotFoundException e) {
            throw new JavieRuntimeException(e);
        }
        catch (CannotCompileException e) {
            throw new JavieRuntimeException(e);
        }
        catch (BadBytecode e) {
            throw new JavieRuntimeException(e);
        }
    }

    private void processProperties() throws ClassNotFoundException, NotFoundException, CannotCompileException, BadBytecode {
        CtClass enumType = this.pool.get("java.lang.Enum");
        CtField[] ctFieldArray = this.ccInterior.getDeclaredFields();
        int n = ctFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtField cf = ctFieldArray[n2];
            Property anno = (Property)cf.getAnnotation(Property.class);
            if (anno != null) {
                CtClass fieldType;
                String fieldTypeName;
                int mod = cf.getModifiers();
                if (Modifier.isPrivate((int)mod)) {
                    cf.setModifiers(Modifier.setPackage((int)mod));
                }
                if ((fieldTypeName = (fieldType = cf.getType()).getName()).equals("ch.kuramo.javie.api.plugin.PIAnimatableEnum")) {
                    this.processAnimatableEnumProperty(cf);
                } else if (fieldTypeName.startsWith("ch.kuramo.javie.api.plugin.PIAnimatable")) {
                    this.processAnimatableValueProperty(cf);
                } else if (fieldTypeName.equals("java.lang.String") || fieldType.subtypeOf(enumType) || fieldType.isPrimitive()) {
                    this.makeAccessor(fieldTypeName, cf.getName());
                }
            }
            ++n2;
        }
    }

    private void processAnimatableEnumProperty(CtField cf) throws NotFoundException, CannotCompileException, BadBytecode {
        SignatureAttribute fieldSig = (SignatureAttribute)cf.getFieldInfo().getAttribute("Signature");
        SignatureAttribute.ClassType fieldType = (SignatureAttribute.ClassType)SignatureAttribute.toFieldSignature((String)fieldSig.getSignature());
        SignatureAttribute.ClassType enumType = (SignatureAttribute.ClassType)fieldType.getTypeArguments()[0].getType();
        String enumName = enumType.getName();
        if (enumType instanceof SignatureAttribute.NestedClassType) {
            enumName = String.valueOf(((SignatureAttribute.NestedClassType)enumType).getDeclaringClass().getName()) + "$" + enumName;
        }
        CtClass ccAEnum = this.makeAnimatableEnum(enumName);
        this.makeAccessor(ccAEnum.getName(), cf.getName());
    }

    private void processAnimatableValueProperty(CtField cf) throws NotFoundException, CannotCompileException {
        String fieldTypeName = cf.getType().getName();
        String accessorTypeName = fieldTypeName.replaceFirst("^ch\\.kuramo\\.javie\\.api\\.plugin\\.PIAnimatable", "ch.kuramo.javie.core.Animatable");
        this.makeAccessor(accessorTypeName, cf.getName());
    }

    private CtClass makeAnimatableEnum(String enumName) throws NotFoundException, CannotCompileException {
        String enumNameSlash = enumName.replace('.', '/');
        CtClass ccAEnum = this.pool.getAndRename("ch.kuramo.javie.core.internal.templates.AnimatableEnumTemplate", String.valueOf(this.ccInterior.getName()) + "$AnimatableEnum" + ++this.countAEnum);
        ccAEnum.setModifiers(Modifier.setPublic((int)ccAEnum.getModifiers()));
        CtClass ccEnum = this.pool.get(enumName);
        CtClass ccCollection = this.pool.get("java.util.Collection");
        CtClass ccString = this.pool.get("java.lang.String");
        CtConstructor cnstr1 = new CtConstructor(new CtClass[]{ccEnum, ccCollection, ccString}, ccAEnum);
        cnstr1.setBody(String.format("super(%s.class, $1, $2, $3);", enumName));
        ccAEnum.addConstructor(cnstr1);
        CtConstructor cnstr2 = new CtConstructor(new CtClass[]{ccEnum}, ccAEnum);
        cnstr2.setBody(String.format("super(%s.class, $1);", enumName));
        ccAEnum.addConstructor(cnstr2);
        ClassFile classFile = ccAEnum.getClassFile();
        SignatureAttribute classSig = new SignatureAttribute(classFile.getConstPool(), String.format("Lch/kuramo/javie/core/AbstractAnimatableEnum<L%1$s;>;Lch/kuramo/javie/api/plugin/PIAnimatableEnum<L%1$s;>;", enumNameSlash));
        classFile.addAttribute((AttributeInfo)classSig);
        MethodInfo cnstr1Info = cnstr1.getMethodInfo();
        SignatureAttribute cstr1Sig = new SignatureAttribute(cnstr1Info.getConstPool(), String.format("(L%1$s;Ljava/util/Collection<Lch/kuramo/javie/core/Keyframe<L%1$s;>;>;Ljava/lang/String;)V", enumNameSlash));
        cnstr1Info.addAttribute((AttributeInfo)cstr1Sig);
        ccAEnum.toClass(this.cl, null);
        return ccAEnum;
    }

    private void makeAccessor(String typeName, String fieldName) throws CannotCompileException {
        String upperCamelCase = String.valueOf(Character.toUpperCase(fieldName.charAt(0))) + fieldName.substring(1);
        String interiorName = this.ccInterior.getName();
        String getter = String.format("public %1$s get%2$s() { return (%1$s) ((%3$s) _interior).%4$s; }", typeName, upperCamelCase, interiorName, fieldName);
        this.ccExterior.addMethod(CtMethod.make((String)getter, (CtClass)this.ccExterior));
        String setter = String.format("public void set%2$s(%1$s value) { ((%3$s) _interior).%4$s = value; }", typeName, upperCamelCase, interiorName, fieldName);
        this.ccExterior.addMethod(CtMethod.make((String)setter, (CtClass)this.ccExterior));
        String exprGetter = String.format("public abstract Object get%s();", upperCamelCase);
        this.ccExprInterface.addMethod(CtMethod.make((String)exprGetter, (CtClass)this.ccExprInterface));
    }

    private void setInteriorClass() {
        try {
            CtMethod method = this.ccExterior.getDeclaredMethod("getInteriorClass");
            method.setBody(String.format("return %s.class;", this.ccInterior.getName()));
        }
        catch (NotFoundException e) {
            throw new JavieRuntimeException(e);
        }
        catch (CannotCompileException e) {
            throw new JavieRuntimeException(e);
        }
    }

    private void setType() {
        try {
            CtMethod method = this.ccExterior.getDeclaredMethod("getType");
            method.setBody(String.format("return \"%s\";", this.type.replaceAll("\"", "\\\\\"")));
        }
        catch (NotFoundException e) {
            throw new JavieRuntimeException(e);
        }
        catch (CannotCompileException e) {
            throw new JavieRuntimeException(e);
        }
    }

    private void implementsVideoEffect() {
        CtMethod inBoundsMethod;
        CtMethod inEffectMethod;
        try {
            inEffectMethod = this.ccInterior.getDeclaredMethod("doVideoEffect");
        }
        catch (NotFoundException notFoundException) {
            return;
        }
        try {
            inBoundsMethod = this.ccInterior.getDeclaredMethod("getVideoBounds");
        }
        catch (NotFoundException notFoundException) {
            inBoundsMethod = null;
        }
        try {
            int mod = inEffectMethod.getModifiers();
            if (Modifier.isPrivate((int)mod)) {
                inEffectMethod.setModifiers(Modifier.setPackage((int)mod));
            }
            CtMethod exEffectMethod = this.ccExterior.getDeclaredMethod("doVideoEffect");
            exEffectMethod.setBody(String.format("return ((%s) _interior).doVideoEffect();", this.ccInterior.getName()));
            if (inBoundsMethod != null) {
                mod = inBoundsMethod.getModifiers();
                if (Modifier.isPrivate((int)mod)) {
                    inBoundsMethod.setModifiers(Modifier.setPackage((int)mod));
                }
                CtMethod exBoundsMethod = this.ccExterior.getDeclaredMethod("getVideoBounds");
                exBoundsMethod.setBody(String.format("return ((%s) _interior).getVideoBounds();", this.ccInterior.getName()));
            }
            this.ccExterior.addInterface(this.pool.get("ch.kuramo.javie.core.VideoEffect"));
        }
        catch (NotFoundException e) {
            throw new JavieRuntimeException(e);
        }
        catch (CannotCompileException e) {
            throw new JavieRuntimeException(e);
        }
    }

    private void implementsAudioEffect() {
        CtMethod inMethod;
        try {
            inMethod = this.ccInterior.getDeclaredMethod("doAudioEffect");
        }
        catch (NotFoundException notFoundException) {
            return;
        }
        try {
            int mod = inMethod.getModifiers();
            if (Modifier.isPrivate((int)mod)) {
                inMethod.setModifiers(Modifier.setPackage((int)mod));
            }
            CtMethod exMethod = this.ccExterior.getDeclaredMethod("doAudioEffect");
            exMethod.setBody(String.format("return ((%s) _interior).doAudioEffect();", this.ccInterior.getName()));
            this.ccExterior.addInterface(this.pool.get("ch.kuramo.javie.core.AudioEffect"));
        }
        catch (NotFoundException e) {
            throw new JavieRuntimeException(e);
        }
        catch (CannotCompileException e) {
            throw new JavieRuntimeException(e);
        }
    }
}

