/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.plugin.PIAnimatableBoolean;
import ch.kuramo.javie.api.plugin.PIAnimatableColor;
import ch.kuramo.javie.api.plugin.PIAnimatableDouble;
import ch.kuramo.javie.api.plugin.PIAnimatableEnum;
import ch.kuramo.javie.api.plugin.PIAnimatableInteger;
import ch.kuramo.javie.api.plugin.PIAnimatableString;
import ch.kuramo.javie.api.plugin.PIAnimatableVec2d;
import ch.kuramo.javie.api.plugin.PIAnimatableVec3d;
import ch.kuramo.javie.core.AnimatableBoolean;
import ch.kuramo.javie.core.AnimatableColor;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableInteger;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.AnimatableVec2d;
import ch.kuramo.javie.core.AnimatableVec3d;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectDescriptor;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.PropertyDescriptor;
import ch.kuramo.javie.core.Util;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EffectDescriptorImpl
implements EffectDescriptor {
    private final String _type;
    private final Class<?> _interiorClass;
    private final Class<Effect> _exteriorClass;
    private final Class<?> _exprInterface;
    private final ResourceBundle _bundle;
    private final String _category;
    private final String _label;
    private final Map<String, PropertyDescriptor> _propertyDescriptorMap;
    private final List<PropertyDescriptor> _propertyDescriptorList;

    EffectDescriptorImpl(String type, Class<?> interiorClass, Class<Effect> exteriorClass, Class<?> exprInterface) {
        this._type = type;
        this._interiorClass = interiorClass;
        this._exteriorClass = exteriorClass;
        this._exprInterface = exprInterface;
        this._bundle = this.getBundle();
        this._category = interiorClass.getAnnotation(ch.kuramo.javie.api.annotations.Effect.class).category().trim();
        this._label = this.getString("label");
        this._propertyDescriptorMap = Collections.unmodifiableMap(this.createPropertyDescriptors());
        this._propertyDescriptorList = Collections.unmodifiableList(Util.newList(this._propertyDescriptorMap.values()));
    }

    private ResourceBundle getBundle() {
        try {
            String className = this._interiorClass.getName();
            String bundleName = String.valueOf(className.substring(0, className.lastIndexOf(46) + 1)) + "messages";
            return ResourceBundle.getBundle(bundleName, Locale.getDefault(), this._interiorClass.getClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private String getString(String key) {
        String str = null;
        if (this._bundle != null) {
            try {
                str = this._bundle.getString(String.format("%s.%s", this._interiorClass.getSimpleName(), key));
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if (str == null) {
            str = String.valueOf('!') + key + '!';
        }
        return str;
    }

    private Map<String, PropertyDescriptor> createPropertyDescriptors() {
        LinkedHashMap<String, PropertyDescriptor> map = Util.newLinkedHashMap();
        Field[] fieldArray = this._interiorClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            Property anno = f.getAnnotation(Property.class);
            if (anno != null) {
                String name = f.getName();
                String label = this.getString(String.valueOf(name) + ".label");
                String value = anno.value();
                Class<?> type = f.getType();
                if (PIAnimatableDouble.class.isAssignableFrom(type)) {
                    map.put(name, new AnimatableDoublePropertyDescriptor(name, label, value));
                } else if (PIAnimatableInteger.class.isAssignableFrom(type)) {
                    map.put(name, new AnimatableIntegerPropertyDescriptor(name, label, value));
                } else if (PIAnimatableVec2d.class.isAssignableFrom(type)) {
                    map.put(name, new AnimatableVec2dPropertyDescriptor(name, label, value));
                } else if (PIAnimatableVec3d.class.isAssignableFrom(type)) {
                    map.put(name, new AnimatableVec3dPropertyDescriptor(name, label, value));
                } else if (PIAnimatableColor.class.isAssignableFrom(type)) {
                    map.put(name, new AnimatableColorPropertyDescriptor(name, label, value));
                } else if (PIAnimatableString.class.isAssignableFrom(type)) {
                    map.put(name, new AnimatableStringPropertyDescriptor(name, label, value));
                } else if (PIAnimatableBoolean.class.isAssignableFrom(type)) {
                    map.put(name, new AnimatableBooleanPropertyDescriptor(name, label, value));
                } else if (PIAnimatableEnum.class.isAssignableFrom(type)) {
                    map.put(name, new AnimatableEnumPropertyDescriptor(name, label, value));
                } else if (String.class.equals(type)) {
                    map.put(name, new StringPropertyDescriptor(name, label, value));
                } else if (Enum.class.isAssignableFrom(type)) {
                    Class<?> enumType = type;
                    map.put(name, new EnumPropertyDescriptor(name, label, value, enumType));
                } else if (type.isPrimitive()) {
                    map.put(name, new PrimitivePropertyDescriptor(name, label, value, type));
                }
            }
            ++n2;
        }
        return map;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public Class<Effect> getEffectClass() {
        return this._exteriorClass;
    }

    @Override
    public Class<?> getExpressionInterface() {
        return this._exprInterface;
    }

    @Override
    public String getCategory() {
        return this._category;
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public List<PropertyDescriptor> getPropertyDescriptors() {
        return this._propertyDescriptorList;
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this._propertyDescriptorMap.get(name);
    }

    private <A extends AnimatableValue<?>> Class<A> getPropertyType(String propertyName) {
        try {
            String upperCamelCase = String.valueOf(Character.toUpperCase(propertyName.charAt(0))) + propertyName.substring(1);
            Class<?> propertyType = this._exteriorClass.getMethod("get" + upperCamelCase, new Class[0]).getReturnType();
            return propertyType;
        }
        catch (NoSuchMethodException e) {
            throw new JavieRuntimeException(e);
        }
    }

    private static Boolean toBoolean(String s) {
        return Boolean.valueOf(s.trim());
    }

    private static Double toDouble(String s) {
        try {
            return Double.valueOf(s.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    private static Float toFloat(String s) {
        try {
            return Float.valueOf(s.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return Float.valueOf(0.0f);
        }
    }

    private static Long toLong(String s) {
        try {
            return Long.valueOf(s.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    private static Integer toInteger(String s) {
        try {
            return Integer.valueOf(s.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static Short toShort(String s) {
        try {
            return Short.valueOf(s.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return (short)0;
        }
    }

    private static Character toCharacter(String s) {
        try {
            return Character.valueOf((char)Integer.parseInt(s.trim()));
        }
        catch (NumberFormatException numberFormatException) {
            return Character.valueOf('\u0000');
        }
    }

    private static Byte toByte(String s) {
        try {
            return (byte)Integer.parseInt(s.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return (byte)0;
        }
    }

    private static Vec2d toVec2d(String s) {
        double x;
        double y;
        try {
            String[] array = s.trim().split("\\s*,\\s*");
            switch (array.length) {
                case 1: {
                    x = y = Double.valueOf(array[0]).doubleValue();
                    break;
                }
                default: {
                    x = Double.valueOf(array[0]);
                    y = Double.valueOf(array[1]);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            y = 0.0;
            x = 0.0;
        }
        return new Vec2d(x, y);
    }

    private static Vec3d toVec3d(String s) {
        double x;
        double y;
        double z;
        try {
            String[] array = s.trim().split("\\s*,\\s*");
            switch (array.length) {
                case 1: {
                    y = z = Double.valueOf(array[0]).doubleValue();
                    x = z;
                    break;
                }
                case 2: {
                    x = Double.valueOf(array[0]);
                    y = Double.valueOf(array[1]);
                    z = 0.0;
                    break;
                }
                default: {
                    x = Double.valueOf(array[0]);
                    y = Double.valueOf(array[1]);
                    z = Double.valueOf(array[2]);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            z = 0.0;
            y = 0.0;
            x = 0.0;
        }
        return new Vec3d(x, y, z);
    }

    private static Color toColor(String s) {
        double a;
        double r;
        double g;
        double b;
        try {
            String[] array = s.trim().split("\\s*,\\s*");
            switch (array.length) {
                case 1: {
                    g = b = Double.valueOf(array[0]).doubleValue();
                    r = b;
                    a = 1.0;
                    break;
                }
                case 2: {
                    g = b = Double.valueOf(array[0]).doubleValue();
                    r = b;
                    a = Double.valueOf(array[1]);
                    break;
                }
                case 3: {
                    r = Double.valueOf(array[0]);
                    g = Double.valueOf(array[1]);
                    b = Double.valueOf(array[2]);
                    a = 1.0;
                    break;
                }
                default: {
                    r = Double.valueOf(array[0]);
                    g = Double.valueOf(array[1]);
                    b = Double.valueOf(array[2]);
                    a = Double.valueOf(array[3]);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            b = 0.0;
            g = 0.0;
            r = 0.0;
            a = 1.0;
        }
        return new Color(r, g, b, a);
    }

    private static <E extends Enum<E>> E toEnum(Class<E> enumType, String s) {
        try {
            return Enum.valueOf(enumType, s.trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Enum first = (Enum)Array.get(enumType.getMethod("values", new Class[0]).invoke(null, new Object[0]), 0);
                return (E)first;
            }
            catch (IllegalAccessException e) {
                throw new JavieRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new JavieRuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new JavieRuntimeException(e);
            }
        }
    }

    private static Object toPrimitive(Class<?> primitiveType, String s) {
        if (primitiveType == Boolean.TYPE) {
            return EffectDescriptorImpl.toBoolean(s);
        }
        if (primitiveType == Double.TYPE) {
            return EffectDescriptorImpl.toDouble(s);
        }
        if (primitiveType == Float.TYPE) {
            return EffectDescriptorImpl.toFloat(s);
        }
        if (primitiveType == Long.TYPE) {
            return EffectDescriptorImpl.toLong(s);
        }
        if (primitiveType == Integer.TYPE) {
            return EffectDescriptorImpl.toInteger(s);
        }
        if (primitiveType == Short.TYPE) {
            return EffectDescriptorImpl.toShort(s);
        }
        if (primitiveType == Character.TYPE) {
            return EffectDescriptorImpl.toCharacter(s);
        }
        if (primitiveType == Byte.TYPE) {
            return EffectDescriptorImpl.toByte(s);
        }
        throw new JavieRuntimeException("unsupported type: " + primitiveType.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractPropertyDescriptor<T>
    implements PropertyDescriptor {
        protected final Class<T> type;
        protected final String name;
        protected final String label;
        protected final Method getter;
        protected final Method setter;

        private AbstractPropertyDescriptor(Class<T> type, String name, String label) {
            this.type = type;
            this.name = name;
            this.label = label;
            try {
                String upperCamelCase = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
                this.getter = EffectDescriptorImpl.this._exteriorClass.getDeclaredMethod("get" + upperCamelCase, new Class[0]);
                this.setter = EffectDescriptorImpl.this._exteriorClass.getDeclaredMethod("set" + upperCamelCase, type);
            }
            catch (NoSuchMethodException e) {
                throw new JavieRuntimeException(e);
            }
        }

        public Class<T> getPropertyClass() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public void afterDecode(Project p, Effect effect) throws ProjectDecodeException {
        }

        public T get(Effect effect) {
            try {
                Object value = this.getter.invoke((Object)effect, new Object[0]);
                return (T)value;
            }
            catch (IllegalAccessException e) {
                throw new JavieRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new JavieRuntimeException(e);
            }
        }

        protected void set(Effect effect, T value) {
            try {
                this.setter.invoke((Object)effect, value);
            }
            catch (IllegalAccessException e) {
                throw new JavieRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new JavieRuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnimatableBooleanPropertyDescriptor
    extends AbstractPropertyDescriptor<AnimatableBoolean> {
        private final Boolean value;

        private AnimatableBooleanPropertyDescriptor(String name, String label, String value) {
            super(AnimatableBoolean.class, name, label);
            this.value = EffectDescriptorImpl.toBoolean(value);
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, new AnimatableBoolean(this.value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnimatableColorPropertyDescriptor
    extends AbstractPropertyDescriptor<AnimatableColor> {
        private final Color value;

        private AnimatableColorPropertyDescriptor(String name, String label, String value) {
            super(AnimatableColor.class, name, label);
            this.value = EffectDescriptorImpl.toColor(value);
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, new AnimatableColor(this.value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnimatableDoublePropertyDescriptor
    extends AbstractPropertyDescriptor<AnimatableDouble> {
        private final Double value;

        private AnimatableDoublePropertyDescriptor(String name, String label, String value) {
            super(AnimatableDouble.class, name, label);
            this.value = EffectDescriptorImpl.toDouble(value);
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, new AnimatableDouble(this.value));
        }
    }

    private class AnimatableEnumPropertyDescriptor
    extends AbstractPropertyDescriptor {
        private final Class<Enum> enumType;
        private final Constructor<?> constructor;
        private final Enum value;

        private AnimatableEnumPropertyDescriptor(String name, String label, String value) {
            super(EffectDescriptorImpl.this.getPropertyType(name), name, label);
            try {
                ParameterizedType genericSuper = (ParameterizedType)this.type.getGenericSuperclass();
                this.enumType = (Class)genericSuper.getActualTypeArguments()[0];
                this.constructor = this.type.getConstructor(this.enumType);
                this.value = EffectDescriptorImpl.toEnum(this.enumType, value);
            }
            catch (NoSuchMethodException e) {
                throw new JavieRuntimeException(e);
            }
        }

        public void initValue(Effect effect) {
            try {
                this.set(effect, this.constructor.newInstance(this.value));
            }
            catch (InstantiationException e) {
                throw new JavieRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new JavieRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new JavieRuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnimatableIntegerPropertyDescriptor
    extends AbstractPropertyDescriptor<AnimatableInteger> {
        private final Integer value;

        private AnimatableIntegerPropertyDescriptor(String name, String label, String value) {
            super(AnimatableInteger.class, name, label);
            this.value = EffectDescriptorImpl.toInteger(value);
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, new AnimatableInteger(this.value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnimatableStringPropertyDescriptor
    extends AbstractPropertyDescriptor<AnimatableString> {
        private final String value;

        private AnimatableStringPropertyDescriptor(String name, String label, String value) {
            super(AnimatableString.class, name, label);
            this.value = value;
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, new AnimatableString(this.value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnimatableVec2dPropertyDescriptor
    extends AbstractPropertyDescriptor<AnimatableVec2d> {
        private final Vec2d value;

        private AnimatableVec2dPropertyDescriptor(String name, String label, String value) {
            super(AnimatableVec2d.class, name, label);
            this.value = EffectDescriptorImpl.toVec2d(value);
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, new AnimatableVec2d(this.value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnimatableVec3dPropertyDescriptor
    extends AbstractPropertyDescriptor<AnimatableVec3d> {
        private final Vec3d value;

        private AnimatableVec3dPropertyDescriptor(String name, String label, String value) {
            super(AnimatableVec3d.class, name, label);
            this.value = EffectDescriptorImpl.toVec3d(value);
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, new AnimatableVec3d(this.value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnumPropertyDescriptor
    extends AbstractPropertyDescriptor<Enum> {
        private final Enum value;

        private EnumPropertyDescriptor(String name, String label, String value, Class<Enum> enumType) {
            super(enumType, name, label);
            this.value = EffectDescriptorImpl.toEnum(enumType, value);
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrimitivePropertyDescriptor
    extends AbstractPropertyDescriptor {
        private final Object value;

        private PrimitivePropertyDescriptor(String name, String label, String value, Class<?> primitiveType) {
            super(primitiveType, name, label);
            this.value = EffectDescriptorImpl.toPrimitive(primitiveType, value);
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringPropertyDescriptor
    extends AbstractPropertyDescriptor<String> {
        private final String value;

        private StringPropertyDescriptor(String name, String label, String value) {
            super(String.class, name, label);
            this.value = value;
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, this.value);
        }
    }
}

