/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.plugin.PIAnimatableValue;
import ch.kuramo.javie.api.plugin.PIAudioBuffer;
import ch.kuramo.javie.api.plugin.PIAudioRenderContext;
import ch.kuramo.javie.core.Util;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PIAudioRenderContextProxy
implements PIAudioRenderContext {
    private static final ThreadLocal<LinkedList<PIAudioRenderContext>> _threadLocal = new ThreadLocal();

    static void push(PIAudioRenderContext impl) {
        PIAudioRenderContextProxy.getStack(true).addLast(impl);
    }

    static void pop() {
        LinkedList<PIAudioRenderContext> stack = PIAudioRenderContextProxy.getStack(false);
        stack.removeLast();
        if (stack.isEmpty()) {
            _threadLocal.remove();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LinkedList<PIAudioRenderContext> getStack(boolean create) {
        void var1_3;
        LinkedList<PIAudioRenderContext> linkedList = _threadLocal.get();
        if (linkedList == null) {
            if (!create) throw new IllegalStateException("no stack is found");
            LinkedList linkedList2 = Util.newLinkedList();
            _threadLocal.set(linkedList2);
            return var1_3;
        } else {
            if (!linkedList.isEmpty()) return var1_3;
            throw new IllegalStateException("stack is empty");
        }
    }

    private PIAudioRenderContext getImpl() {
        return PIAudioRenderContextProxy.getStack(false).getLast();
    }

    public PIAudioBuffer doPreviousEffect() {
        return this.getImpl().doPreviousEffect();
    }

    public Time getTime() {
        return this.getImpl().getTime();
    }

    public void setTime(Time time) {
        this.getImpl().setTime(time);
    }

    public <V> V value(PIAnimatableValue<V> avalue) {
        return (V)this.getImpl().value(avalue);
    }

    public AudioMode getAudioMode() {
        return this.getImpl().getAudioMode();
    }

    public int getFrameCount() {
        return this.getImpl().getFrameCount();
    }

    public void setFrameCount(int count) {
        this.getImpl().setFrameCount(count);
    }

    public PIAudioBuffer createAudioBuffer() {
        return this.getImpl().createAudioBuffer();
    }
}

