/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.annotations.GLProgram;
import ch.kuramo.javie.api.annotations.GLShader;
import ch.kuramo.javie.api.plugin.PIShaderRegistry;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.internal.services.ShaderProgramImpl;
import ch.kuramo.javie.core.internal.services.Uniform;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.ShaderBuildException;
import ch.kuramo.javie.core.services.ShaderRegistry;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.Threading;
import javax.media.opengl.glu.GLU;
import org.scannotation.AnnotationDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShaderRegistryImpl
implements ShaderRegistry,
PIShaderRegistry {
    private static final Logger _logger = LoggerFactory.getLogger(ShaderRegistryImpl.class);
    private final Map<String, Integer> _shaders = Util.newMap();
    private final Map<String, ShaderProgramImpl> _programs = Util.newMap();
    @Inject
    private GLGlobal _glGlobal;

    private int getShader(String name) {
        Integer shader = this._shaders.get(name);
        return shader != null ? shader : 0;
    }

    private int getShader(Class<?> clazz, String name) {
        return this.getShader(this.fqfn(clazz, name));
    }

    private ShaderProgramImpl getProgram(String name) {
        return this._programs.get(name);
    }

    @Override
    public ShaderProgramImpl getProgram(Class<?> clazz, String name) {
        return this.getProgram(this.fqfn(clazz, name));
    }

    private void registerShader(Field field, int shader) throws ShaderBuildException {
        String name = this.fqfn(field);
        if (this._shaders.containsKey(name)) {
            throw new ShaderBuildException(field, "Same name shader already exists.");
        }
        this._shaders.put(name, shader);
    }

    private void registerProgram(Field field, int program, Map<String, Uniform> uniforms) throws ShaderBuildException {
        String name = this.fqfn(field);
        if (this._programs.containsKey(name)) {
            throw new ShaderBuildException(field, "Same name program already exists.");
        }
        this._programs.put(name, new ShaderProgramImpl(name, program, uniforms));
    }

    private String fqfn(Class<?> clazz, String name) {
        return String.valueOf(clazz.getName()) + "." + name;
    }

    private String fqfn(Field field) {
        return this.fqfn(field.getDeclaringClass(), field.getName());
    }

    private String[] getSource(Field field) throws ShaderBuildException {
        String[] source;
        Object fieldValue;
        try {
            fieldValue = field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new ShaderBuildException(field, (Throwable)e);
        }
        Class<?> fieldType = field.getType();
        if (fieldType == String[].class) {
            source = (String[])fieldValue;
        } else {
            if (fieldType == String.class) {
                InputStream in = field.getDeclaringClass().getResourceAsStream((String)fieldValue);
                if (in == null) {
                    throw new ShaderBuildException(field, "no such resource found: " + fieldValue);
                }
                try {
                    ArrayList<String> lines = new ArrayList<String>();
                    BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            lines.add(line);
                        }
                    }
                    finally {
                        br.close();
                    }
                    source = lines.toArray(new String[lines.size()]);
                }
                catch (IOException e) {
                    throw new ShaderBuildException(field, (Throwable)e);
                }
            }
            throw new ShaderBuildException(field, "Only String or String[] is allowed to the field type of GLShader.");
        }
        if (source == null || source.length == 0) {
            throw new ShaderBuildException(field, "Source is null or empty.");
        }
        return source;
    }

    private int compileShader(GL gl, int type, String[] source, Field field) throws ShaderBuildException {
        String infoLog;
        int shader = gl.glCreateShader(type);
        if (shader == 0) {
            throw new ShaderBuildException(field, "glCreateShader failed.");
        }
        gl.glShaderSource(shader, source.length, source, null, 0);
        gl.glCompileShader(shader);
        int[] status = new int[1];
        gl.glGetShaderiv(shader, 35713, status, 0);
        if (status[0] == 1) {
            return shader;
        }
        int[] length = new int[1];
        gl.glGetShaderiv(shader, 35716, length, 0);
        byte[] infoLogBuf = new byte[length[0]];
        gl.glGetShaderInfoLog(shader, length[0], length, 0, infoLogBuf, 0);
        try {
            infoLog = new String(infoLogBuf, 0, length[0], "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            infoLog = new String(infoLogBuf, 0, length[0]);
        }
        _logger.error(String.format("[%s] compile failed: %s", this.fqfn(field), infoLog));
        gl.glDeleteShader(shader);
        return 0;
    }

    private int linkProgram(GL gl, int shader, String[] otherShaderNames, Field field) throws ShaderBuildException {
        String infoLog;
        int program = gl.glCreateProgram();
        if (program == 0) {
            throw new ShaderBuildException(field, "glCreateProgram failed.");
        }
        gl.glAttachShader(program, shader);
        String[] stringArray = otherShaderNames;
        int n = otherShaderNames.length;
        int n2 = 0;
        while (n2 < n) {
            String otherShaderName = stringArray[n2];
            int otherShader = otherShaderName.indexOf(46) == -1 ? this.getShader(field.getDeclaringClass(), otherShaderName) : this.getShader(otherShaderName);
            if (otherShader == 0) {
                _logger.error(String.format("[%s] no such shader found: %s", this.fqfn(field), otherShaderName));
                gl.glDeleteProgram(program);
                return 0;
            }
            gl.glAttachShader(program, otherShader);
            ++n2;
        }
        gl.glLinkProgram(program);
        int[] status = new int[1];
        gl.glGetProgramiv(program, 35714, status, 0);
        if (status[0] == 1) {
            return program;
        }
        int[] length = new int[1];
        gl.glGetProgramiv(program, 35716, length, 0);
        byte[] infoLogBuf = new byte[length[0]];
        gl.glGetProgramInfoLog(program, length[0], length, 0, infoLogBuf, 0);
        try {
            infoLog = new String(infoLogBuf, 0, length[0], "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            infoLog = new String(infoLogBuf, 0, length[0]);
        }
        _logger.error(String.format("[%s] link failed: %s", this.fqfn(field), infoLog));
        gl.glDeleteProgram(program);
        return 0;
    }

    private Map<String, Uniform> getUniform(GL gl, int program, Field field) {
        HashMap<String, Uniform> map = new HashMap<String, Uniform>();
        int[] int3 = new int[3];
        gl.glGetProgramiv(program, 35718, int3, 0);
        int activeUniforms = int3[0];
        gl.glGetProgramiv(program, 35719, int3, 0);
        int bufSize = int3[0];
        byte[] nameBuf = new byte[bufSize];
        int i = 0;
        while (i < activeUniforms) {
            String name;
            gl.glGetActiveUniform(program, i, bufSize, int3, 0, int3, 1, int3, 2, nameBuf, 0);
            int error = gl.glGetError();
            if (error != 0) {
                _logger.error(String.format("[%s] glGetActiveUniform failed: %s", this.fqfn(field), new GLU().gluErrorString(error)));
            }
            try {
                name = new String(nameBuf, 0, int3[0], "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                name = new String(nameBuf, 0, int3[0]);
            }
            int location = gl.glGetUniformLocation(program, name);
            map.put(name, new Uniform(location, int3[1], int3[2]));
            ++i;
        }
        return map;
    }

    private void buildShader(final Field field, GLShader shaderAnno, final GLProgram programAnno) throws ShaderBuildException {
        int type;
        switch (shaderAnno.value()) {
            case VERTEX_SHADER: {
                type = 35633;
                break;
            }
            case FRAGMENT_SHADER: {
                type = 35632;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported ShaderType: " + shaderAnno.value());
            }
        }
        final String[] source = this.getSource(field);
        final ShaderBuildException[] exception = new ShaderBuildException[1];
        Threading.invokeOnOpenGLThread((Runnable)new Runnable(){

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                context = ShaderRegistryImpl.access$3(ShaderRegistryImpl.this).getSharedContext();
                context.makeCurrent();
                try {
                    gl = context.getGL();
                    shader = ShaderRegistryImpl.access$4(ShaderRegistryImpl.this, gl, type, source, field);
                    if (shader == 0) {
                        return;
                    }
                    if (programAnno == null) ** GOTO lbl17
                    program = ShaderRegistryImpl.access$5(ShaderRegistryImpl.this, gl, shader, programAnno.attach(), field);
                    if (program == 0) {
                        return;
                    }
                    uniforms = ShaderRegistryImpl.access$6(ShaderRegistryImpl.this, gl, program, field);
                    ShaderRegistryImpl.access$7(ShaderRegistryImpl.this, field, program, uniforms);
                    return;
lbl17:
                    // 1 sources

                    ShaderRegistryImpl.access$8(ShaderRegistryImpl.this, field, shader);
                    return;
                }
                catch (ShaderBuildException e) {
                    exception[0] = e;
                    return;
                }
                finally {
                    context.release();
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    @Override
    public void buildShaders(AnnotationDB db, ClassLoader cl) throws ShaderBuildException {
        HashSet classNames = new HashSet();
        Util.addAll((Collection)db.getAnnotationIndex().get(GLShader.class.getName()), classNames);
        Util.addAll((Collection)db.getAnnotationIndex().get(GLProgram.class.getName()), classNames);
        for (String className : classNames) {
            Class<?> clazz;
            try {
                clazz = Class.forName(className, true, cl);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            Field[] fieldArray = clazz.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                GLShader shaderAnno = null;
                GLProgram programAnno = null;
                Annotation[] annotationArray = field.getAnnotations();
                int n3 = annotationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Annotation fieldAnno = annotationArray[n4];
                    if (fieldAnno instanceof GLShader) {
                        shaderAnno = (GLShader)fieldAnno;
                    } else if (fieldAnno instanceof GLProgram) {
                        programAnno = (GLProgram)fieldAnno;
                    }
                    ++n4;
                }
                if (shaderAnno == null) {
                    if (programAnno != null) {
                        throw new ShaderBuildException(field, "GLProgram without GLShader");
                    }
                } else {
                    this.buildShader(field, shaderAnno, programAnno);
                }
                ++n2;
            }
        }
    }

    static /* synthetic */ GLGlobal access$3(ShaderRegistryImpl shaderRegistryImpl) {
        return shaderRegistryImpl._glGlobal;
    }

    static /* synthetic */ int access$4(ShaderRegistryImpl shaderRegistryImpl, GL gL, int n, String[] stringArray, Field field) throws ShaderBuildException {
        return shaderRegistryImpl.compileShader(gL, n, stringArray, field);
    }

    static /* synthetic */ int access$5(ShaderRegistryImpl shaderRegistryImpl, GL gL, int n, String[] stringArray, Field field) throws ShaderBuildException {
        return shaderRegistryImpl.linkProgram(gL, n, stringArray, field);
    }

    static /* synthetic */ Map access$6(ShaderRegistryImpl shaderRegistryImpl, GL gL, int n, Field field) {
        return shaderRegistryImpl.getUniform(gL, n, field);
    }

    static /* synthetic */ void access$7(ShaderRegistryImpl shaderRegistryImpl, Field field, int n, Map map) throws ShaderBuildException {
        shaderRegistryImpl.registerProgram(field, n, map);
    }

    static /* synthetic */ void access$8(ShaderRegistryImpl shaderRegistryImpl, Field field, int n) throws ShaderBuildException {
        shaderRegistryImpl.registerShader(field, n);
    }
}

