/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.shaders;

import ch.kuramo.javie.api.annotations.GLProgram;
import ch.kuramo.javie.api.annotations.GLShader;

public class BlendModeShaders {
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    public static final String[] blend_functions = new String[]{"const vec3 lumaVec = vec3(0.299, 0.587, 0.114);", "const vec2 randVec = vec2(12.9898, 78.233);", "", "float rand1(vec2 coord, float time)", "{", "\treturn fract(sin(dot(coord, randVec + time)) * 43758.5453);", "}", "vec4 blend_normal(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tpSrc *= opacity;", "\treturn pSrc + pDst*(1.0-pSrc.a);", "}", "vec4 blend_dissolve(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat rand = rand1(gl_TexCoord[0].st, 0.0);", "\tfloat a = pSrc.a*opacity;", "\treturn (rand < a || a >= 1.0) ? vec4(pSrc.rgb/pSrc.a, 1.0) : pDst;", "}", "vec4 blend_dancing_dissolve(vec4 pDst, vec4 pSrc, float opacity, float time)", "{", "\tfloat rand = rand1(gl_TexCoord[0].st, time);", "\tfloat a = pSrc.a*opacity;", "\treturn (rand < a || a >= 1.0) ? vec4(pSrc.rgb/pSrc.a, 1.0) : pDst;", "}", "vec4 blend_darken(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\treturn vec4(min(uSrc3, pDst3 + min(uSrc3, cda))*sa + pDst3*csa, a);", "}", "vec4 blend_multiply(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 pSrc3 = pSrc.rgb;", "", "\treturn vec4(pSrc3*(pDst3 + cda)*opacity + pDst3*csa, a);", "}", "vec4 blend_color_burn(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\tfloat r = uSrc3.r+uDst3.r<1.0 ? 0.0 : uSrc3.r>0.0 ? 1.0-(1.0-uDst3.r)/uSrc3.r : 1.0;", "\tfloat g = uSrc3.g+uDst3.g<1.0 ? 0.0 : uSrc3.g>0.0 ? 1.0-(1.0-uDst3.g)/uSrc3.g : 1.0;", "\tfloat b = uSrc3.b+uDst3.b<1.0 ? 0.0 : uSrc3.b>0.0 ? 1.0-(1.0-uDst3.b)/uSrc3.b : 1.0;", "", "\treturn vec4((vec3(r, g, b)*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_linear_burn(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\treturn vec4((max(uSrc3+uDst3-1.0, 0.0)*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_darker_color(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\tfloat dy = dot(uDst3, lumaVec);", "\tfloat sy = dot(uSrc3, lumaVec);", "", "\treturn vec4(((dy < sy ? uDst3 : uSrc3)*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_add(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat a = pSrc.a*opacity + pDst.a*(1.0 - pSrc.a*opacity);", "\treturn vec4(pSrc.rgb*opacity + pDst.rgb, a);", "}", "vec4 blend_lighten(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\treturn vec4(max(uSrc3, pDst3)*sa + pDst3*csa, a);", "}", "vec4 blend_screen(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\treturn vec4(((1.0-(1.0-uDst3)*(1.0-uSrc3))*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_color_dodge(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\tfloat r = uSrc3.r+uDst3.r>1.0 ? 1.0 : uDst3.r>0.0 ? uDst3.r/(1.0-uSrc3.r) : 0.0;", "\tfloat g = uSrc3.g+uDst3.g>1.0 ? 1.0 : uDst3.g>0.0 ? uDst3.g/(1.0-uSrc3.g) : 0.0;", "\tfloat b = uSrc3.b+uDst3.b>1.0 ? 1.0 : uDst3.b>0.0 ? uDst3.b/(1.0-uSrc3.b) : 0.0;", "", "\treturn vec4((vec3(r, g, b)*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_linear_dodge(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\treturn vec4((min(uSrc3+uDst3, 1.0)*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_lighter_color(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\tfloat dy = dot(uDst3, lumaVec);", "\tfloat sy = dot(uSrc3, lumaVec);", "", "\treturn vec4(((dy > sy ? uDst3 : uSrc3)*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_overlay(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\tfloat r = uDst3.r<0.5 ? 2.0*uSrc3.r*uDst3.r : 1.0-2.0*(1.0-uSrc3.r)*(1.0-uDst3.r);", "\tfloat g = uDst3.g<0.5 ? 2.0*uSrc3.g*uDst3.g : 1.0-2.0*(1.0-uSrc3.g)*(1.0-uDst3.g);", "\tfloat b = uDst3.b<0.5 ? 2.0*uSrc3.b*uDst3.b : 1.0-2.0*(1.0-uSrc3.b)*(1.0-uDst3.b);", "", "\treturn vec4((vec3(r, g, b)*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_soft_light(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\tfloat r = uSrc3.r<0.5           ? uDst3.r+(uDst3.r-uDst3.r*uDst3.r)*(2.0*uSrc3.r-1.0) :", "\t\t\t  uDst3.r<=(32.0/255.0) ? uDst3.r+(uDst3.r-uDst3.r*uDst3.r)*(2.0*uSrc3.r-1.0)*(3.0-8.0*uDst3.r) :", "\t\t\t                          uDst3.r+(sqrt(uDst3.r)-uDst3.r)*(2.0*uSrc3.r-1.0);", "\tfloat g = uSrc3.g<0.5           ? uDst3.g+(uDst3.g-uDst3.g*uDst3.g)*(2.0*uSrc3.g-1.0) :", "\t\t\t  uDst3.g<=(32.0/255.0) ? uDst3.g+(uDst3.g-uDst3.g*uDst3.g)*(2.0*uSrc3.g-1.0)*(3.0-8.0*uDst3.g) :", "\t\t\t                          uDst3.g+(sqrt(uDst3.g)-uDst3.g)*(2.0*uSrc3.g-1.0);", "\tfloat b = uSrc3.b<0.5           ? uDst3.b+(uDst3.b-uDst3.b*uDst3.b)*(2.0*uSrc3.b-1.0) :", "\t\t\t  uDst3.b<=(32.0/255.0) ? uDst3.b+(uDst3.b-uDst3.b*uDst3.b)*(2.0*uSrc3.b-1.0)*(3.0-8.0*uDst3.b) :", "\t\t\t                          uDst3.b+(sqrt(uDst3.b)-uDst3.b)*(2.0*uSrc3.b-1.0);", "\tfloat r2 = uSrc3.r<0.5 ? 0.5*uSrc3.r+0.25 : 0.414214*uSrc3.r+0.292893;", "\tfloat g2 = uSrc3.g<0.5 ? 0.5*uSrc3.g+0.25 : 0.414214*uSrc3.g+0.292893;", "\tfloat b2 = uSrc3.b<0.5 ? 0.5*uSrc3.b+0.25 : 0.414214*uSrc3.b+0.292893;", "", "\treturn vec4((vec3(r, g, b)*da + vec3(r2, g2, b2)*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_hard_light(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\tfloat r = uSrc3.r<0.5 ? 2.0*uDst3.r*uSrc3.r : 1.0-2.0*(1.0-uDst3.r)*(1.0-uSrc3.r);", "\tfloat g = uSrc3.g<0.5 ? 2.0*uDst3.g*uSrc3.g : 1.0-2.0*(1.0-uDst3.g)*(1.0-uSrc3.g);", "\tfloat b = uSrc3.b<0.5 ? 2.0*uDst3.b*uSrc3.b : 1.0-2.0*(1.0-uDst3.b)*(1.0-uSrc3.b);", "", "\treturn vec4((vec3(r, g, b)*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_linear_light(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\tfloat r = uSrc3.r<0.5 ? (uDst3.r<1.0-uSrc3.r*2.0 ? 0.0 : uSrc3.r*2.0+uDst3.r-1.0)", "\t\t\t\t\t\t  : (uDst3.r<2.0-uSrc3.r*2.0 ? uSrc3.r*2.0+uDst3.r-1.0 : 1.0);", "\tfloat g = uSrc3.g<0.5 ? (uDst3.g<1.0-uSrc3.g*2.0 ? 0.0 : uSrc3.g*2.0+uDst3.g-1.0)", "\t\t\t\t\t\t  : (uDst3.g<2.0-uSrc3.g*2.0 ? uSrc3.g*2.0+uDst3.g-1.0 : 1.0);", "\tfloat b = uSrc3.b<0.5 ? (uDst3.b<1.0-uSrc3.b*2.0 ? 0.0 : uSrc3.b*2.0+uDst3.b-1.0)", "\t\t\t\t\t\t  : (uDst3.b<2.0-uSrc3.b*2.0 ? uSrc3.b*2.0+uDst3.b-1.0 : 1.0);", "", "\treturn vec4((vec3(r, g, b)*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_vivid_light(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\tfloat r = uSrc3.r<0.5 ? (uDst3.r<=1.0-uSrc3.r*2.0 ? 0.0 : (uDst3.r-(1.0-uSrc3.r*2.0))/(uSrc3.r*2.0))", "\t\t\t\t\t\t  : (uDst3.r< 2.0-uSrc3.r*2.0 ? uDst3.r/(2.0-uSrc3.r*2.0) : 1.0);", "\tfloat g = uSrc3.g<0.5 ? (uDst3.g<=1.0-uSrc3.g*2.0 ? 0.0 : (uDst3.g-(1.0-uSrc3.g*2.0))/(uSrc3.g*2.0))", "\t\t\t\t\t\t  : (uDst3.g< 2.0-uSrc3.g*2.0 ? uDst3.g/(2.0-uSrc3.g*2.0) : 1.0);", "\tfloat b = uSrc3.b<0.5 ? (uDst3.b<=1.0-uSrc3.b*2.0 ? 0.0 : (uDst3.b-(1.0-uSrc3.b*2.0))/(uSrc3.b*2.0))", "\t\t\t\t\t\t  : (uDst3.b< 2.0-uSrc3.b*2.0 ? uDst3.b/(2.0-uSrc3.b*2.0) : 1.0);", "", "\treturn vec4((vec3(r, g, b)*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_pin_light(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\tfloat r = uSrc3.r<0.5 ? min(uSrc3.r*2.0, uDst3.r) : max(uSrc3.r*2.0-1.0, uDst3.r);", "\tfloat g = uSrc3.g<0.5 ? min(uSrc3.g*2.0, uDst3.g) : max(uSrc3.g*2.0-1.0, uDst3.g);", "\tfloat b = uSrc3.b<0.5 ? min(uSrc3.b*2.0, uDst3.b) : max(uSrc3.b*2.0-1.0, uDst3.b);", "", "\treturn vec4((vec3(r, g, b)*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_hard_mix(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\tfloat r = (uSrc3.r+uDst3.r>1.0 || uDst3.r >= 1.0) ? 1.0 : 0.0;", "\tfloat g = (uSrc3.g+uDst3.g>1.0 || uDst3.g >= 1.0) ? 1.0 : 0.0;", "\tfloat b = (uSrc3.b+uDst3.b>1.0 || uDst3.b >= 1.0) ? 1.0 : 0.0;", "", "\treturn vec4((vec3(r, g, b)*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_difference(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\treturn vec4((abs(uSrc3-uDst3)*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_exclusion(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\tfloat r = (1.0-uDst3.r)*uSrc3.r+(1.0-uSrc3.r)*uDst3.r;", "\tfloat g = (1.0-uDst3.g)*uSrc3.g+(1.0-uSrc3.g)*uDst3.g;", "\tfloat b = (1.0-uDst3.b)*uSrc3.b+(1.0-uSrc3.b)*uDst3.b;", "", "\treturn vec4((vec3(r, g, b)*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec3 rgb2hsl(vec3 rgb)", "{", "\tfloat min = min(min(rgb.r, rgb.g), rgb.b);", "\tfloat max = max(max(rgb.r, rgb.g), rgb.b);", "\tfloat mmDelta = max - min;", "\tfloat mmSum = max + min;", "\tfloat luma = mmSum * 0.5;", "\tfloat hue, sat;", "", "\tif (mmDelta == 0.0) {", "\t\thue = 0.0;", "\t\tsat = 0.0;", "\t} else {", "\t\tsat = (luma < 0.5) ? mmDelta / mmSum", "\t\t\t\t\t\t   : mmDelta / (2.0 - mmSum);", "", "\t\tvec3 rgbDelta = ((max-rgb)/6.0 + max*0.5) / max;", "", "\t\thue = rgb.r == max ? rgbDelta.b - rgbDelta.g :", "\t\t\t  rgb.g == max ? rgbDelta.r - rgbDelta.b + 1.0/3.0 :", "\t\t\t                 rgbDelta.g - rgbDelta.r + 2.0/3.0;", "", "\t\tif (hue < 0.0) hue += 1.0;", "\t\telse if (hue > 1.0) hue -= 1.0;", "\t}", "\treturn vec3(hue, sat, luma);", "}", "float hue2rgb(float t1, float t2, float hue)", "{", "\tif (hue < 0.0) hue += 1.0;", "\telse if (hue > 1.0) hue -= 1.0;", "", "\treturn (hue*6.0 < 1.0) ? t1 + (t2-t1)*6.0*hue :", "\t\t   (hue*2.0 < 1.0) ? t2 :", "\t\t   (hue*3.0 < 2.0) ? t1 + (t2-t1)*(2.0/3.0-hue)*6.0 :", "\t\t                     t1;", "}", "vec3 hsl2rgb(vec3 hsl)", "{", "\tfloat hue = hsl.x;", "\tfloat sat = hsl.y;", "\tfloat luma = hsl.z;", "\tvec3 rgb;", "", "\tif (sat == 0.0) {", "\t\trgb = vec3(luma);", "\t} else {", "\t\tfloat t2 = (luma < 0.5) ? luma*(1.0+sat) : luma+sat-luma*sat;", "\t\tfloat t1 = luma*2.0 - t2;", "", "\t\trgb = vec3(", "\t\t\t\thue2rgb(t1, t2, hue+1.0/3.0),", "\t\t\t\thue2rgb(t1, t2, hue),", "\t\t\t\thue2rgb(t1, t2, hue-1.0/3.0));", "\t}", "\treturn rgb;", "}", "vec3 rgb2lab(vec3 rgb)", "{", "\trgb.r = (rgb.r > 0.04045) ? pow((rgb.r+0.055)/1.055, 2.4) : rgb.r/12.92;", "\trgb.g = (rgb.g > 0.04045) ? pow((rgb.g+0.055)/1.055, 2.4) : rgb.g/12.92;", "\trgb.b = (rgb.b > 0.04045) ? pow((rgb.b+0.055)/1.055, 2.4) : rgb.b/12.92;", "", "\tfloat x = dot(rgb, vec3(41.24, 35.76, 18.05)) /  95.047;", "\tfloat y = dot(rgb, vec3(21.26, 71.52,  7.22)) / 100.000;", "\tfloat z = dot(rgb, vec3( 1.93, 11.92, 95.05)) / 108.883;", "", "\tx = (x > 0.008856) ? pow(x, 1.0/3.0) : (7.787*x)+(16.0/116.0);", "\ty = (y > 0.008856) ? pow(y, 1.0/3.0) : (7.787*y)+(16.0/116.0);", "\tz = (z > 0.008856) ? pow(z, 1.0/3.0) : (7.787*z)+(16.0/116.0);", "", "\treturn vec3(116.0*y-16.0, 500.0*(x-y), 200.0*(y-z));", "}", "vec3 lab2rgb(vec3 lab)", "{", "\tfloat y = (lab.s + 16.0) / 116.0;", "\tfloat x = lab.t / 500.0 + y;", "\tfloat z = y - lab.p / 200.0;", "", "\tvec3 xyz = pow(vec3(x,y,z), vec3(3.0));", "", "\ty = (xyz.y > 0.008856) ? xyz.y : (y - 16.0 / 116.0) / 7.787;", "\tx = (xyz.x > 0.008856) ? xyz.x : (x - 16.0 / 116.0) / 7.787;", "\tz = (xyz.z > 0.008856) ? xyz.z : (z - 16.0 / 116.0) / 7.787;", "", "\txyz = vec3(x,y,z) * vec3(0.95047, 1.00000, 1.08883);", "", "\tfloat r = dot(xyz, vec3( 3.2406, -1.5372, -0.4986));", "\tfloat g = dot(xyz, vec3(-0.9689,  1.8758,  0.0415));", "\tfloat b = dot(xyz, vec3( 0.0557, -0.2040,  1.0570));", "", "\tr = (r > 0.0031308) ? 1.055 * pow(r, 1.0/2.4) - 0.055 : 12.92 * r;", "\tg = (g > 0.0031308) ? 1.055 * pow(g, 1.0/2.4) - 0.055 : 12.92 * g;", "\tb = (b > 0.0031308) ? 1.055 * pow(b, 1.0/2.4) - 0.055 : 12.92 * b;", "", "\treturn vec3(r,g,b);", "}", "vec4 blend_hue(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\tvec3 newDst3 = (uSrc3.r == uSrc3.g && uSrc3.r == uSrc3.b)", "\t\t\t\t\t? uDst3 : hsl2rgb(vec3(rgb2hsl(uSrc3).x, rgb2hsl(uDst3).yz));", "", "\treturn vec4((newDst3*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_saturation(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\tvec3 newDst3;", "", "\tvec3 dstLab = rgb2lab(uDst3);", "\tif (all(equal(dstLab.tp, vec2(0.0)))) {", "\t\tnewDst3 = uDst3;", "\t} else {", "\t\tvec3 srcLab = rgb2lab(uSrc3);", "\t\tfloat ratio = distance(srcLab.tp, vec2(0.0)) / distance(dstLab.tp, vec2(0.0));", "\t\tnewDst3 = lab2rgb(vec3(dstLab.s, dstLab.tp*ratio));", "\t}", "", "\treturn vec4((newDst3*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_color(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\tvec3 dstLab = rgb2lab(uDst3);", "\tvec3 srcLab = rgb2lab(uSrc3);", "\tvec3 newDst3 = lab2rgb(vec3(dstLab.s, srcLab.tp));", "", "\treturn vec4((newDst3*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_luminosity(vec4 pDst, vec4 pSrc, float opacity)", "{", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat cda = 1.0 - da;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "\tvec3 uSrc3 = (pSrc.a != 0.0) ? pSrc.rgb/pSrc.a : vec3(0.0);", "", "\tvec3 dstLab = rgb2lab(uDst3);", "\tvec3 srcLab = rgb2lab(uSrc3);", "\tvec3 newDst3 = lab2rgb(vec3(srcLab.s, dstLab.tp));", "", "\treturn vec4((newDst3*da + uSrc3*cda)*sa + pDst3*csa, a);", "}", "vec4 blend_stencil_alpha(vec4 pDst, vec4 pSrc, float opacity)", "{", "\treturn pDst * (pSrc.a * opacity);", "}", "vec4 blend_stencil_luma(vec4 pDst, vec4 pSrc, float opacity)", "{", "\treturn pDst * (dot(pSrc.rgb, lumaVec) * opacity);", "}", "vec4 blend_silhouette_alpha(vec4 pDst, vec4 pSrc, float opacity)", "{", "\treturn pDst * (1.0 - pSrc.a * opacity);", "}", "vec4 blend_silhouette_luma(vec4 pDst, vec4 pSrc, float opacity)", "{", "\treturn pDst * (1.0 - dot(pSrc.rgb, lumaVec) * opacity);", "}", "vec4 blend(int mode, vec4 pDst, vec4 pSrc, float opacity, float time)", "{", "\treturn (mode == 0) ? blend_normal(pDst, pSrc, opacity) :", "\t\t   (mode == 1) ? blend_dissolve(pDst, pSrc, opacity) :", "\t\t   (mode == 2) ? blend_dancing_dissolve(pDst, pSrc, opacity, time) :", "\t\t   (mode == 3) ? blend_darken(pDst, pSrc, opacity) :", "\t\t   (mode == 4) ? blend_multiply(pDst, pSrc, opacity) :", "\t\t   (mode == 5) ? blend_color_burn(pDst, pSrc, opacity) :", "\t\t   (mode == 6) ? blend_linear_burn(pDst, pSrc, opacity) :", "\t\t   (mode == 7) ? blend_darker_color(pDst, pSrc, opacity) :", "\t\t   (mode == 8) ? blend_add(pDst, pSrc, opacity) :", "\t\t   (mode == 9) ? blend_lighten(pDst, pSrc, opacity) :", "\t\t   (mode == 10) ? blend_screen(pDst, pSrc, opacity) :", "\t\t   (mode == 11) ? blend_color_dodge(pDst, pSrc, opacity) :", "\t\t   (mode == 12) ? blend_linear_dodge(pDst, pSrc, opacity) :", "\t\t   (mode == 13) ? blend_lighter_color(pDst, pSrc, opacity) :", "\t\t   (mode == 14) ? blend_overlay(pDst, pSrc, opacity) :", "\t\t   (mode == 15) ? blend_soft_light(pDst, pSrc, opacity) :", "\t\t   (mode == 16) ? blend_hard_light(pDst, pSrc, opacity) :", "\t\t   (mode == 17) ? blend_linear_light(pDst, pSrc, opacity) :", "\t\t   (mode == 18) ? blend_vivid_light(pDst, pSrc, opacity) :", "\t\t   (mode == 19) ? blend_pin_light(pDst, pSrc, opacity) :", "\t\t   (mode == 20) ? blend_hard_mix(pDst, pSrc, opacity) :", "\t\t   (mode == 21) ? blend_difference(pDst, pSrc, opacity) :", "\t\t   (mode == 22) ? blend_exclusion(pDst, pSrc, opacity) :", "\t\t   (mode == 23) ? blend_hue(pDst, pSrc, opacity) :", "\t\t   (mode == 24) ? blend_saturation(pDst, pSrc, opacity) :", "\t\t   (mode == 25) ? blend_color(pDst, pSrc, opacity) :", "\t\t   (mode == 26) ? blend_luminosity(pDst, pSrc, opacity) :", "\t\t   (mode == 29) ? blend_silhouette_alpha(pDst, pSrc, opacity) :", "\t\t   (mode == 30) ? blend_silhouette_luma(pDst, pSrc, opacity) :", "\t\t   blend_normal(pDst, pSrc, opacity);", "}"};
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] NORMAL = BlendModeShaders.createProgramSource("normal");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] DISSOLVE = BlendModeShaders.createProgramSource("dissolve");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] DANCING_DISSOLVE = BlendModeShaders.createProgramSource("dancing_dissolve", true);
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] DARKEN = BlendModeShaders.createProgramSource("darken");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] MULTIPLY = BlendModeShaders.createProgramSource("multiply");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] COLOR_BURN = BlendModeShaders.createProgramSource("color_burn");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] LINEAR_BURN = BlendModeShaders.createProgramSource("linear_burn");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] DARKER_COLOR = BlendModeShaders.createProgramSource("darker_color");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] ADD = BlendModeShaders.createProgramSource("add");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] LIGHTEN = BlendModeShaders.createProgramSource("lighten");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] SCREEN = BlendModeShaders.createProgramSource("screen");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] COLOR_DODGE = BlendModeShaders.createProgramSource("color_dodge");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] LINEAR_DODGE = BlendModeShaders.createProgramSource("linear_dodge");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] LIGHTER_COLOR = BlendModeShaders.createProgramSource("lighter_color");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] OVERLAY = BlendModeShaders.createProgramSource("overlay");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] SOFT_LIGHT = BlendModeShaders.createProgramSource("soft_light");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] HARD_LIGHT = BlendModeShaders.createProgramSource("hard_light");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] LINEAR_LIGHT = BlendModeShaders.createProgramSource("linear_light");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] VIVID_LIGHT = BlendModeShaders.createProgramSource("vivid_light");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] PIN_LIGHT = BlendModeShaders.createProgramSource("pin_light");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] HARD_MIX = BlendModeShaders.createProgramSource("hard_mix");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] DIFFERENCE = BlendModeShaders.createProgramSource("difference");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] EXCLUSION = BlendModeShaders.createProgramSource("exclusion");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] HUE = BlendModeShaders.createProgramSource("hue");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] SATURATION = BlendModeShaders.createProgramSource("saturation");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] COLOR = BlendModeShaders.createProgramSource("color");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] LUMINOSITY = BlendModeShaders.createProgramSource("luminosity");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] STENCIL_ALPHA = BlendModeShaders.createProgramSource("stencil_alpha");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] STENCIL_LUMA = BlendModeShaders.createProgramSource("stencil_luma");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] SILHOUETTE_ALPHA = BlendModeShaders.createProgramSource("silhouette_alpha");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] SILHOUETTE_LUMA = BlendModeShaders.createProgramSource("silhouette_luma");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] INTERSECTING_BLEND = new String[]{"const int maxLayers = 7;", "", "uniform int nLayers;", "uniform sampler2DRect texDst;", "uniform sampler2DRect texSrc0;", "uniform sampler2DRect texSrc1;", "uniform sampler2DRect texSrc2;", "uniform sampler2DRect texSrc3;", "uniform sampler2DRect texSrc4;", "uniform sampler2DRect texSrc5;", "uniform sampler2DRect texSrc6;", "uniform sampler2DRect texDep0;", "uniform sampler2DRect texDep1;", "uniform sampler2DRect texDep2;", "uniform sampler2DRect texDep3;", "uniform sampler2DRect texDep4;", "uniform sampler2DRect texDep5;", "uniform sampler2DRect texDep6;", "uniform int blendMode[maxLayers];", "uniform float opacity[maxLayers];", "uniform float time;", "", "", "vec2 texCoord = gl_TexCoord[0].st;", "", "vec4 getSrc(int i) {", "\treturn ", "\t\t(i == 0) ? texture2DRect(texSrc0, texCoord) : ", "\t\t(i == 1) ? texture2DRect(texSrc1, texCoord) : ", "\t\t(i == 2) ? texture2DRect(texSrc2, texCoord) : ", "\t\t(i == 3) ? texture2DRect(texSrc3, texCoord) : ", "\t\t(i == 4) ? texture2DRect(texSrc4, texCoord) : ", "\t\t(i == 5) ? texture2DRect(texSrc5, texCoord) : ", "\t\t(i == 6) ? texture2DRect(texSrc6, texCoord) : ", "\t\tvec4(0.0);", "}", "", "float getDep(int i) {", "\treturn ", "\t\t(i == 0) ? texture2DRect(texDep0, texCoord).r : ", "\t\t(i == 1) ? texture2DRect(texDep1, texCoord).r : ", "\t\t(i == 2) ? texture2DRect(texDep2, texCoord).r : ", "\t\t(i == 3) ? texture2DRect(texDep3, texCoord).r : ", "\t\t(i == 4) ? texture2DRect(texDep4, texCoord).r : ", "\t\t(i == 5) ? texture2DRect(texDep5, texCoord).r : ", "\t\t(i == 6) ? texture2DRect(texDep6, texCoord).r : ", "\t\t-1.0;", "}", "", "int ord0 = 0;", "int ord1 = 1;", "int ord2 = 2;", "int ord3 = 3;", "int ord4 = 4;", "int ord5 = 5;", "int ord6 = 6;", "", "int getOrd(int i) {", "\treturn ", "\t\t(i == 0) ? ord0 : ", "\t\t(i == 1) ? ord1 : ", "\t\t(i == 2) ? ord2 : ", "\t\t(i == 3) ? ord3 : ", "\t\t(i == 4) ? ord4 : ", "\t\t(i == 5) ? ord5 : ", "\t\t(i == 6) ? ord6 : ", "\t\t-1;", "}", "", "void setOrd(int i, int ord) {", "\tif (i == 0) ord0 = ord; else ", "\tif (i == 1) ord1 = ord; else ", "\tif (i == 2) ord2 = ord; else ", "\tif (i == 3) ord3 = ord; else ", "\tif (i == 4) ord4 = ord; else ", "\tif (i == 5) ord5 = ord; else ", "\tif (i == 6) ord6 = ord; else ", "\t{}", "}", "", "", "vec4 blend(int mode, vec4 pDst, vec4 pSrc, float opacity, float time);", "", "void main(void)", "{", "\tvec4 dst = texture2DRect(texDst, texCoord);", "", "\tint nzaCount = 0;", "\tint nzaLayer;", "\tvec4 nzaColor;", "\tfor (int i = 0; i < nLayers; ++i) {", "\t\tvec4 s = getSrc(i);", "\t\tif (s.a > 0.0) {", "\t\t\tif (++nzaCount > 1) {", "\t\t\t\tbreak;", "\t\t\t}", "\t\t\tnzaLayer = i;", "\t\t\tnzaColor = s;", "\t\t}", "\t}", "\tif (nzaCount == 1) {", "\t\tdst = vec4(dst.rgb*dst.a, dst.a);", "\t\tdst = blend(blendMode[nzaLayer], dst, nzaColor, opacity[nzaLayer], time);", "\t\tdst = (dst.a != 0.0) ? vec4(dst.rgb/dst.a, dst.a) : vec4(0.0);", "", "\t} else if (nzaCount > 1) {", "\t\tdst = vec4(dst.rgb*dst.a, dst.a);", "\t\t", "\t\tfor (int i = nLayers - 2; i >= 0; --i) {", "\t\t\tint ord = getOrd(i);", "\t\t\tfloat dep = getDep(ord);", "\t\t\tint j, ord2;", "\t\t\tfor (j = i + 1; j < nLayers && getDep(ord2 = getOrd(j)) > dep; ++j) {", "\t\t\t\tsetOrd(j - 1, ord2);", "\t\t\t}", "\t\t\tsetOrd(j - 1, ord);", "\t\t}", "\t\t", "\t\tfor (int i = 0; i < nLayers; ++i) {", "\t\t\tint ord = getOrd(i);", "\t\t\tdst = blend(blendMode[ord], dst, getSrc(ord), opacity[ord], time);", "\t\t}", "\t\tdst = (dst.a != 0.0) ? vec4(dst.rgb/dst.a, dst.a) : vec4(0.0);", "\t}", "", "\tgl_FragColor = dst;", "}"};

    private static final String[] createProgramSource(String name, boolean temporal) {
        return new String[]{"uniform sampler2DRect texDst;", "uniform sampler2DRect texSrc;", "uniform float opacity;", temporal ? "uniform float time;" : "", "", String.format("vec4 blend_%s(vec4 pDst, vec4 pSrc, float opacity%s);", name, temporal ? ", float time" : ""), "", "void main(void)", "{", "\tvec2 texCoord = gl_TexCoord[0].st;", "\tvec4 dst = texture2DRect(texDst, texCoord);", "\tvec4 src = texture2DRect(texSrc, texCoord);", String.format("\tdst = blend_%s(vec4(dst.rgb*dst.a, dst.a), src, opacity%s);", name, temporal ? ", time" : ""), "\tgl_FragColor = (dst.a != 0.0) ? vec4(dst.rgb/dst.a, dst.a) : vec4(0.0);", "}"};
    }

    private static final String[] createProgramSource(String name) {
        return BlendModeShaders.createProgramSource(name, false);
    }

    private BlendModeShaders() {
    }
}

