/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IObjectArray;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IAudioEffectContext;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.AudioEffect;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.services.AudioEffectContextProxy;
import ch.kuramo.javie.core.services.AudioEffectPipeline;
import ch.kuramo.javie.core.services.AudioRenderContext;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import com.google.inject.Inject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioEffectPipelineImpl
implements AudioEffectPipeline {
    @Inject
    private AudioRenderContext _arContext;
    @Inject
    private AudioRenderSupport _arSupport;
    @Inject
    private IArrayPools _arrayPools;

    @Override
    public AudioBuffer doAudioEffects(List<Effect> effects, WrappedOperation<AudioBuffer> inputOperation) {
        AudioEffectContextImpl impl = new AudioEffectContextImpl(this.enabledAudioEffectsOnly(effects), inputOperation);
        AudioEffectContextProxy.push(impl);
        try {
            AudioBuffer audioBuffer = (AudioBuffer)impl.doPreviousEffect();
            return audioBuffer;
        }
        finally {
            AudioEffectContextProxy.pop();
        }
    }

    private List<AudioEffect> enabledAudioEffectsOnly(List<Effect> effects) {
        List<AudioEffect> audioEffects = Util.newList();
        for (Effect e : effects) {
            if (!(e instanceof AudioEffect) || !e.isEnabled()) continue;
            audioEffects.add((AudioEffect)e);
        }
        return audioEffects;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AudioEffectContextImpl
    implements IAudioEffectContext {
        private List<AudioEffect> effects;
        private final WrappedOperation<AudioBuffer> inputOperation;

        private AudioEffectContextImpl(List<AudioEffect> effects, WrappedOperation<AudioBuffer> inputOperation) {
            this.effects = effects;
            this.inputOperation = inputOperation;
        }

        public IAudioBuffer doPreviousEffect() {
            if (this.effects.isEmpty()) {
                AudioBuffer ab = AudioEffectPipelineImpl.this._arContext.saveAndExecute(this.inputOperation);
                if (ab == null) {
                    ab = AudioEffectPipelineImpl.this._arSupport.createAudioBuffer();
                    AudioEffectPipelineImpl.this._arSupport.clear(ab);
                }
                return (IAudioBuffer)ab;
            }
            final AudioEffect prevEffect = this.effects.get(this.effects.size() - 1);
            return this.executePrevious(new WrappedOperation<IAudioBuffer>(){

                @Override
                public IAudioBuffer execute() {
                    IAudioBuffer buffer = prevEffect.doAudioEffect();
                    return buffer != null ? buffer : AudioEffectContextImpl.this.doPreviousEffect();
                }
            });
        }

        private <T> T executePrevious(WrappedOperation<T> wop) {
            List<AudioEffect> savedEffects = this.effects;
            try {
                this.effects = this.effects.subList(0, this.effects.size() - 1);
                T t = AudioEffectPipelineImpl.this._arContext.saveAndExecute(wop);
                return t;
            }
            finally {
                this.effects = savedEffects;
            }
        }

        public Time getTime() {
            return AudioEffectPipelineImpl.this._arContext.getTime();
        }

        public void setTime(Time time) {
            AudioEffectPipelineImpl.this._arContext.setTime(time);
        }

        public <V> V value(IAnimatableValue<V> avalue) {
            AnimatableValue av = (AnimatableValue)avalue;
            return av.value(AudioEffectPipelineImpl.this._arContext);
        }

        public AudioMode getAudioMode() {
            return AudioEffectPipelineImpl.this._arContext.getAudioMode();
        }

        public int getFrameCount() {
            return AudioEffectPipelineImpl.this._arContext.getFrameCount();
        }

        public void setFrameCount(int count) {
            AudioEffectPipelineImpl.this._arContext.setFrameCount(count);
        }

        public IAudioBuffer createAudioBuffer() {
            return (IAudioBuffer)AudioEffectPipelineImpl.this._arSupport.createAudioBuffer();
        }

        public <V> IObjectArray<V> values(IAnimatableValue<V> avalue) {
            return this.values(avalue, AudioEffectPipelineImpl.this._arContext.getEvaluationResolution());
        }

        public <V> IObjectArray<V> values(IAnimatableValue<V> avalue, int evalResolution) {
            AnimatableValue av = (AnimatableValue)avalue;
            evalResolution = Math.max(1, Math.min(evalResolution, AudioEffectPipelineImpl.this._arContext.getEvaluationResolution()));
            IObjectArray objArray = AudioEffectPipelineImpl.this._arrayPools.getObjectArray(AudioEffectPipelineImpl.this._arContext.getFrameCount());
            av.values(objArray, ((AudioEffectPipelineImpl)AudioEffectPipelineImpl.this)._arContext.getAudioMode().sampleDuration, evalResolution, AudioEffectPipelineImpl.this._arContext);
            return objArray;
        }
    }
}

