/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.core.BlendMode;
import ch.kuramo.javie.core.DepthBuffer;
import ch.kuramo.javie.core.TrackMatte;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.VideoLayerBuffer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.DepthBufferImpl;
import ch.kuramo.javie.core.internal.VideoBufferImpl;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import ch.kuramo.javie.core.shaders.BlendModeShaders;
import ch.kuramo.javie.core.shaders.TrackMatteShaders;
import com.google.inject.Inject;
import com.google.inject.Injector;
import ftgl.FTGL;
import ftgl.FTGLfont;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoRenderSupportImpl
implements VideoRenderSupport {
    private static final Logger _logger = LoggerFactory.getLogger(VideoRenderSupportImpl.class);
    private static final float[] FLOAT0000 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    @Inject
    private Injector _injector;
    @Inject
    private GLGlobal _glGlobal;
    @Inject
    private VideoRenderContext _vrContext;
    @Inject
    private IShaderRegistry _shaders;
    @Inject
    private IArrayPools _arrayPools;

    @Override
    public VideoBuffer createVideoBuffer(ColorMode colorMode, Size2i size) {
        VideoBufferImpl vb = new VideoBufferImpl(colorMode, size);
        this._injector.injectMembers((Object)vb);
        return vb;
    }

    @Override
    public VideoBuffer createVideoBuffer(ColorMode colorMode, VideoBounds bounds) {
        VideoBufferImpl vb = new VideoBufferImpl(colorMode, bounds);
        this._injector.injectMembers((Object)vb);
        return vb;
    }

    @Override
    public DepthBuffer createDepthBuffer(Size2i size) {
        DepthBufferImpl db = new DepthBufferImpl(size);
        this._injector.injectMembers((Object)db);
        return db;
    }

    @Override
    public int createTexture(ColorMode colorMode, Size2i textureSize) {
        GL2 gl = this._vrContext.getGL().getGL2();
        int[] tex = new int[1];
        gl.glGenTextures(1, tex, 0);
        gl.glBindTexture(34037, tex[0]);
        gl.glTexParameteri(34037, 10241, 9729);
        gl.glTexParameteri(34037, 10240, 9729);
        gl.glTexParameteri(34037, 10242, 33069);
        gl.glTexParameteri(34037, 10243, 33069);
        gl.glTexParameterfv(34037, 4100, FLOAT0000, 0);
        gl.glTexImage2D(34037, 0, colorMode.glInternalFormat, textureSize.width, textureSize.height, 0, 32993, colorMode.glDataType, null);
        gl.glBindTexture(34037, 0);
        return tex[0];
    }

    @Override
    public int createDepthTexture(Size2i textureSize) {
        GL2 gl = this._vrContext.getGL().getGL2();
        int[] tex = new int[1];
        gl.glGenTextures(1, tex, 0);
        gl.glBindTexture(34037, tex[0]);
        gl.glTexParameteri(34037, 10241, 9728);
        gl.glTexParameteri(34037, 10240, 9728);
        gl.glTexParameteri(34037, 10242, 33069);
        gl.glTexParameteri(34037, 10243, 33069);
        gl.glTexParameterfv(34037, 4100, FLOAT0000, 0);
        gl.glTexImage2D(34037, 0, 33191, textureSize.width, textureSize.height, 0, 6402, 5126, null);
        gl.glBindTexture(34037, 0);
        return tex[0];
    }

    @Override
    public void deleteTexture(int texture) {
        GL2 gl = this._vrContext.getGL().getGL2();
        gl.glDeleteTextures(1, new int[]{texture}, 0);
    }

    @Override
    public IArray<?> createArray(ColorMode colorMode, Size2i imageSize) {
        int arraySize = imageSize.width * imageSize.height * 4;
        switch (colorMode) {
            case RGBA8: {
                return this._arrayPools.getByteArray(arraySize);
            }
            case RGBA16: {
                return this._arrayPools.getShortArray(arraySize);
            }
            case RGBA16_FLOAT: 
            case RGBA32_FLOAT: {
                return this._arrayPools.getFloatArray(arraySize);
            }
        }
        throw new UnsupportedOperationException("ColorMode: " + colorMode.name());
    }

    @Override
    public void copyArrayToTexture(Object array, int texture, ColorMode colorMode, Size2i imageSize) {
        ReentrantLock lock = this._glGlobal.getGlobalLock();
        lock.lock();
        try {
            GL2 gl = this._vrContext.getGL().getGL2();
            int[] pbo = new int[1];
            gl.glGenBuffers(1, pbo, 0);
            gl.glBindBuffer(35052, pbo[0]);
            gl.glBindTexture(34037, texture);
            int imageBytes = imageSize.width * imageSize.height * colorMode.javaPixelBytes;
            gl.glBufferData(35052, imageBytes, this.toNioBuffer(array), 35040);
            gl.glTexSubImage2D(34037, 0, 0, 0, imageSize.width, imageSize.height, 32993, colorMode.glDataType, 0L);
            gl.glBindTexture(34037, 0);
            gl.glBindBuffer(35052, 0);
            gl.glDeleteBuffers(1, pbo, 0);
        }
        finally {
            lock.unlock();
        }
    }

    private Buffer toNioBuffer(Object array) {
        if (array instanceof byte[]) {
            return ByteBuffer.wrap((byte[])array);
        }
        if (array instanceof short[]) {
            return ShortBuffer.wrap((short[])array);
        }
        if (array instanceof float[]) {
            return FloatBuffer.wrap((float[])array);
        }
        throw new IllegalArgumentException("not array or unsupported array type: " + array.getClass().getName());
    }

    @Override
    public void copyTextureToArray(int texture, Object array, ColorMode colorMode, Size2i imageSize) {
        ReentrantLock lock = this._glGlobal.getGlobalLock();
        lock.lock();
        try {
            GL2 gl = this._vrContext.getGL().getGL2();
            int[] pbo = new int[1];
            gl.glGenBuffers(1, pbo, 0);
            gl.glBindBuffer(35051, pbo[0]);
            gl.glBindTexture(34037, texture);
            int imageBytes = imageSize.width * imageSize.height * colorMode.javaPixelBytes;
            gl.glBufferData(35051, imageBytes, null, 35041);
            gl.glFramebufferTexture2D(36160, 36064, 34037, texture, 0);
            gl.glReadBuffer(36064);
            gl.glReadPixels(0, 0, imageSize.width, imageSize.height, 32993, colorMode.glDataType, 0L);
            ByteBuffer mappedPBO = gl.glMapBuffer(35051, 35000);
            this.copyPBOToArray(mappedPBO, array);
            gl.glUnmapBuffer(35051);
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            gl.glBindTexture(34037, 0);
            gl.glBindBuffer(35051, 0);
            gl.glDeleteBuffers(1, pbo, 0);
        }
        finally {
            lock.unlock();
        }
    }

    private void copyPBOToArray(ByteBuffer mappedPBO, Object array) {
        if (array instanceof byte[]) {
            mappedPBO.get((byte[])array, 0, mappedPBO.capacity());
        } else if (array instanceof short[]) {
            mappedPBO.asShortBuffer().get((short[])array, 0, mappedPBO.capacity() / 2);
        } else if (array instanceof float[]) {
            mappedPBO.asFloatBuffer().get((float[])array, 0, mappedPBO.capacity() / 4);
        } else {
            throw new IllegalArgumentException("not array or unsupported array type: " + array.getClass().getName());
        }
    }

    @Override
    public void clear(VideoBuffer videoBuffer) {
        if (videoBuffer.isTexture()) {
            this.fill(videoBuffer.getTexture(), Color.COLORLESS_TRANSPARENT);
        } else if (videoBuffer.isArray()) {
            Size2i size = videoBuffer.getImageSize();
            this.clear(videoBuffer.getArray(), size.width * size.height * 4);
        } else {
            throw new IllegalStateException("neither texture nor array exist.");
        }
    }

    private void clear(Object array, int length) {
        if (array instanceof byte[]) {
            Arrays.fill((byte[])array, 0, length, (byte)0);
        } else if (array instanceof short[]) {
            Arrays.fill((short[])array, 0, length, (short)0);
        } else if (array instanceof float[]) {
            Arrays.fill((float[])array, 0, length, 0.0f);
        } else {
            throw new IllegalArgumentException("not array or unsupported array type: " + array.getClass().getName());
        }
    }

    @Override
    public void fill(VideoBuffer videoBuffer, Color color) {
        if (videoBuffer.isArray()) {
            this.fill(videoBuffer.getArray(), videoBuffer.getImageSize(), color);
            return;
        }
        if (!videoBuffer.isAllocated()) {
            videoBuffer.allocateAsTexture();
        }
        this.fill(videoBuffer.getTexture(), color);
    }

    private void fill(int texture, Color color) {
        GL2 gl = this._vrContext.getGL().getGL2();
        gl.glFramebufferTexture2D(36160, 36064, 34037, texture, 0);
        gl.glDrawBuffer(36064);
        float a = (float)color.a;
        float r = (float)color.r * a;
        float g = (float)color.g * a;
        float b = (float)color.b * a;
        gl.glClearColor(r, g, b, a);
        gl.glClear(16384);
        gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
    }

    private void fill(Object array, Size2i imageSize, Color color) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void fillRectCR(VideoBuffer resultBuffer, DepthBuffer depthBuffer, final double[] mvMatrix, final double[] prjMatrix, final Size2i size, final Color color) {
        final int resultTexture = resultBuffer.getTexture();
        final Size2i resultImageSize = resultBuffer.getImageSize();
        final int depthTexture = depthBuffer != null ? depthBuffer.getTexture() : 0;
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                gl.glViewport(0, 0, resultImageSize.width, resultImageSize.height);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(prjMatrix, 0);
                gl.glMatrixMode(5888);
                gl.glLoadMatrixd(mvMatrix, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                if (depthTexture != 0) {
                    gl.glFramebufferTexture2D(36160, 36096, 34037, depthTexture, 0);
                    gl.glEnable(2929);
                    gl.glClearDepth(1.0);
                    gl.glClear(256);
                }
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                float a = (float)color.a;
                float r = (float)color.r * a;
                float g = (float)color.g * a;
                float b = (float)color.b * a;
                gl.glColor4f(r, g, b, a);
                gl.glBegin(7);
                gl.glVertex2i(0, 0);
                gl.glVertex2i(size.width, 0);
                gl.glVertex2i(size.width, size.height);
                gl.glVertex2i(0, size.height);
                gl.glEnd();
                gl.glColor4fv(savedColor, 0);
                if (depthTexture != 0) {
                    gl.glDisable(2929);
                    gl.glFramebufferTexture2D(36160, 36096, 34037, 0, 0);
                }
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    private void ortho2D(GL2 gl, GLU glu, Size2i imageSize) {
        this.ortho2D(gl, glu, imageSize.width, imageSize.height);
    }

    private void ortho2D(GL2 gl, GLU glu, int width, int height) {
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluOrtho2D(0.0f, (float)width, 0.0f, (float)height);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    @Override
    public void trackMatte(VideoBuffer matteBuffer, VideoBuffer fillBuffer, VideoBuffer resultBuffer, final TrackMatte trackMatte, final double matteOpacity) {
        if (trackMatte == TrackMatte.NONE) {
            throw new IllegalArgumentException();
        }
        final int matteTexture = matteBuffer.getTexture();
        final int fillTexture = fillBuffer.getTexture();
        final int resultTexture = resultBuffer.getTexture();
        final Size2i imageSize = resultBuffer.getImageSize();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute() {
                IShaderProgram program;
                GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                GLU glu = VideoRenderSupportImpl.this._vrContext.getGLU();
                VideoRenderSupportImpl.this.ortho2D(gl, glu, imageSize);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, fillTexture);
                gl.glActiveTexture(33985);
                gl.glBindTexture(34037, matteTexture);
                IShaderProgram iShaderProgram = program = VideoRenderSupportImpl.this._shaders.getProgram(TrackMatteShaders.class, trackMatte.name());
                synchronized (iShaderProgram) {
                    gl.glUseProgram(program.getProgram());
                    gl.glUniform1i(program.getUniformLocation("texFill"), 0);
                    gl.glUniform1i(program.getUniformLocation("texMatte"), 1);
                    gl.glUniform1f(program.getUniformLocation("matteOpacity"), (float)matteOpacity);
                    gl.glBegin(7);
                    gl.glTexCoord2f(0.0f, 0.0f);
                    gl.glVertex2f(0.0f, 0.0f);
                    gl.glTexCoord2f((float)imageSize.width, 0.0f);
                    gl.glVertex2f((float)imageSize.width, 0.0f);
                    gl.glTexCoord2f((float)imageSize.width, (float)imageSize.height);
                    gl.glVertex2f((float)imageSize.width, (float)imageSize.height);
                    gl.glTexCoord2f(0.0f, (float)imageSize.height);
                    gl.glVertex2f(0.0f, (float)imageSize.height);
                    gl.glEnd();
                    gl.glFinish();
                    gl.glUseProgram(0);
                }
                gl.glActiveTexture(33985);
                gl.glBindTexture(34037, 0);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void blend(VideoBuffer srcBuffer, VideoBuffer dstBuffer, VideoBuffer resultBuffer, final BlendMode blendMode, final double opacity) {
        final int srcTexture = srcBuffer.getTexture();
        final int dstTexture = dstBuffer.getTexture();
        final int resultTexture = resultBuffer.getTexture();
        final Size2i imageSize = resultBuffer.getImageSize();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute() {
                IShaderProgram program;
                GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                GLU glu = VideoRenderSupportImpl.this._vrContext.getGLU();
                VideoRenderSupportImpl.this.ortho2D(gl, glu, imageSize);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, dstTexture);
                gl.glActiveTexture(33985);
                gl.glBindTexture(34037, srcTexture);
                IShaderProgram iShaderProgram = program = VideoRenderSupportImpl.this._shaders.getProgram(BlendModeShaders.class, blendMode.name());
                synchronized (iShaderProgram) {
                    gl.glUseProgram(program.getProgram());
                    gl.glUniform1i(program.getUniformLocation("texDst"), 0);
                    gl.glUniform1i(program.getUniformLocation("texSrc"), 1);
                    gl.glUniform1f(program.getUniformLocation("opacity"), (float)opacity);
                    if (blendMode == BlendMode.DANCING_DISSOLVE) {
                        gl.glUniform1f(program.getUniformLocation("time"), (float)VideoRenderSupportImpl.this._vrContext.getTime().toSecond());
                    }
                    gl.glBegin(7);
                    gl.glTexCoord2f(0.0f, 0.0f);
                    gl.glVertex2f(0.0f, 0.0f);
                    gl.glTexCoord2f((float)imageSize.width, 0.0f);
                    gl.glVertex2f((float)imageSize.width, 0.0f);
                    gl.glTexCoord2f((float)imageSize.width, (float)imageSize.height);
                    gl.glVertex2f((float)imageSize.width, (float)imageSize.height);
                    gl.glTexCoord2f(0.0f, (float)imageSize.height);
                    gl.glVertex2f(0.0f, (float)imageSize.height);
                    gl.glEnd();
                    gl.glFinish();
                    gl.glUseProgram(0);
                }
                gl.glActiveTexture(33985);
                gl.glBindTexture(34037, 0);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void blend(final Collection<VideoLayerBuffer> srcBuffers, final VideoBuffer dstBuffer, VideoBuffer resultBuffer) {
        final int resultTexture = resultBuffer.getTexture();
        final Size2i imageSize = resultBuffer.getImageSize();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute() {
                IShaderProgram program;
                GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                GLU glu = VideoRenderSupportImpl.this._vrContext.getGLU();
                VideoRenderSupportImpl.this.ortho2D(gl, glu, imageSize);
                int maxLayers = BlendModeShaders.getMaxIntersectingLayers();
                int nLayers = srcBuffers.size();
                if (nLayers > maxLayers) {
                    _logger.warn(String.format("number of layers in a inersection group exceeds limit: limit=%d, layers=%d", maxLayers, nLayers));
                    nLayers = maxLayers;
                }
                int[] blendMode = new int[maxLayers];
                float[] opacity = new float[maxLayers];
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, dstBuffer.getTexture());
                int i = 0;
                for (VideoLayerBuffer vlb : srcBuffers) {
                    gl.glActiveTexture(33984 + i + 1);
                    gl.glBindTexture(34037, vlb.getVideoBuffer().getTexture());
                    gl.glActiveTexture(33984 + i + 1 + maxLayers);
                    gl.glBindTexture(34037, vlb.getDepthBuffer().getTexture());
                    blendMode[i] = vlb.getBlendMode().ordinal();
                    opacity[i] = (float)vlb.getOpacity();
                    if (++i >= nLayers) break;
                }
                IShaderProgram iShaderProgram = program = VideoRenderSupportImpl.this._shaders.getProgram(BlendModeShaders.class, "INTERSECTING_BLEND");
                synchronized (iShaderProgram) {
                    gl.glUseProgram(program.getProgram());
                    gl.glUniform1i(program.getUniformLocation("nLayers"), nLayers);
                    gl.glUniform1i(program.getUniformLocation("texDst"), 0);
                    i = 0;
                    while (i < maxLayers) {
                        gl.glUniform1i(program.getUniformLocation("texSrc" + i), i + 1);
                        gl.glUniform1i(program.getUniformLocation("texDep" + i), i + 1 + maxLayers);
                        ++i;
                    }
                    int blendModeLocation = program.getUniformLocation("blendMode[0]");
                    if (blendModeLocation != -1) {
                        gl.glUniform1iv(blendModeLocation, maxLayers, blendMode, 0);
                    }
                    gl.glUniform1fv(program.getUniformLocation("opacity[0]"), maxLayers, opacity, 0);
                    gl.glUniform1f(program.getUniformLocation("time"), (float)VideoRenderSupportImpl.this._vrContext.getTime().toSecond());
                    gl.glBegin(7);
                    gl.glTexCoord2f(0.0f, 0.0f);
                    gl.glVertex2f(0.0f, 0.0f);
                    gl.glTexCoord2f((float)imageSize.width, 0.0f);
                    gl.glVertex2f((float)imageSize.width, 0.0f);
                    gl.glTexCoord2f((float)imageSize.width, (float)imageSize.height);
                    gl.glVertex2f((float)imageSize.width, (float)imageSize.height);
                    gl.glTexCoord2f(0.0f, (float)imageSize.height);
                    gl.glVertex2f(0.0f, (float)imageSize.height);
                    gl.glEnd();
                    gl.glFinish();
                    gl.glUseProgram(0);
                }
                int j = 0;
                int n = maxLayers * 2 + 1;
                while (j < n) {
                    gl.glActiveTexture(33984 + j);
                    gl.glBindTexture(34037, 0);
                    ++j;
                }
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void premultiply(final VideoBuffer vb) {
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                GLU glu = VideoRenderSupportImpl.this._vrContext.getGLU();
                VideoBounds bounds = vb.getBounds();
                VideoRenderSupportImpl.this.ortho2D(gl, glu, bounds.width, bounds.height);
                gl.glFramebufferTexture2D(36160, 36064, 34037, vb.getTexture(), 0);
                gl.glDrawBuffer(36064);
                gl.glEnable(3042);
                gl.glBlendFuncSeparate(0, 772, 0, 1);
                gl.glBegin(7);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glVertex2f((float)bounds.width, 0.0f);
                gl.glVertex2f((float)bounds.width, (float)bounds.height);
                gl.glVertex2f(0.0f, (float)bounds.height);
                gl.glEnd();
                gl.glDisable(3042);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public <T> T pushMatrixAndExecute(WrappedOperation<T> operation) {
        GL2 gl = this._vrContext.getGL().getGL2();
        int[] viewport = new int[4];
        gl.glGetIntegerv(2978, viewport, 0);
        int[] matrixMode = new int[1];
        gl.glGetIntegerv(2976, matrixMode, 0);
        double[] mvMatrix = new double[16];
        double[] prjMatrix = new double[16];
        this.getMatrix(mvMatrix, prjMatrix);
        try {
            T t = operation.execute();
            return t;
        }
        finally {
            this.setMatrix(mvMatrix, prjMatrix);
            gl.glMatrixMode(matrixMode[0]);
            gl.glViewport(viewport[0], viewport[1], viewport[2], viewport[3]);
        }
    }

    @Override
    public void multModelViewMatrix(Vec3d anchorPoint, Vec3d scale, Vec3d orientation, Vec3d rotate, Vec3d position) {
        GL2 gl = this._vrContext.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glTranslatef((float)position.x, (float)position.y, (float)position.z);
        gl.glRotatef((float)orientation.x, 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)orientation.y, 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)orientation.z, 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)rotate.x, 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)rotate.y, 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)rotate.z, 0.0f, 0.0f, 1.0f);
        gl.glScalef((float)(scale.x / 100.0), (float)(scale.y / 100.0), (float)(scale.z / 100.0));
        gl.glTranslatef((float)(-anchorPoint.x), (float)(-anchorPoint.y), (float)(-anchorPoint.z));
    }

    @Override
    public void multModelViewMatrixInverse(Vec3d anchorPoint, Vec3d scale, Vec3d orientation, Vec3d rotate, Vec3d position) {
        GL2 gl = this._vrContext.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glTranslatef((float)anchorPoint.x, (float)anchorPoint.y, (float)anchorPoint.z);
        gl.glScalef((float)(100.0 / scale.x), (float)(100.0 / scale.y), (float)(100.0 / scale.z));
        gl.glRotatef((float)(-rotate.z), 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)(-rotate.y), 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)(-rotate.x), 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)(-orientation.z), 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)(-orientation.y), 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)(-orientation.x), 1.0f, 0.0f, 0.0f);
        gl.glTranslatef((float)(-position.x), (float)(-position.y), (float)(-position.z));
    }

    @Override
    public void multCameraMatrix(Vec3d orientation, Vec3d rotate, Vec3d position, Vec3d pointOfInterest, boolean flipZ) {
        double dx = pointOfInterest.x - position.x;
        double dy = pointOfInterest.y - position.y;
        double dz = pointOfInterest.z - position.z;
        float _1 = flipZ ? -1 : 1;
        GL2 gl = this._vrContext.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glRotatef((float)(-rotate.z), 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)(-rotate.y), 0.0f, _1, 0.0f);
        gl.glRotatef((float)(-rotate.x), _1, 0.0f, 0.0f);
        gl.glRotatef((float)(-orientation.z), 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)(-orientation.y), 0.0f, _1, 0.0f);
        gl.glRotatef((float)(-orientation.x), _1, 0.0f, 0.0f);
        gl.glRotatef((float)Math.toDegrees(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz))), _1, 0.0f, 0.0f);
        gl.glRotatef((float)Math.toDegrees(-Math.atan2(dx, dz)), 0.0f, _1, 0.0f);
        gl.glTranslatef((float)(-position.x), (float)(-position.y), (float)(-position.z) * _1);
        if (flipZ) {
            gl.glScalef(1.0f, 1.0f, -1.0f);
        }
    }

    @Override
    public void multCameraMatrixInverse(Vec3d orientation, Vec3d rotate, Vec3d position, Vec3d pointOfInterest) {
        double dx = pointOfInterest.x - position.x;
        double dy = pointOfInterest.y - position.y;
        double dz = pointOfInterest.z - position.z;
        GL2 gl = this._vrContext.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glTranslatef((float)position.x, (float)position.y, (float)position.z);
        gl.glRotatef((float)Math.toDegrees(Math.atan2(dx, dz)), 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)Math.toDegrees(-Math.atan2(dy, Math.sqrt(dx * dx + dz * dz))), 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)orientation.x, 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)orientation.y, 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)orientation.z, 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)rotate.x, 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)rotate.y, 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)rotate.z, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void multModelViewMatrix(double[] mvMatrix) {
        GL2 gl = this._vrContext.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glMultMatrixd(mvMatrix, 0);
    }

    @Override
    public void getMatrix(double[] mvMatrix, double[] prjMatrix) {
        GL2 gl = this._vrContext.getGL().getGL2();
        if (mvMatrix != null) {
            gl.glGetDoublev(2982, mvMatrix, 0);
        }
        if (prjMatrix != null) {
            gl.glGetDoublev(2983, prjMatrix, 0);
        }
    }

    @Override
    public void setMatrix(double[] mvMatrix, double[] prjMatrix) {
        GL2 gl = this._vrContext.getGL().getGL2();
        if (prjMatrix != null) {
            gl.glMatrixMode(5889);
            gl.glLoadMatrixd(prjMatrix, 0);
        }
        if (mvMatrix != null) {
            gl.glMatrixMode(5888);
            gl.glLoadMatrixd(mvMatrix, 0);
        }
    }

    @Override
    public void resetMatrix() {
        GL2 gl = this._vrContext.getGL().getGL2();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    @Override
    public Vec3d project(Vec3d point, double[] mvMatrix, double[] prjMatrix, Size2i viewportSize) {
        int[] nArray = new int[4];
        nArray[2] = viewportSize.width;
        nArray[3] = viewportSize.height;
        int[] viewport = nArray;
        double[] result = new double[3];
        this._vrContext.getGLU().gluProject(point.x, point.y, point.z, mvMatrix, 0, prjMatrix, 0, viewport, 0, result, 0);
        return new Vec3d(result[0], result[1], result[2]);
    }

    @Override
    public void transform(VideoBuffer srcBuffer, VideoBuffer resultBuffer, DepthBuffer depthBuffer, final double[] mvMatrix, final double[] prjMatrix) {
        final int srcTexture = srcBuffer.getTexture();
        final Size2i srcImageSize = srcBuffer.getImageSize();
        final int resultTexture = resultBuffer.getTexture();
        final Size2i resultImageSize = resultBuffer.getImageSize();
        final int depthTexture = depthBuffer != null ? depthBuffer.getTexture() : 0;
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                gl.glViewport(0, 0, resultImageSize.width, resultImageSize.height);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(prjMatrix, 0);
                gl.glMatrixMode(5888);
                gl.glLoadMatrixd(mvMatrix, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, srcTexture);
                gl.glEnable(34037);
                if (depthTexture != 0) {
                    gl.glFramebufferTexture2D(36160, 36096, 34037, depthTexture, 0);
                    gl.glEnable(2929);
                    gl.glClearDepth(1.0);
                    gl.glClear(256);
                }
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                gl.glBegin(7);
                gl.glTexCoord2f(0.0f, 0.0f);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glTexCoord2f((float)srcImageSize.width, 0.0f);
                gl.glVertex2f((float)srcImageSize.width, 0.0f);
                gl.glTexCoord2f((float)srcImageSize.width, (float)srcImageSize.height);
                gl.glVertex2f((float)srcImageSize.width, (float)srcImageSize.height);
                gl.glTexCoord2f(0.0f, (float)srcImageSize.height);
                gl.glVertex2f(0.0f, (float)srcImageSize.height);
                gl.glEnd();
                gl.glColor4fv(savedColor, 0);
                if (depthTexture != 0) {
                    gl.glDisable(2929);
                    gl.glFramebufferTexture2D(36160, 36096, 34037, 0, 0);
                }
                gl.glBindTexture(34037, 0);
                gl.glDisable(34037);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void scaleAndFlipVertical(VideoBuffer srcBuffer, VideoBuffer resultBuffer, final double scale) {
        final int srcTexture = srcBuffer.getTexture();
        final Size2i srcImageSize = srcBuffer.getImageSize();
        final int resultTexture = resultBuffer.getTexture();
        final Size2i resultImageSize = resultBuffer.getImageSize();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                GLU glu = VideoRenderSupportImpl.this._vrContext.getGLU();
                gl.glViewport(0, 0, resultImageSize.width, resultImageSize.height);
                gl.glMatrixMode(5889);
                gl.glLoadIdentity();
                glu.gluOrtho2D(0.0f, (float)resultImageSize.width, (float)resultImageSize.height, 0.0f);
                gl.glMatrixMode(5888);
                gl.glLoadIdentity();
                gl.glScalef((float)scale, (float)scale, 1.0f);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, srcTexture);
                gl.glEnable(34037);
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                gl.glBegin(7);
                gl.glTexCoord2f(0.0f, 0.0f);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glTexCoord2f((float)srcImageSize.width, 0.0f);
                gl.glVertex2f((float)srcImageSize.width, 0.0f);
                gl.glTexCoord2f((float)srcImageSize.width, (float)srcImageSize.height);
                gl.glVertex2f((float)srcImageSize.width, (float)srcImageSize.height);
                gl.glTexCoord2f(0.0f, (float)srcImageSize.height);
                gl.glVertex2f(0.0f, (float)srcImageSize.height);
                gl.glEnd();
                gl.glColor4fv(savedColor, 0);
                gl.glBindTexture(34037, 0);
                gl.glDisable(34037);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void renderText(final FTGLfont font, final Color fillColor, final String[] texts, final double[][] offsets, VideoBuffer resultBuffer) {
        final int resultTexture = resultBuffer.getTexture();
        final VideoBounds resultBounds = resultBuffer.getBounds();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                GLU glu = VideoRenderSupportImpl.this._vrContext.getGLU();
                float scale = (float)((VideoRenderSupportImpl)VideoRenderSupportImpl.this)._vrContext.getRenderResolution().scale;
                VideoRenderSupportImpl.this.ortho2D(gl, glu, resultBounds.width, resultBounds.height);
                gl.glTranslatef((float)(-resultBounds.x), (float)(-resultBounds.y), 0.0f);
                double[] mvMatrix = new double[16];
                VideoRenderSupportImpl.this.getMatrix(mvMatrix, null);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                gl.glColor4f((float)fillColor.r, (float)fillColor.g, (float)fillColor.b, (float)fillColor.a);
                gl.glEnable(3042);
                gl.glBlendFuncSeparate(770, 771, 1, 771);
                int i = 0;
                while (i < texts.length) {
                    VideoRenderSupportImpl.this.setMatrix(mvMatrix, null);
                    gl.glTranslatef((float)offsets[i][0], (float)offsets[i][1], 0.0f);
                    gl.glScalef(scale, -scale, scale);
                    FTGL.ftglRenderFont((FTGLfont)font, (String)texts[i], (int)65535);
                    ++i;
                }
                gl.glDisable(3042);
                gl.glColor4fv(savedColor, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void renderText(final FTGLfont font, final Color fillColor, final String[] texts, final double[][] offsets, VideoBuffer resultBuffer, DepthBuffer depthBuffer, final double[] mvMatrix, final double[] prjMatrix) {
        final int resultTexture = resultBuffer.getTexture();
        final Size2i resultImageSize = resultBuffer.getImageSize();
        final int depthTexture = depthBuffer != null ? depthBuffer.getTexture() : 0;
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                float scale = (float)((VideoRenderSupportImpl)VideoRenderSupportImpl.this)._vrContext.getRenderResolution().scale;
                gl.glViewport(0, 0, resultImageSize.width, resultImageSize.height);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(prjMatrix, 0);
                gl.glMatrixMode(5888);
                gl.glLoadMatrixd(mvMatrix, 0);
                double[] mvMatrix2 = new double[16];
                VideoRenderSupportImpl.this.getMatrix(mvMatrix2, null);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                if (depthTexture != 0) {
                    gl.glFramebufferTexture2D(36160, 36096, 34037, depthTexture, 0);
                    gl.glEnable(2929);
                    gl.glClearDepth(1.0);
                    gl.glClear(256);
                }
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                float a = (float)fillColor.a;
                float r = (float)fillColor.r * a;
                float g = (float)fillColor.g * a;
                float b = (float)fillColor.b * a;
                gl.glColor4f(r, g, b, a);
                int i = 0;
                while (i < texts.length) {
                    VideoRenderSupportImpl.this.setMatrix(mvMatrix2, null);
                    gl.glTranslatef((float)offsets[i][0], (float)offsets[i][1], 0.0f);
                    gl.glScalef(scale, -scale, scale);
                    FTGL.ftglRenderFont((FTGLfont)font, (String)texts[i], (int)65535);
                    ++i;
                }
                if (depthTexture != 0) {
                    gl.glDisable(2929);
                    gl.glFramebufferTexture2D(36160, 36096, 34037, 0, 0);
                }
                gl.glColor4fv(savedColor, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }
}

