/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.shaders;

import ch.kuramo.javie.api.annotations.GLProgram;
import ch.kuramo.javie.api.annotations.GLShader;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.GLGlobal;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.GLContext;
import javax.media.opengl.Threading;

public class BlendModeShaders {
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    public static final String blend_functions = "blend_functions.frag";
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] NORMAL = BlendModeShaders.createProgramSource("normal");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] DISSOLVE = BlendModeShaders.createProgramSource("dissolve");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] DANCING_DISSOLVE = BlendModeShaders.createProgramSource("dancing_dissolve", true);
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] DARKEN = BlendModeShaders.createProgramSource("darken");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] MULTIPLY = BlendModeShaders.createProgramSource("multiply");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] COLOR_BURN = BlendModeShaders.createProgramSource("color_burn");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] LINEAR_BURN = BlendModeShaders.createProgramSource("linear_burn");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] DARKER_COLOR = BlendModeShaders.createProgramSource("darker_color");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] ADD = BlendModeShaders.createProgramSource("add");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] LIGHTEN = BlendModeShaders.createProgramSource("lighten");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] SCREEN = BlendModeShaders.createProgramSource("screen");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] COLOR_DODGE = BlendModeShaders.createProgramSource("color_dodge");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] LINEAR_DODGE = BlendModeShaders.createProgramSource("linear_dodge");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] LIGHTER_COLOR = BlendModeShaders.createProgramSource("lighter_color");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] OVERLAY = BlendModeShaders.createProgramSource("overlay");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] SOFT_LIGHT = BlendModeShaders.createProgramSource("soft_light");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] HARD_LIGHT = BlendModeShaders.createProgramSource("hard_light");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] LINEAR_LIGHT = BlendModeShaders.createProgramSource("linear_light");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] VIVID_LIGHT = BlendModeShaders.createProgramSource("vivid_light");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] PIN_LIGHT = BlendModeShaders.createProgramSource("pin_light");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] HARD_MIX = BlendModeShaders.createProgramSource("hard_mix");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] DIFFERENCE = BlendModeShaders.createProgramSource("difference");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] EXCLUSION = BlendModeShaders.createProgramSource("exclusion");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] HUE = BlendModeShaders.createProgramSource("hue");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] SATURATION = BlendModeShaders.createProgramSource("saturation");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] COLOR = BlendModeShaders.createProgramSource("color");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] LUMINOSITY = BlendModeShaders.createProgramSource("luminosity");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] STENCIL_ALPHA = BlendModeShaders.createProgramSource("stencil_alpha");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] STENCIL_LUMA = BlendModeShaders.createProgramSource("stencil_luma");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] SILHOUETTE_ALPHA = BlendModeShaders.createProgramSource("silhouette_alpha");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public static final String[] SILHOUETTE_LUMA = BlendModeShaders.createProgramSource("silhouette_luma");
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram(attach={"blend_functions"})
    public final String[] INTERSECTING_BLEND;
    private static int _maxIntersectingLayers;

    private static final String[] createProgramSource(String name, boolean temporal) {
        return new String[]{"uniform sampler2DRect texDst;", "uniform sampler2DRect texSrc;", "uniform float opacity;", temporal ? "uniform float time;" : "", "", String.format("vec4 blend_%s(vec4 pDst, vec4 pSrc, float opacity%s);", name, temporal ? ", float time" : ""), "", "void main(void)", "{", "\tvec2 texCoord = gl_TexCoord[0].st;", "\tvec4 dst = texture2DRect(texDst, texCoord);", "\tvec4 src = texture2DRect(texSrc, texCoord);", String.format("\tdst = blend_%s(vec4(dst.rgb*dst.a, dst.a), src, opacity%s);", name, temporal ? ", time" : ""), "\tgl_FragColor = (dst.a != 0.0) ? vec4(dst.rgb/dst.a, dst.a) : vec4(0.0);", "}"};
    }

    private static final String[] createProgramSource(String name) {
        return BlendModeShaders.createProgramSource(name, false);
    }

    public static int getMaxIntersectingLayers() {
        return _maxIntersectingLayers;
    }

    private String[] createIntersectingBlendSource(boolean intel) {
        List<String> source = Util.newList();
        source.add(String.format("const int maxLayers = %d;", _maxIntersectingLayers));
        source.add("uniform int nLayers;");
        source.add("uniform sampler2DRect texDst;");
        int i = 0;
        while (i < _maxIntersectingLayers) {
            source.add(String.format("uniform sampler2DRect texSrc%d;", i));
            source.add(String.format("uniform sampler2DRect texDep%d;", i));
            ++i;
        }
        if (!intel) {
            source.add("uniform int blendMode[maxLayers];");
        }
        source.add("uniform float opacity[maxLayers];");
        source.add("uniform float time;");
        source.add("vec2 texCoord = gl_TexCoord[0].st;");
        source.add("vec4 getSrc(int i) {");
        source.add("\treturn");
        i = 0;
        while (i < _maxIntersectingLayers) {
            source.add(String.format("\t\t(i == %1$d) ? texture2DRect(texSrc%1$d, texCoord) :", i));
            ++i;
        }
        source.add("\t\tvec4(0.0);");
        source.add("}");
        source.add("float getDep(int i) {");
        source.add("\treturn");
        i = 0;
        while (i < _maxIntersectingLayers) {
            source.add(String.format("\t\t(i == %1$d) ? texture2DRect(texDep%1$d, texCoord).r :", i));
            ++i;
        }
        source.add("\t\t-1.0;");
        source.add("}");
        i = 0;
        while (i < _maxIntersectingLayers) {
            source.add(String.format("int ord%1$d = %1$d;", i));
            ++i;
        }
        source.add("int getOrd(int i) {");
        source.add("\treturn");
        i = 0;
        while (i < _maxIntersectingLayers) {
            source.add(String.format("\t\t(i == %1$d) ? ord%1$d :", i));
            ++i;
        }
        source.add("\t\t-1;");
        source.add("}");
        source.add("void setOrd(int i, int ord) {");
        i = 0;
        while (i < _maxIntersectingLayers - 1) {
            source.add(String.format("\tif (i == %1$d) ord%1$d = ord; else ", i));
            ++i;
        }
        source.add(String.format("\tif (i == %1$d) ord%1$d = ord;", _maxIntersectingLayers - 1));
        source.add("}");
        source.addAll(Arrays.asList(intel ? "vec4 blend_normal(vec4 pDst, vec4 pSrc, float opacity);" : "vec4 blend(int mode, vec4 pDst, vec4 pSrc, float opacity, float time);", "", "void main(void)", "{", "\tvec4 dst = texture2DRect(texDst, texCoord);", "", "\tint nzaCount = 0;", "\tint nzaLayer;", "\tvec4 nzaColor;", "\tfor (int i = 0; i < nLayers; ++i) {", "\t\tvec4 s = getSrc(i);", "\t\tif (s.a > 0.0) {", "\t\t\tif (++nzaCount > 1) {", "\t\t\t\tbreak;", "\t\t\t}", "\t\t\tnzaLayer = i;", "\t\t\tnzaColor = s;", "\t\t}", "\t}", "\tif (nzaCount == 1) {", "\t\tdst = vec4(dst.rgb*dst.a, dst.a);", intel ? "\t\tdst = blend_normal(dst, nzaColor, opacity[nzaLayer]);" : "\t\tdst = blend(blendMode[nzaLayer], dst, nzaColor, opacity[nzaLayer], time);", "\t\tdst = (dst.a != 0.0) ? vec4(dst.rgb/dst.a, dst.a) : vec4(0.0);", "", "\t} else if (nzaCount > 1) {", "\t\tdst = vec4(dst.rgb*dst.a, dst.a);", "\t\t", "\t\tfor (int i = nLayers - 2; i >= 0; --i) {", "\t\t\tint ord = getOrd(i);", "\t\t\tfloat dep = getDep(ord);", "\t\t\tint j, ord2;", "\t\t\tfor (j = i + 1; j < nLayers && getDep(ord2 = getOrd(j)) > dep; ++j) {", "\t\t\t\tsetOrd(j - 1, ord2);", "\t\t\t}", "\t\t\tsetOrd(j - 1, ord);", "\t\t}", "\t\t", "\t\tfor (int i = 0; i < nLayers; ++i) {", "\t\t\tint ord = getOrd(i);", intel ? "\t\t\tdst = blend_normal(dst, getSrc(ord), opacity[ord]);" : "\t\t\tdst = blend(blendMode[ord], dst, getSrc(ord), opacity[ord], time);", "\t\t}", "\t\tdst = (dst.a != 0.0) ? vec4(dst.rgb/dst.a, dst.a) : vec4(0.0);", "\t}", "", "\tgl_FragColor = dst;", "}"));
        return source.toArray(new String[source.size()]);
    }

    @Inject
    public BlendModeShaders(final GLGlobal glGlobal) {
        final int[] texUnits = new int[1];
        Threading.invokeOnOpenGLThread((Runnable)new Runnable(){

            public void run() {
                GLContext context = glGlobal.getSharedContext();
                context.makeCurrent();
                try {
                    GL2 gl = context.getGL().getGL2();
                    gl.glGetIntegerv(34930, texUnits, 0);
                }
                finally {
                    context.release();
                }
            }
        });
        _maxIntersectingLayers = (Math.min(32, texUnits[0]) - 1) / 2;
        this.INTERSECTING_BLEND = this.createIntersectingBlendSource(glGlobal.isIntel());
    }
}

