/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;

public class IntelGMAWorkaround {
    public static void workaround() {
        if (!System.getProperty("os.name").toLowerCase().contains("windows")) {
            return;
        }
        File workingDir = new File(System.getProperty("user.dir"));
        File logFile = IntelGMAWorkaround.lastJvmLogFile(workingDir);
        if (logFile == null) {
            return;
        }
        try {
            if (!IntelGMAWorkaround.gmaCrashed(logFile)) {
                return;
            }
            System.setProperty("sun.java2d.opengl", "false");
            IntelGMAWorkaround.createNewIniFile(workingDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static File lastJvmLogFile(File workingDir) {
        final Pattern namePat = Pattern.compile("^hs_err_pid\\d+\\.log$");
        File[] logFiles = workingDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && namePat.matcher(pathname.getName()).matches();
            }
        });
        if (logFiles.length == 0) {
            return null;
        }
        Arrays.sort(logFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return (int)Math.signum(o2.lastModified() - o1.lastModified());
            }
        });
        File lastLogFile = logFiles[0];
        if (System.currentTimeMillis() - lastLogFile.lastModified() >= 3600000L) {
            return null;
        }
        return lastLogFile;
    }

    private static boolean gmaCrashed(File logFile) throws IOException {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(logFile));
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("C  [ig4icd32.dll+") && !line.contains("C  [ig4icd64.dll+")) continue;
                return true;
            }
            return false;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    private static void createNewIniFile(File dir) throws IOException {
        File iniFile = new File(dir, "Javie.ini");
        String newIni = IntelGMAWorkaround.createNewIni(iniFile);
        if (newIni == null) {
            return;
        }
        File bakFile = new File(dir, "Javie.ini.bak");
        int i = 1;
        while (bakFile.exists()) {
            bakFile = new File(dir, "Javie.ini.bak-" + i);
            ++i;
        }
        iniFile.renameTo(bakFile);
        FileWriter fw = new FileWriter(iniFile);
        try {
            fw.write(newIni);
        }
        finally {
            fw.close();
        }
    }

    private static String createNewIni(File iniFile) throws IOException {
        boolean create = false;
        StringWriter sw = new StringWriter((int)iniFile.length());
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(iniFile));
            pw = new PrintWriter(sw);
            while ((line = br.readLine()) != null) {
                if (line.equals("-Dsun.java2d.opengl=true")) {
                    line = "-Dsun.java2d.opengl=false";
                    create = true;
                }
                pw.println(line);
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (br != null) {
                br.close();
            }
        }
        return create ? sw.toString() : null;
    }

    private IntelGMAWorkaround() {
    }
}

