/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ModifyLayerParentOperation
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;
    private final String _oldParentId;
    private final String _newParentId;

    public ModifyLayerParentOperation(ProjectManager projectManager, Layer layer, Layer newParent) {
        super(projectManager, "\u89aa\u306e\u5909\u66f4");
        LayerComposition comp = projectManager.checkLayer(layer);
        if (newParent != null && projectManager.checkLayer(newParent) != comp) {
            throw new IllegalArgumentException("layer and parent must belong to same composition");
        }
        Layer oldParent = layer.getParent();
        this._noEffect = newParent == oldParent;
        this._compId = comp.getId();
        this._layerId = layer.getId();
        this._oldParentId = oldParent != null ? oldParent.getId() : null;
        this._newParentId = newParent != null ? newParent.getId() : null;
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyParent(this._newParentId, project, pm);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyParent(this._oldParentId, project, pm);
        return Status.OK_STATUS;
    }

    private void modifyParent(String parentId, Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Layer layer = comp.getLayer(this._layerId);
        Layer parent = parentId != null ? comp.getLayer(parentId) : null;
        layer.setParent(parent);
        if (pm != null) {
            pm.fireLayerPropertyChange(layer, "parent");
        }
    }
}

