/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiftKeyframesOperation
extends ProjectOperation {
    private final String _compId;
    private final Object[][] _keyframeData;
    private final String[] _savedAvalues;
    private String[] _newAvalues;
    private Time _shiftTime;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public ShiftKeyframesOperation(ProjectManager projectManager, LayerComposition comp, Object[][] keyframeData, String[] baseAnimatableValues, Time shiftTime, String relation) {
        super(projectManager, "\u30ad\u30fc\u30d5\u30ec\u30fc\u30e0\u306e\u79fb\u52d5", relation);
        InjectorHolder.getInjector().injectMembers((Object)this);
        projectManager.checkComposition((Composition)comp);
        this._compId = comp.getId();
        this._keyframeData = keyframeData;
        this._savedAvalues = new String[this._keyframeData.length];
        this._newAvalues = new String[this._keyframeData.length];
        this._shiftTime = shiftTime;
        this.init(comp, baseAnimatableValues);
    }

    private void init(LayerComposition comp, String[] baseAnimatableValues) {
        AnimatableValue[] newAvalues = new AnimatableValue[this._keyframeData.length];
        Map map = Util.newMap();
        int i = 0;
        int n = this._keyframeData.length;
        while (i < n) {
            AnimatableValue avalue;
            Layer layer = comp.getLayer((String)this._keyframeData[i][0]);
            Integer effectIndex = (Integer)this._keyframeData[i][1];
            String property = (String)this._keyframeData[i][2];
            Keyframe kf = (Keyframe)this._keyframeData[i][3];
            if (effectIndex == -1) {
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(effectIndex);
                avalue = (AnimatableValue)PropertyUtil.getProperty(effect, property);
            }
            AnimatableValue newAvalue = (AnimatableValue)map.get(avalue);
            if (newAvalue == null) {
                this._savedAvalues[i] = this._encoder.encodeElement((Object)avalue);
                try {
                    newAvalue = (AnimatableValue)this._decoder.decodeElement((CharSequence)baseAnimatableValues[i], avalue.getClass());
                }
                catch (ProjectDecodeException e) {
                    throw new JavieRuntimeException((Throwable)e);
                }
                map.put(avalue, newAvalue);
                newAvalues[i] = newAvalue;
            }
            AnimatableValue tmp = newAvalue;
            tmp.putKeyframe(kf.time.add(this._shiftTime), kf.value, kf.interpolation);
            ++i;
        }
        i = 0;
        n = newAvalues.length;
        while (i < n) {
            if (newAvalues[i] != null) {
                this._newAvalues[i] = this._encoder.encodeElement((Object)newAvalues[i]);
            }
            ++i;
        }
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.shiftOrRestore(true, project, pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.shiftOrRestore(false, project, pm);
        return Status.OK_STATUS;
    }

    private void shiftOrRestore(boolean shift, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Object[][] data = pm != null ? new Object[this._keyframeData.length][] : null;
        int i = 0;
        int n = this._keyframeData.length;
        while (i < n) {
            AnimatableValue avalue;
            Layer layer = comp.getLayer((String)this._keyframeData[i][0]);
            Integer effectIndex = (Integer)this._keyframeData[i][1];
            String property = (String)this._keyframeData[i][2];
            Keyframe kf = (Keyframe)this._keyframeData[i][3];
            if (effectIndex == -1) {
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(effectIndex);
                avalue = (AnimatableValue)PropertyUtil.getProperty(effect, property);
            }
            if (shift) {
                if (this._newAvalues[i] != null) {
                    this.restore(this._newAvalues[i], avalue);
                }
                if (pm != null) {
                    data[i] = new Object[]{layer, effectIndex, property, kf.time.add(this._shiftTime)};
                }
            } else {
                if (this._savedAvalues[i] != null) {
                    this.restore(this._savedAvalues[i], avalue);
                }
                if (pm != null) {
                    data[i] = new Object[]{layer, effectIndex, property, kf.time};
                }
            }
            ++i;
        }
        if (pm != null) {
            pm.fireKeyframesChange(comp, data);
        }
    }

    private <A extends AnimatableValue<V>, V> void restore(String data, A dst) throws ExecutionException {
        try {
            AnimatableValue src = (AnimatableValue)this._decoder.decodeElement((CharSequence)data, dst.getClass());
            dst.reset(src.getStaticValue());
            dst.setExpression(src.getExpression());
            for (Keyframe kf : src.getKeyframes()) {
                dst.putKeyframe(kf);
            }
        }
        catch (ProjectDecodeException e) {
            throw new ExecutionException("error decoding AnimatableValue data", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean merge(ProjectOperation operation, IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) {
        if (pm == null) {
            try {
                ShiftKeyframesOperation shiftKeyframesOperation = this;
                synchronized (shiftKeyframesOperation) {
                    this.shiftOrRestore(true, project, null);
                }
            }
            catch (ExecutionException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            return true;
        }
        if (!(operation instanceof ShiftKeyframesOperation)) {
            return false;
        }
        ShiftKeyframesOperation newOp = (ShiftKeyframesOperation)operation;
        if (!newOp._compId.equals(this._compId) || newOp._keyframeData != this._keyframeData) {
            return false;
        }
        if (!newOp._shiftTime.equals((Object)this._shiftTime)) {
            ShiftKeyframesOperation shiftKeyframesOperation = this;
            synchronized (shiftKeyframesOperation) {
                this._newAvalues = newOp._newAvalues;
                this._shiftTime = newOp._shiftTime;
            }
            try {
                this.shiftOrRestore(true, project, pm);
            }
            catch (ExecutionException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            this._noEffect = this._shiftTime.timeValue == 0L;
        }
        return true;
    }
}

