/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.transition;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import com.google.inject.Inject;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

@Effect(id="ch.kuramo.javie.LinearWipe", category="ch.kuramo.javie.api.effectCategory.transition")
public class LinearWipe {
    private final IVideoEffectContext context;
    private final IArrayPools arrayPools;
    @Property(min="0", max="100")
    private IAnimatableDouble transitionCompletion;
    @Property(value="90")
    private IAnimatableDouble wipeAngle;
    @Property(min="0", max="32000")
    private IAnimatableDouble feather;

    @Inject
    public LinearWipe(IVideoEffectContext context, IArrayPools arrayPools) {
        this.context = context;
        this.arrayPools = arrayPools;
    }

    public IVideoBuffer doVideoEffect() {
        double completion = (Double)this.context.value((IAnimatableValue)this.transitionCompletion) / 100.0;
        if (completion == 0.0) {
            return null;
        }
        if (completion == 1.0) {
            IVideoBuffer vb = this.context.doPreviousEffect();
            VideoEffectUtil.clearTexture(vb, this.context.getGL().getGL2());
            return vb;
        }
        double wipeAngle = (Double)this.context.value((IAnimatableValue)this.wipeAngle) % 360.0;
        if (wipeAngle < 0.0) {
            wipeAngle += 360.0;
        }
        double feather = (Double)this.context.value((IAnimatableValue)this.feather);
        feather = this.context.getRenderResolution().scale(feather);
        IVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds bounds = input.getBounds();
        int w = bounds.width;
        int h = bounds.height;
        double theta = Math.toRadians(wipeAngle);
        double wipeLen = (double)h * Math.abs(Math.cos(theta)) + (double)w * Math.abs(Math.sin(theta));
        double wipeWidth = (double)w * Math.abs(Math.cos(theta)) + (double)h * Math.abs(Math.sin(theta));
        GL2 gl = this.context.getGL().getGL2();
        GLU glu = this.context.getGLU();
        VideoEffectUtil.ortho2D(gl, glu, w, h);
        gl.glMatrixMode(5888);
        gl.glTranslatef((float)w / 2.0f, (float)h / 2.0f, 0.0f);
        gl.glRotatef((float)wipeAngle, 0.0f, 0.0f, 1.0f);
        gl.glScalef((float)(wipeWidth / (double)w), (float)(wipeLen / (double)h), 1.0f);
        gl.glTranslatef((float)(-w) / 2.0f, (float)(-h) / 2.0f, 0.0f);
        int[] wipeTex = new int[1];
        gl.glGenTextures(1, wipeTex, 0);
        try {
            gl.glFramebufferTexture2D(36160, 36064, 34037, input.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(3552, wipeTex[0]);
            gl.glTexParameteri(3552, 10241, 9729);
            gl.glTexParameteri(3552, 10240, 9729);
            gl.glTexParameteri(3552, 10242, 33071);
            gl.glTexParameteri(3552, 10243, 33071);
            this.prepareWipeTexture((int)Math.round(wipeLen), (float)completion, (float)feather, gl);
            gl.glEnable(3552);
            gl.glEnable(3042);
            gl.glBlendFuncSeparate(0, 770, 0, 770);
            gl.glBegin(7);
            gl.glTexCoord1f(1.0f);
            gl.glVertex2f(0.0f, 0.0f);
            gl.glTexCoord1f(1.0f);
            gl.glVertex2f((float)w, 0.0f);
            gl.glTexCoord1f(0.0f);
            gl.glVertex2f((float)w, (float)h);
            gl.glTexCoord1f(0.0f);
            gl.glVertex2f(0.0f, (float)h);
            gl.glEnd();
            gl.glDisable(3042);
            gl.glDisable(3552);
            gl.glBindTexture(3552, 0);
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
        }
        finally {
            gl.glDeleteTextures(1, wipeTex, 0);
        }
        return input;
    }

    private void prepareWipeTexture(int wipeLen, float completion, float feather, GL2 gl) {
        int intFeather = (int)Math.ceil(feather);
        int tmpDataLen = wipeLen + 4 * intFeather;
        float completionPoint = (float)intFeather + (float)(wipeLen + 2 * intFeather) * completion;
        int completionIndex = (int)completionPoint;
        IArray tmpArray = this.arrayPools.getFloatArray(tmpDataLen);
        IArray wipeArray = null;
        IArray kernelArray = null;
        try {
            FloatBuffer buffer;
            float[] tmpData = (float[])tmpArray.getArray();
            if (completionIndex + intFeather == tmpDataLen) {
                Arrays.fill(tmpData, 0, tmpDataLen, 0.0f);
                buffer = FloatBuffer.wrap(tmpData, 0, tmpDataLen);
            } else if (tmpDataLen == wipeLen) {
                Arrays.fill(tmpData, 0, completionIndex, 0.0f);
                tmpData[completionIndex] = 1.0f - (completionPoint - (float)completionIndex);
                Arrays.fill(tmpData, completionIndex + 1, tmpDataLen, 1.0f);
                buffer = FloatBuffer.wrap(tmpData, 0, tmpDataLen);
            } else {
                int kernelLen = intFeather * 2 + 1;
                kernelArray = this.arrayPools.getFloatArray(kernelLen);
                float[] kernel = (float[])kernelArray.getArray();
                float sigma = feather / 2.5f;
                float sigmaSquare = sigma * sigma;
                float ksum = 0.0f;
                int i = 1;
                while (i <= intFeather) {
                    float f = (float)Math.exp((float)(-i * i) / (2.0f * sigmaSquare));
                    kernel[intFeather - i] = f;
                    ksum += 2.0f * f;
                    ++i;
                }
                kernel[intFeather] = 1.0f / (ksum += 1.0f);
                i = 1;
                while (i <= intFeather) {
                    int n = intFeather - i;
                    float f = kernel[n] / ksum;
                    kernel[n] = f;
                    kernel[intFeather + i] = f;
                    ++i;
                }
                float fractionAtCompletionIndex = 1.0f - (completionPoint - (float)completionIndex);
                Arrays.fill(tmpData, 0, completionIndex - intFeather, 0.0f);
                tmpData[completionIndex - intFeather] = fractionAtCompletionIndex * kernel[0];
                float sum = 0.0f;
                int k = 1;
                while (k < kernelLen) {
                    tmpData[completionIndex - intFeather + k] = (sum += kernel[k]) + fractionAtCompletionIndex * kernel[k - 1];
                    ++k;
                }
                Arrays.fill(tmpData, completionIndex + intFeather + 1, tmpDataLen, 1.0f);
                wipeArray = this.arrayPools.getFloatArray(wipeLen);
                float[] wipeData = (float[])wipeArray.getArray();
                System.arraycopy(tmpData, 2 * intFeather, wipeData, 0, wipeLen);
                buffer = FloatBuffer.wrap(wipeData, 0, wipeLen);
            }
            switch (this.context.getColorMode()) {
                case RGBA8: {
                    gl.glTexImage1D(3552, 0, 32828, wipeLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA16: {
                    gl.glTexImage1D(3552, 0, 32830, wipeLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA16_FLOAT: {
                    gl.glTexImage1D(3552, 0, 34844, wipeLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA32_FLOAT: {
                    gl.glTexImage1D(3552, 0, 34838, wipeLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown ColorMode: " + this.context.getColorMode());
                }
            }
        }
        finally {
            tmpArray.release();
            if (wipeArray != null) {
                wipeArray.release();
            }
            if (kernelArray != null) {
                kernelArray.release();
            }
        }
    }
}

