/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.utility;

import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import com.google.inject.Inject;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

@Effect(id="ch.kuramo.javie.ChangeBounds", category="ch.kuramo.javie.api.effectCategory.utility")
public class ChangeBounds {
    private final IVideoEffectContext context;
    @Property(max="1000")
    private IAnimatableInteger left;
    @Property(max="1000")
    private IAnimatableInteger top;
    @Property(max="1000")
    private IAnimatableInteger right;
    @Property(max="1000")
    private IAnimatableInteger bottom;

    @Inject
    public ChangeBounds(IVideoEffectContext context) {
        this.context = context;
    }

    public VideoBounds getVideoBounds() {
        RenderResolution resolution = this.context.getRenderResolution();
        int left = (int)resolution.scale((double)((Integer)this.context.value((IAnimatableValue)this.left)).intValue());
        int top = (int)resolution.scale((double)((Integer)this.context.value((IAnimatableValue)this.top)).intValue());
        int right = (int)resolution.scale((double)((Integer)this.context.value((IAnimatableValue)this.right)).intValue());
        int bottom = (int)resolution.scale((double)((Integer)this.context.value((IAnimatableValue)this.bottom)).intValue());
        VideoBounds bounds = this.context.getPreviousBounds();
        return new VideoBounds(bounds.x - (double)left, bounds.y - (double)top, Math.max(0, bounds.width + left + right), Math.max(0, bounds.height + top + bottom));
    }

    public IVideoBuffer doVideoEffect() {
        RenderResolution resolution = this.context.getRenderResolution();
        int left = (int)resolution.scale((double)((Integer)this.context.value((IAnimatableValue)this.left)).intValue());
        int top = (int)resolution.scale((double)((Integer)this.context.value((IAnimatableValue)this.top)).intValue());
        int right = (int)resolution.scale((double)((Integer)this.context.value((IAnimatableValue)this.right)).intValue());
        int bottom = (int)resolution.scale((double)((Integer)this.context.value((IAnimatableValue)this.bottom)).intValue());
        IVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds oldBounds = input.getBounds();
        VideoBounds newBounds = new VideoBounds(oldBounds.x - (double)left, oldBounds.y - (double)top, Math.max(0, oldBounds.width + left + right), Math.max(0, oldBounds.height + top + bottom));
        if (newBounds.equals((Object)oldBounds)) {
            return input;
        }
        IVideoBuffer buffer = this.context.createVideoBuffer(newBounds);
        try {
            GL2 gl = this.context.getGL().getGL2();
            GLU glu = this.context.getGLU();
            VideoEffectUtil.clearTexture(buffer, gl);
            VideoEffectUtil.ortho2D(gl, glu, newBounds.width, newBounds.height);
            gl.glMatrixMode(5888);
            gl.glTranslatef((float)left, (float)top, 0.0f);
            gl.glFramebufferTexture2D(36160, 36064, 34037, buffer.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, input.getTexture());
            gl.glEnable(34037);
            gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            int w = oldBounds.width;
            int h = oldBounds.height;
            gl.glBegin(7);
            gl.glTexCoord2f(0.0f, 0.0f);
            gl.glVertex2f(0.0f, 0.0f);
            gl.glTexCoord2f((float)w, 0.0f);
            gl.glVertex2f((float)w, 0.0f);
            gl.glTexCoord2f((float)w, (float)h);
            gl.glVertex2f((float)w, (float)h);
            gl.glTexCoord2f(0.0f, (float)h);
            gl.glVertex2f(0.0f, (float)h);
            gl.glEnd();
            gl.glDisable(34037);
            gl.glBindTexture(34037, 0);
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            IVideoBuffer output = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = output;
            return iVideoBuffer;
        }
        finally {
            input.dispose();
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }
}

