/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.project.ClearEffectKeyframesOperation;
import ch.kuramo.javie.app.project.ModifyEffectAnimatableValueOperation;
import ch.kuramo.javie.app.project.ModifyEffectExpressionOperation;
import ch.kuramo.javie.app.project.ModifyEffectKeyframeOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableBoolean;
import ch.kuramo.javie.core.AnimatableColor;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableEnum;
import ch.kuramo.javie.core.AnimatableInteger;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.AnimatableVec2d;
import ch.kuramo.javie.core.AnimatableVec3d;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.PropertyDescriptor;

public class EffectAnimatableValueElement extends AnimatableValueElement {

	protected final EffectableLayer layer;

	protected final Effect effect;

	protected final PropertyDescriptor descriptor;


	public EffectAnimatableValueElement(Element parent, EffectableLayer layer, Effect effect, PropertyDescriptor descriptor) {
		super(parent);
		this.layer = layer;
		this.effect = effect;
		this.descriptor = descriptor;
	}

	protected AnimatableValueElementDelegate<?> createDelegate() {
		AnimatableValue<?> avalue = (AnimatableValue<?>) descriptor.get(effect);
		String label = descriptor.getLabel();
		String unit = null; // TODO descriptor.getUnit();

		if (avalue instanceof AnimatableVec3d) {
			return new AnimatableVec3dElementDelegate(this, label, (AnimatableVec3d) avalue, true, unit);

		} else if (avalue instanceof AnimatableVec2d) {
			return new AnimatableVec2dElementDelegate(this, label, (AnimatableVec2d) avalue, unit);

		} else if (avalue instanceof AnimatableDouble) {
			return new AnimatableDoubleElementDelegate(this, label, (AnimatableDouble) avalue, unit);

		} else if (avalue instanceof AnimatableInteger) {
			return new AnimatableIntegerElementDelegate(this, label, (AnimatableInteger) avalue, unit);

		} else if (avalue instanceof AnimatableString) {
			return new AnimatableStringElementDelegate(this, label, (AnimatableString) avalue);

		} else if (avalue instanceof AnimatableBoolean) {
			return new AnimatableBooleanElementDelegate(this, label, (AnimatableBoolean) avalue);

		} else if (avalue instanceof AnimatableColor) {
			return new AnimatableColorElementDelegate(this, label, (AnimatableColor) avalue);

		} else if (avalue instanceof AnimatableEnum<?>) {
			@SuppressWarnings("unchecked")
			AnimatableEnumElementDelegate<?> delegate = new AnimatableEnumElementDelegate(this, label, (AnimatableEnum) avalue);
			return delegate;

		} else {
			throw new JavieRuntimeException("unsupported property type: " + avalue.getClass().getName());
		}
	}

	protected ProjectOperation createModifyValueOperation(ProjectManager pm, Object newValue, String relation) {
		return new ModifyEffectAnimatableValueOperation<Object>(
				pm, layer, layer.getEffects().indexOf(effect), descriptor.getName(), newValue, relation, descriptor.getLabel());
	}

	protected ProjectOperation createModifyExpressionOperation(ProjectManager pm, String newExpr) {
		return new ModifyEffectExpressionOperation(pm, layer, layer.getEffects().indexOf(effect), descriptor.getName(), newExpr);
	}

	protected ProjectOperation createModifyKeyframeOperation(ProjectManager pm, Time time, Object newValue, String relation) {
		return new ModifyEffectKeyframeOperation<Object>(
				pm, layer, layer.getEffects().indexOf(effect), descriptor.getName(), time, newValue, relation, descriptor.getLabel());
	}

	protected ProjectOperation createClearKeyframesOperation(ProjectManager pm) {
		return new ClearEffectKeyframesOperation<Object>(pm, layer, layer.getEffects().indexOf(effect), descriptor.getName());
	}

	protected String getDefaultExpression() {
		return "thisEffect." + descriptor.getName();
	}

	public String getProperty() {
		return descriptor.getName();
	}

}
