/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import java.util.Collection;
import java.util.Set;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

import ch.kuramo.javie.api.plugin.PIAnimatableDouble;
import ch.kuramo.javie.core.exprelems.DoubleProperty;

public class AnimatableDouble extends AbstractAnimatableValue<Double> implements PIAnimatableDouble {

	private static final Set<Interpolation> SUPPORTED_INTERPOLATIONS = Util.unmodifiableSet(
			Interpolation.HOLD, Interpolation.LINEAR, Interpolation.CATMULL_ROM);


	public AnimatableDouble(Double staticValue, Collection<Keyframe<Double>> keyframes, String expression) {
		super(staticValue, keyframes, expression);
	}

	public AnimatableDouble(Double staticValue) {
		super(staticValue);
	}

	public Double jsToJava(Object jsValue) {
		return (Double) Context.jsToJava(jsValue, double.class);
	}

	@Override
	protected double[] toArray(Double value) {
		return new double[] { value.doubleValue() };
	}

	@Override
	protected Double valueOf(double[] d) {
		return d[0];
	}

	@Override
	public Set<Interpolation> supportedInterpolations() {
		return SUPPORTED_INTERPOLATIONS;
	}

	public Scriptable createExpressionElement(final RenderContext renderContext) {
		DoubleProperty dp = new DoubleProperty() {
			public double getValue()			{ return value(renderContext); }
			public double valueAtTime(double t)	{ return AnimatableDouble.this.valueAtTime(t, renderContext); }
		};
		return renderContext.toNativeJavaObject(dp, ScriptRuntime.NumberClass);
	}

}
