/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import java.util.Collection;
import java.util.Set;

import org.mozilla.javascript.Context;

import ch.kuramo.javie.api.plugin.PIAnimatableString;
import ch.kuramo.javie.core.exprelems.StringProperty;

public class AnimatableString extends AbstractAnimatableValue<String> implements PIAnimatableString {

	private static final Set<Interpolation> SUPPORTED_INTERPOLATIONS = Util.unmodifiableSet(Interpolation.HOLD);


	public AnimatableString(String staticValue, Collection<Keyframe<String>> keyframes, String expression) {
		super(staticValue, keyframes, expression);
	}

	public AnimatableString(String staticValue) {
		super(staticValue);
	}

	public String jsToJava(Object jsValue) {
		return (String) Context.jsToJava(jsValue, String.class);
	}

	@Override
	protected double[] toArray(String value) {
		throw new UnsupportedOperationException();
	}

	@Override
	protected String valueOf(double[] d) {
		throw new UnsupportedOperationException();
	}

	@Override
	public Set<Interpolation> supportedInterpolations() {
		return SUPPORTED_INTERPOLATIONS;
	}

	public StringProperty createExpressionElement(final RenderContext renderContext) {
		return new StringProperty() {
			public String getValue()			{ return value(renderContext); }
			public String valueAtTime(double t)	{ return AnimatableString.this.valueAtTime(t, renderContext); }
		};
	}

}
