/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import ch.kuramo.javie.api.Time;

public class TimeCode {

	public static String toTimeCode(Time time, Time frameDuration) {
		return toTimeCode(time, frameDuration, true, true);
	}

	public static String toTimeCode(Time time, Time frameDuration, boolean dropFrame, boolean withZeroHour) {
		if (frameDuration.equals(FrameDuration.FPS_59_94)) {
			return toTimeCode(time, frameDuration, 60, dropFrame ? 4 : 0, withZeroHour);

		} else if (frameDuration.equals(FrameDuration.FPS_29_97)) {
			return toTimeCode(time, frameDuration, 30, dropFrame ? 2 : 0, withZeroHour);

		} else {
			double fps = (double)frameDuration.timeScale/frameDuration.timeValue;
			String fpsStr = String.format("%.2f", fps);

			if (fpsStr.equals("59.94")) {
				return toTimeCode(time, frameDuration, 60, dropFrame ? 4 : 0, withZeroHour);

			} else if (fpsStr.equals("29.97")) {
				return toTimeCode(time, frameDuration, 30, dropFrame ? 2 : 0, withZeroHour);
				
			} else {
				return toTimeCode(time, frameDuration, (int)Math.round(fps), 0, withZeroHour);
			}
		}
	}

	private static String toTimeCode(Time time, Time frameDuration, int base, int drop, boolean withZeroHour) {
		long frames = time.toFrameNumber(frameDuration);

		int fpm = base * 60 - drop;
		int fp10m = fpm * 10 + drop;
		int fph = fp10m * 6;

		long h = frames / fph;
		frames %= fph;

		long tenm = frames / fp10m;
		frames %= fp10m;

		long m = frames / fpm;
		frames %= fpm;

		long s = frames / base;
		frames %= base;

		if (drop == 0) {
			return (withZeroHour || h != 0) ? String.format("%d:%01d%01d:%02d:%02d", h, tenm, m, s, frames)
											: String.format("%01d%01d:%02d:%02d", tenm, m, s, frames);

		} else {
			if (s == 0 && m != 0 && frames < drop) {
				--m;
				s = 59;
				frames += base - drop;
			}
			return (withZeroHour || h != 0) ? String.format("%d;%01d%01d;%02d;%02d", h, tenm, m, s, frames)
											: String.format("%01d%01d;%02d;%02d", tenm, m, s, frames);
		}
	}

}
