/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal;

import org.mozilla.javascript.Scriptable;

import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.AbstractLayer;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableVec3d;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.RenderContext;
import ch.kuramo.javie.core.annotations.ProjectElement;

@ProjectElement("cameraLayer")
public class CameraLayerImpl extends AbstractLayer implements CameraLayer {

	private boolean _videoEnabled = true;

	private AnimatableVec3d _pointOfInterest = new AnimatableVec3d(new Vec3d(0, 0, 0));

	private AnimatableVec3d _position = new AnimatableVec3d(new Vec3d(0, 0, 0));

	private AnimatableVec3d _orientation = new AnimatableVec3d(new Vec3d(0, 0, 0));

	private AnimatableDouble _rotationX = new AnimatableDouble(0d);

	private AnimatableDouble _rotationY = new AnimatableDouble(0d);

	private AnimatableDouble _rotationZ = new AnimatableDouble(0d);

	private AnimatableDouble _zoom = new AnimatableDouble(100d);

	private AnimatableDouble _near = new AnimatableDouble(1d);

	private AnimatableDouble _far = new AnimatableDouble(1000d);


	public boolean isVideoEnabled() {
		return _videoEnabled;
	}

	public void setVideoEnabled(boolean enabled) {
		_videoEnabled = enabled;
	}

	public AnimatableVec3d getPointOfInterest() {
		return _pointOfInterest;
	}

	public void setPointOfInterest(AnimatableVec3d pointOfInterest) {
		_pointOfInterest = pointOfInterest;
	}

	public AnimatableVec3d getPosition() {
		return _position;
	}

	public void setPosition(AnimatableVec3d position) {
		_position = position;
	}

	public AnimatableVec3d getOrientation() {
		return _orientation;
	}

	public void setOrientation(AnimatableVec3d orientation) {
		_orientation = orientation;
	}

	public AnimatableDouble getRotationX() {
		return _rotationX;
	}

	public void setRotationX(AnimatableDouble rotationX) {
		_rotationX = rotationX;
	}

	public AnimatableDouble getRotationY() {
		return _rotationY;
	}

	public void setRotationY(AnimatableDouble rotationY) {
		_rotationY = rotationY;
	}

	public AnimatableDouble getRotationZ() {
		return _rotationZ;
	}

	public void setRotationZ(AnimatableDouble rotationZ) {
		_rotationZ = rotationZ;
	}

	public AnimatableDouble getZoom() {
		return _zoom;
	}

	public void setZoom(AnimatableDouble zoom) {
		_zoom = zoom;
	}

	public AnimatableDouble getNear() {
		return _near;
	}

	public void setNear(AnimatableDouble near) {
		_near = near;
	}

	public AnimatableDouble getFar() {
		return _far;
	}

	public void setFar(AnimatableDouble far) {
		_far = far;
	}

	@Override
	public void prepareExpression(ExpressionScope scope) {
		super.prepareExpression(scope);

		scope.assignTo(_orientation);
		scope.assignTo(_rotationX);
		scope.assignTo(_rotationY);
		scope.assignTo(_rotationZ);
		scope.assignTo(_position);
		scope.assignTo(_pointOfInterest);
		scope.assignTo(_zoom);
		scope.assignTo(_near);
		scope.assignTo(_far);
	}

	public Object createExpressionElement(RenderContext renderContext) {
		return new CameraLayerExpressionElement(renderContext);
	}

	public class CameraLayerExpressionElement extends LayerExpressionElement {

		public CameraLayerExpressionElement(RenderContext renderContext) {
			super(renderContext);
		}

		public Scriptable[] getOrientation()		{ return elem(_orientation); }
		public Scriptable getRotation()				{ return getRotationZ(); }		// ←カメラにもこれ必要だろうか？
		public Scriptable getRotationX()			{ return elem(_rotationX); }
		public Scriptable getRotationY()			{ return elem(_rotationY); }
		public Scriptable getRotationZ()			{ return elem(_rotationZ); }
		public Scriptable[] getPosition()			{ return elem(_position); }
		public Scriptable[] getPointOfInterest()	{ return elem(_pointOfInterest); }
		public Scriptable getZoom()					{ return elem(_zoom); }
		public Scriptable getNear()					{ return elem(_near); }
		public Scriptable getFar()					{ return elem(_far); }
	}

}
