/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IObjectArray;
import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.core.AbstractTransformableLayer;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.AnimatableVec2d;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.BlendMode;
import ch.kuramo.javie.core.Camera;
import ch.kuramo.javie.core.CollapseTransformation;
import ch.kuramo.javie.core.DepthBuffer;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.FrameBlend;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.MotionBlur;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.RenderContext;
import ch.kuramo.javie.core.TrackMatte;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.VectorMediaInput;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.VideoLayerBuffer;
import ch.kuramo.javie.core.VideoLayerComposer;
import ch.kuramo.javie.core.VideoLayerRenderer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.LayerMatrixUtil;
import ch.kuramo.javie.core.internal.VideoLayerBufferImpl;
import ch.kuramo.javie.core.services.AudioEffectPipeline;
import ch.kuramo.javie.core.services.AudioRenderContext;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.VideoEffectPipeline;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMediaLayer
extends AbstractTransformableLayer
implements MediaLayer {
    private boolean _videoNature;
    private boolean _audioNature;
    private boolean _videoEnabled;
    private boolean _audioEnabled;
    private boolean _effectsEnabled = true;
    private List<Effect> _effects = Util.newList();
    private boolean _motionBlurEnabled = false;
    private TrackMatte _trackMatte = TrackMatte.NONE;
    private AnimatableVec2d _depthBase = new AnimatableVec2d(new Vec2d(0.0, 0.0));
    private AnimatableString _intersectionGroup = new AnimatableString("");
    private AnimatableDouble _opacity = new AnimatableDouble((Double)100.0, 0.0, 100.0);
    private BlendMode _blendMode = BlendMode.NORMAL;
    private AnimatableVec2d _audioLevels = new AnimatableVec2d(Vec2d.ZERO, new Vec2d(-48.0, -48.0), new Vec2d(48.0, 48.0));
    private AnimatableDouble _timeRemap = new AnimatableDouble(0.0);
    @Inject
    private VideoRenderContext _vrContext;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private VideoEffectPipeline _vePipeline;
    @Inject
    private GLGlobal _glGlobal;
    @Inject
    private AudioRenderContext _arContext;
    @Inject
    private AudioRenderSupport _arSupport;
    @Inject
    private AudioEffectPipeline _aePipeline;
    @Inject
    private IArrayPools _arrayPools;

    @Override
    public void initialize() {
        throw new UnsupportedOperationException("Use initialize(boolean, boolean) method instead.");
    }

    protected void initialize(boolean videoAvailable, boolean audioAvailable) {
        if (!videoAvailable && !audioAvailable) {
            throw new IllegalArgumentException();
        }
        super.initialize();
        if (videoAvailable) {
            this._videoNature = true;
            this._videoEnabled = true;
        }
        if (audioAvailable) {
            this._audioNature = true;
            this._audioEnabled = true;
        }
    }

    @Override
    public boolean isVideoNature() {
        return this._videoNature;
    }

    public void setVideoNature(boolean videoNature) {
        this._videoNature = videoNature;
    }

    @Override
    public boolean isAudioNature() {
        return this._audioNature;
    }

    public void setAudioNature(boolean audioNature) {
        this._audioNature = audioNature;
    }

    @Override
    public boolean isVideoEnabled() {
        return this._videoEnabled;
    }

    @Override
    public void setVideoEnabled(boolean enabled) {
        this._videoEnabled = enabled;
    }

    @Override
    public boolean isAudioEnabled() {
        return this._audioEnabled;
    }

    @Override
    public void setAudioEnabled(boolean enabled) {
        this._audioEnabled = enabled;
    }

    @Override
    public boolean isEffectsEnabled() {
        return this._effectsEnabled;
    }

    @Override
    public void setEffectsEnabled(boolean effectsEnabled) {
        this._effectsEnabled = effectsEnabled;
    }

    @Override
    public List<Effect> getEffects() {
        return this._effects;
    }

    public void setEffects(List<Effect> effects) {
        this._effects = effects;
    }

    @Override
    public boolean isMotionBlurEnabled() {
        return this._motionBlurEnabled;
    }

    @Override
    public void setMotionBlurEnabled(boolean motionBlurEnabled) {
        this._motionBlurEnabled = motionBlurEnabled;
    }

    @Override
    public TrackMatte getTrackMatte() {
        return this._trackMatte;
    }

    @Override
    public void setTrackMatte(TrackMatte trackMatte) {
        this._trackMatte = trackMatte;
    }

    @Override
    public AnimatableVec2d getDepthBase() {
        return this._depthBase;
    }

    public void setDepthBase(AnimatableVec2d depthBase) {
        depthBase.copyConfigurationFrom(this._depthBase);
        this._depthBase = depthBase;
    }

    @Override
    public AnimatableString getIntersectionGroup() {
        return this._intersectionGroup;
    }

    public void setIntersectionGroup(AnimatableString intersectionGroup) {
        intersectionGroup.copyConfigurationFrom(this._intersectionGroup);
        this._intersectionGroup = intersectionGroup;
    }

    @Override
    public AnimatableDouble getOpacity() {
        return this._opacity;
    }

    public void setOpacity(AnimatableDouble opacity) {
        opacity.copyConfigurationFrom(this._opacity);
        this._opacity = opacity;
    }

    @Override
    public BlendMode getBlendMode() {
        return this._blendMode;
    }

    @Override
    public void setBlendMode(BlendMode blendMode) {
        this._blendMode = blendMode;
    }

    @Override
    public AnimatableVec2d getAudioLevels() {
        return this._audioLevels;
    }

    public void setAudioLevels(AnimatableVec2d audioLevels) {
        audioLevels.copyConfigurationFrom(this._audioLevels);
        this._audioLevels = audioLevels;
    }

    @Override
    public AnimatableDouble getTimeRemap() {
        return this._timeRemap;
    }

    public void setTimeRemap(AnimatableDouble timeRemap) {
        timeRemap.copyConfigurationFrom(this._timeRemap);
        this._timeRemap = timeRemap;
    }

    @Override
    public boolean isVectorLayer() {
        return this.getMediaInput() instanceof VectorMediaInput;
    }

    @Override
    public void prepareExpression(ExpressionScope scope) {
        super.prepareExpression(scope);
        scope.assignTo(this._depthBase);
        scope.assignTo(this._intersectionGroup);
        scope.assignTo(this._opacity);
        scope.assignTo(this._audioLevels);
        scope.assignTo(this._timeRemap);
        for (Effect effect : this._effects) {
            effect.prepareExpression(scope.clone());
        }
    }

    @Override
    public void setupVideoRenderer(VideoLayerComposer composer, Camera camera, CollapseTransformation ct, MotionBlur motinBlur, boolean frameBlendEnabled) {
        MediaInput input = this.getMediaInput();
        if (input == null || !input.isVideoAvailable()) {
            return;
        }
        if (this.isVectorLayer() && LayerNature.isCTCR(this)) {
            this.setupVideoRendererCR(composer, camera, ct, motinBlur);
        } else {
            this.setupVideoRendererNormal(composer, camera, ct, motinBlur, frameBlendEnabled);
        }
    }

    protected Time calcVideoMediaTime(MediaInput input) {
        Time time;
        if (LayerNature.isTimeRemapEnabled(this)) {
            double t0 = (Double)this._timeRemap.value(this._vrContext);
            Time ctxTime = this._vrContext.getTime();
            double t1 = (Double)this._timeRemap.valueAtTime(new Time(ctxTime.timeValue + 1L, ctxTime.timeScale), (RenderContext)this._vrContext);
            Time mediaFrameDuration = input.getVideoFrameDuration();
            int mediaTimeScale = mediaFrameDuration.timeScale;
            time = new Time(Math.round(t0 * (double)mediaTimeScale), mediaTimeScale);
            if (t0 > t1) {
                time = time.subtract(mediaFrameDuration);
            }
        } else {
            time = this._vrContext.getTime().subtract(this.getStartTime());
            double rate = this.getRate();
            Time mediaFrameDuration = input.getVideoFrameDuration();
            if (mediaFrameDuration != null) {
                int mediaTimeScale = mediaFrameDuration.timeScale;
                time = new Time(Math.round(time.toSecond() * rate * (double)mediaTimeScale), mediaTimeScale);
            } else {
                time = new Time(Math.round((double)time.timeValue * rate), time.timeScale);
            }
            if (rate < 0.0) {
                Time mediaDuration = input.getDuration();
                if (mediaDuration != null) {
                    time = time.add(mediaDuration);
                    time = time.subtract(mediaFrameDuration);
                } else {
                    mediaDuration = this.getOutPoint().subtract(this.getStartTime());
                    time = time.add(mediaDuration);
                }
            }
        }
        return time;
    }

    private void setupVideoRendererNormal(VideoLayerComposer composer, final Camera camera, final CollapseTransformation ct, final MotionBlur motionBlur, final boolean frameBlendEnabled) {
        final MediaInput input = this.getMediaInput();
        final RenderResolution resolution = this._vrContext.getRenderResolution();
        WrappedOperation<VideoBounds> inputBoundsOperation = new WrappedOperation<VideoBounds>(){

            @Override
            public VideoBounds execute() {
                return resolution.scale(input.getVideoFrameBounds());
            }
        };
        VideoBounds bounds = this._vePipeline.getVideoBounds(this._effectsEnabled ? this._effects : Collections.emptyList(), inputBoundsOperation);
        final Vec2d offset = new Vec2d(-bounds.x / resolution.scale, -bounds.y / resolution.scale);
        final double[] mvMatrix = new double[16];
        final double[] prjMatrix = new double[16];
        this.createMatrix(camera, ct, offset, mvMatrix, prjMatrix);
        final Time time = this._vrContext.getTime();
        VideoLayerRenderer r = new VideoLayerRenderer(){

            public VideoLayerBuffer render(boolean withDepthBuffer) {
                AbstractMediaLayer.this._vrContext.setTime(time);
                double opacity = ct == null ? (Double)AbstractMediaLayer.this._opacity.value(AbstractMediaLayer.this._vrContext) / 100.0 : (Double)AbstractMediaLayer.this._opacity.value(AbstractMediaLayer.this._vrContext) / 100.0 * ct.getOpacity();
                VideoBuffer effectedBuffer = null;
                VideoBuffer trnsfrmdBuffer = null;
                DepthBuffer depthBuffer = null;
                try {
                    WrappedOperation<VideoBuffer> inputBufferOperation = new WrappedOperation<VideoBuffer>(){

                        @Override
                        public VideoBuffer execute() {
                            FrameBlend frameBlend;
                            if (frameBlendEnabled && (frameBlend = LayerNature.getFrameBlend(AbstractMediaLayer.this)) != FrameBlend.NONE) {
                                return AbstractMediaLayer.this.blendFrames(frameBlend);
                            }
                            return input.getVideoFrameImage(AbstractMediaLayer.this.calcVideoMediaTime(input));
                        }
                    };
                    effectedBuffer = AbstractMediaLayer.this._vePipeline.doVideoEffects(AbstractMediaLayer.this._effectsEnabled ? AbstractMediaLayer.this._effects : Collections.emptyList(), inputBufferOperation);
                    if (motionBlur != null && LayerNature.isMotionBlurEnabled(AbstractMediaLayer.this)) {
                        if (withDepthBuffer) {
                            depthBuffer = AbstractMediaLayer.this._vrSupport.createDepthBuffer(camera.getViewportSize());
                            AbstractMediaLayer.this._vrSupport.fillDepth(depthBuffer, mvMatrix, prjMatrix);
                        }
                        final VideoBuffer mblurSrcBuf = effectedBuffer;
                        MotionBlurSampler sampler = new MotionBlurSampler(){

                            public void sample(double[] mvMatrix, double[] prjMatrix, VideoBuffer buffer) {
                                AbstractMediaLayer.this._vrSupport.transform(mblurSrcBuf, buffer, null, mvMatrix, prjMatrix);
                            }
                        };
                        trnsfrmdBuffer = AbstractMediaLayer.this.renderWithMotionBlur(camera, ct, motionBlur, offset, time, sampler);
                    } else {
                        trnsfrmdBuffer = AbstractMediaLayer.this._vrSupport.createVideoBuffer(AbstractMediaLayer.this._vrContext.getColorMode(), camera.getViewportSize());
                        trnsfrmdBuffer.allocateAsTexture();
                        trnsfrmdBuffer.clear();
                        if (withDepthBuffer) {
                            depthBuffer = AbstractMediaLayer.this._vrSupport.createDepthBuffer(camera.getViewportSize());
                            AbstractMediaLayer.this._vrSupport.transform(effectedBuffer, trnsfrmdBuffer, depthBuffer, mvMatrix, prjMatrix);
                        } else {
                            AbstractMediaLayer.this._vrSupport.transform(effectedBuffer, trnsfrmdBuffer, null, mvMatrix, prjMatrix);
                        }
                    }
                    VideoLayerBufferImpl vlb = new VideoLayerBufferImpl(trnsfrmdBuffer, depthBuffer, AbstractMediaLayer.this._blendMode, opacity);
                    trnsfrmdBuffer = null;
                    depthBuffer = null;
                    VideoLayerBufferImpl videoLayerBufferImpl = vlb;
                    return videoLayerBufferImpl;
                }
                finally {
                    if (depthBuffer != null) {
                        depthBuffer.dispose();
                    }
                    if (trnsfrmdBuffer != null) {
                        trnsfrmdBuffer.dispose();
                    }
                    if (effectedBuffer != null) {
                        effectedBuffer.dispose();
                    }
                }
            }
        };
        if (LayerNature.isThreeD(this)) {
            Vec2d depthBase2d = (Vec2d)this._depthBase.value(this._vrContext);
            Vec3d depthBase = new Vec3d(depthBase2d.x + offset.x, depthBase2d.y + offset.y);
            depthBase = resolution.scale(depthBase);
            Size2i vp = camera.getViewportSize();
            Vec3d[] vertices = new Vec3d[]{this._vrSupport.project(depthBase, mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x, bounds.y), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x + (double)bounds.width, bounds.y), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x + (double)bounds.width, bounds.y + (double)bounds.height), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x, bounds.y + (double)bounds.height), mvMatrix, prjMatrix, vp)};
            composer.add3D(r, vertices, (String)this._intersectionGroup.value(this._vrContext));
        } else {
            composer.add2D(r);
        }
    }

    private void setupVideoRendererCR(VideoLayerComposer composer, final Camera camera, final CollapseTransformation ct, final MotionBlur motionBlur) {
        final VectorMediaInput input = (VectorMediaInput)this.getMediaInput();
        RenderResolution resolution = this._vrContext.getRenderResolution();
        VideoBounds bounds = resolution.scale(input.getVideoFrameBounds());
        final double[] mvMatrix = new double[16];
        final double[] prjMatrix = new double[16];
        this.createMatrix(camera, ct, null, mvMatrix, prjMatrix);
        final Time time = this._vrContext.getTime();
        VideoLayerRenderer r = new VideoLayerRenderer(){

            public VideoLayerBuffer render(boolean withDepthBuffer) {
                AbstractMediaLayer.this._vrContext.setTime(time);
                double opacity = ct == null ? (Double)AbstractMediaLayer.this._opacity.value(AbstractMediaLayer.this._vrContext) / 100.0 : (Double)AbstractMediaLayer.this._opacity.value(AbstractMediaLayer.this._vrContext) / 100.0 * ct.getOpacity();
                VideoBuffer effectedBuffer = null;
                VideoBuffer resultBuffer = null;
                DepthBuffer depthBuffer = null;
                try {
                    if (withDepthBuffer) {
                        depthBuffer = AbstractMediaLayer.this._vrSupport.createDepthBuffer(camera.getViewportSize());
                        AbstractMediaLayer.this._vrSupport.fillDepth(depthBuffer, mvMatrix, prjMatrix);
                    }
                    WrappedOperation<VideoBuffer> inputBufferOperation = new WrappedOperation<VideoBuffer>(){

                        @Override
                        public VideoBuffer execute() {
                            VideoBuffer rasterizedBuffer = null;
                            try {
                                if (motionBlur != null && LayerNature.isMotionBlurEnabled(AbstractMediaLayer.this)) {
                                    MotionBlurSampler sampler = new MotionBlurSampler(){

                                        public void sample(double[] mvMatrix, double[] prjMatrix, VideoBuffer buffer) {
                                            input.rasterize(buffer, mvMatrix, prjMatrix, AbstractMediaLayer.this.calcVideoMediaTime(input));
                                        }
                                    };
                                    rasterizedBuffer = AbstractMediaLayer.this.renderWithMotionBlur(camera, ct, motionBlur, null, AbstractMediaLayer.this._vrContext.getTime(), sampler);
                                } else {
                                    rasterizedBuffer = AbstractMediaLayer.this._vrSupport.createVideoBuffer(AbstractMediaLayer.this._vrContext.getColorMode(), camera.getViewportSize());
                                    rasterizedBuffer.allocateAsTexture();
                                    rasterizedBuffer.clear();
                                    input.rasterize(rasterizedBuffer, mvMatrix, prjMatrix, AbstractMediaLayer.this.calcVideoMediaTime(input));
                                }
                                VideoBuffer result = rasterizedBuffer;
                                rasterizedBuffer = null;
                                VideoBuffer videoBuffer = result;
                                return videoBuffer;
                            }
                            finally {
                                if (rasterizedBuffer != null) {
                                    rasterizedBuffer.dispose();
                                }
                            }
                        }
                    };
                    effectedBuffer = AbstractMediaLayer.this._vePipeline.doVideoEffects(AbstractMediaLayer.this._effectsEnabled ? AbstractMediaLayer.this._effects : Collections.emptyList(), inputBufferOperation);
                    VideoBounds resultBounds = new VideoBounds(camera.getViewportSize());
                    if (effectedBuffer.getBounds().equals((Object)resultBounds)) {
                        resultBuffer = effectedBuffer;
                        effectedBuffer = null;
                    } else {
                        resultBuffer = AbstractMediaLayer.this._vrSupport.createVideoBuffer(AbstractMediaLayer.this._vrContext.getColorMode(), resultBounds);
                        resultBuffer.allocateAsTexture();
                        resultBuffer.clear();
                        AbstractMediaLayer.this._vrSupport.copy(effectedBuffer, resultBuffer);
                    }
                    VideoLayerBufferImpl vlb = new VideoLayerBufferImpl(resultBuffer, depthBuffer, AbstractMediaLayer.this._blendMode, opacity);
                    resultBuffer = null;
                    depthBuffer = null;
                    VideoLayerBufferImpl videoLayerBufferImpl = vlb;
                    return videoLayerBufferImpl;
                }
                finally {
                    if (depthBuffer != null) {
                        depthBuffer.dispose();
                    }
                    if (resultBuffer != null) {
                        resultBuffer.dispose();
                    }
                    if (effectedBuffer != null) {
                        effectedBuffer.dispose();
                    }
                }
            }
        };
        if (LayerNature.isThreeD(this)) {
            Vec2d depthBase2d = (Vec2d)this._depthBase.value(this._vrContext);
            Vec3d depthBase = new Vec3d(depthBase2d.x, depthBase2d.y);
            depthBase = resolution.scale(depthBase);
            Size2i vp = camera.getViewportSize();
            Vec3d[] vertices = new Vec3d[]{this._vrSupport.project(depthBase, mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x, bounds.y), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x + (double)bounds.width, bounds.y), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x + (double)bounds.width, bounds.y + (double)bounds.height), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x, bounds.y + (double)bounds.height), mvMatrix, prjMatrix, vp)};
            composer.add3D(r, vertices, (String)this._intersectionGroup.value(this._vrContext));
        } else {
            composer.add2D(r);
        }
    }

    private void createMatrix(final Camera camera, final CollapseTransformation ct, final Vec2d offset, final double[] mvMatrix, final double[] prjMatrix) {
        WrappedOperation<Object> operation = new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                if (camera == null) {
                    AbstractMediaLayer.this._vrSupport.resetMatrix();
                } else if (LayerNature.isThreeD(AbstractMediaLayer.this)) {
                    AbstractMediaLayer.this._vrSupport.setMatrix(camera.getModelView3D(), camera.getProjection3D());
                } else {
                    AbstractMediaLayer.this._vrSupport.setMatrix(camera.getModelView2D(), camera.getProjection2D());
                }
                LayerMatrixUtil.multModelViewMatrix(AbstractMediaLayer.this, offset, ct, AbstractMediaLayer.this._vrContext, AbstractMediaLayer.this._vrSupport);
                AbstractMediaLayer.this._vrSupport.getMatrix(mvMatrix, prjMatrix);
                return null;
            }
        };
        this._vrSupport.pushMatrixAndExecute(operation);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VideoBuffer blendFrames(FrameBlend frameBlend) {
        if (frameBlend == FrameBlend.NONE) {
            throw new IllegalArgumentException();
        }
        if (frameBlend != FrameBlend.FRAME_MIX) {
            throw new UnsupportedOperationException();
        }
        input = this.getMediaInput();
        mediaFrameDuration = input.getVideoFrameDuration();
        ctxTime = this._vrContext.getTime();
        mediaTime0 = this.calcVideoMediaTime(input);
        this._vrContext.setTime(ctxTime.add(this._vrContext.getFrameDuration()));
        mediaTime1 = this.calcVideoMediaTime(input);
        this._vrContext.setTime(ctxTime);
        mediaTimeDiff = mediaTime1.subtract(mediaTime0);
        fpsRatio = mediaTimeDiff.toSecond() / mediaFrameDuration.toSecond();
        if (fpsRatio == 1.0) {
            return input.getVideoFrameImage(ctxTime);
        }
        fpsRatio = Math.abs(fpsRatio);
        buffers = Util.newList();
        buf32f = null;
        try {
            block21: {
                block20: {
                    resolution = this._vrContext.getRenderResolution();
                    bounds = resolution.scale(input.getVideoFrameBounds());
                    buf32f = this._vrSupport.createVideoBuffer(ColorMode.RGBA32_FLOAT, bounds);
                    buf32f.allocateAsTexture();
                    buf32f.clear();
                    weights = Util.newList();
                    maxUnits = this._glGlobal.getMaxTextureImageUnits();
                    if (!(fpsRatio > 1.0)) break block20;
                    intWeights = Util.newList();
                    w = (int)Math.round(255.0 / fpsRatio);
                    intWeights.add(w);
                    rest = 255 - w;
                    i = 1;
                    if (true) ** GOTO lbl70
                }
                frame = mediaTime0.toFrameNumber(mediaFrameDuration);
                if (mediaTime0.timeValue >= 0L) {
                    t0 = Time.fromFrameNumber((long)frame, (Time)mediaFrameDuration);
                    t1 = Time.fromFrameNumber((long)(frame + 1L), (Time)mediaFrameDuration);
                } else {
                    t0 = Time.fromFrameNumber((long)(frame - 1L), (Time)mediaFrameDuration);
                    t1 = Time.fromFrameNumber((long)frame, (Time)mediaFrameDuration);
                }
                tv0 = mediaTime0.subtract((Time)t0).timeValue;
                tv1 = t1.subtract((Time)mediaTime0).timeValue;
                buffers.add(input.getVideoFrameImage(t0));
                weights.add((double)tv1 / (double)(tv0 + tv1));
                if (maxUnits == 1) {
                    this._vrSupport.accumulate(buffers, weights, buf32f);
                    buffers.get(0).dispose();
                    buffers.clear();
                    weights.clear();
                }
                buffers.add(input.getVideoFrameImage(t1));
                weights.add((double)tv0 / (double)(tv0 + tv1));
                break block21;
                do {
                    if ((w = Math.min(rest, 2 * (int)Math.round(255.0 * (q = Math.exp(-(p = 2.35482 * (double)i / fpsRatio) * p / 2.0) / fpsRatio))) / 2) > 0) {
                        intWeights.add(w);
                        rest -= 2 * w;
                    } else if (rest > 0) {
                        intWeights.set(0, (Integer)intWeights.get(0) + rest);
                        rest = 0;
                    }
                    ++i;
lbl70:
                    // 2 sources

                } while (rest > 0);
                n = intWeights.size();
                i = -n + 1;
                while (i < n) {
                    t = mediaTime0.add(new Time(mediaFrameDuration.timeValue * (long)i, mediaFrameDuration.timeScale));
                    buffers.add(input.getVideoFrameImage(t));
                    weights.add((double)((Integer)intWeights.get(Math.abs(i))).intValue() / 255.0);
                    if (buffers.size() >= maxUnits) {
                        this._vrSupport.accumulate(buffers, weights, buf32f);
                        for (VideoBuffer vb : buffers) {
                            vb.dispose();
                        }
                        buffers.clear();
                        weights.clear();
                    }
                    ++i;
                }
            }
            if (!buffers.isEmpty()) {
                this._vrSupport.accumulate(buffers, weights, buf32f);
            }
            if (this._vrContext.getColorMode() == ColorMode.RGBA32_FLOAT) {
                resultBuffer = buf32f;
                buf32f = null;
            } else {
                resultBuffer = this._vrSupport.createVideoBuffer(this._vrContext.getColorMode(), buf32f.getBounds());
                resultBuffer.allocateAsTexture();
                this._vrSupport.copy(buf32f, resultBuffer);
            }
            var25_30 = resultBuffer;
            return var25_30;
        }
        finally {
            ** for (vb : buffers)
        }
lbl-1000:
        // 1 sources

        {
            vb.dispose();
            continue;
        }
lbl104:
        // 1 sources

        if (buf32f == null) return var25_30;
        buf32f.dispose();
        return var25_30;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VideoBuffer renderWithMotionBlur(Camera camera, CollapseTransformation ct, MotionBlur motionBlur, Vec2d offset, Time time, MotionBlurSampler sampler) {
        buffers = Util.newList();
        buf = null;
        buf32f = null;
        try {
            buf32f = this._vrSupport.createVideoBuffer(ColorMode.RGBA32_FLOAT, camera.getViewportSize());
            buf32f.allocateAsTexture();
            buf32f.clear();
            shutterAngle = motionBlur.getShutterAngle();
            shutterPhase = motionBlur.getShutterPhase();
            samples = motionBlur.getSamples();
            frameDuration = this._vrContext.getFrameDuration();
            maxUnits = this._glGlobal.getMaxTextureImageUnits();
            mvMatrix = new double[16];
            prjMatrix = new double[16];
            i = 0;
            while (i < samples) {
                angle = shutterPhase + shutterAngle * (double)i / (double)samples;
                t = time.add(new Time((long)((double)frameDuration.timeValue * angle / 360.0), frameDuration.timeScale));
                this._vrContext.setTime(t);
                this.createMatrix(camera, ct, offset, mvMatrix, prjMatrix);
                buf = this._vrSupport.createVideoBuffer(this._vrContext.getColorMode(), camera.getViewportSize());
                buf.allocateAsTexture();
                buf.clear();
                sampler.sample(mvMatrix, prjMatrix, buf);
                buffers.add(buf);
                buf = null;
                if (buffers.size() >= maxUnits) {
                    this._vrSupport.accumulate(buffers, 1.0 / (double)samples, buf32f);
                    for (VideoBuffer vb : buffers) {
                        vb.dispose();
                    }
                    buffers.clear();
                }
                ++i;
            }
            if (!buffers.isEmpty()) {
                this._vrSupport.accumulate(buffers, 1.0 / (double)samples, buf32f);
            }
            if (this._vrContext.getColorMode() == ColorMode.RGBA32_FLOAT) {
                resultBuffer = buf32f;
                buf32f = null;
            } else {
                resultBuffer = this._vrSupport.createVideoBuffer(this._vrContext.getColorMode(), buf32f.getBounds());
                resultBuffer.allocateAsTexture();
                this._vrSupport.copy(buf32f, resultBuffer);
            }
            var26_23 = resultBuffer;
            return var26_23;
        }
        finally {
            ** for (vb : buffers)
        }
lbl-1000:
        // 1 sources

        {
            vb.dispose();
            continue;
        }
lbl51:
        // 1 sources

        if (buf != null) {
            buf.dispose();
        }
        if (buf32f == null) return var26_23;
        buf32f.dispose();
        return var26_23;
    }

    private AudioBuffer getTimeRemappedAudioChunk(MediaInput input) {
        AudioBuffer ab1 = null;
        AudioBuffer ab2 = null;
        IObjectArray times = null;
        try {
            AudioMode audioMode = this._arContext.getAudioMode();
            int sampleRate = audioMode.sampleRate;
            ab1 = this._arSupport.createAudioBuffer();
            times = this._arrayPools.getObjectArray(ab1.getFrameCount());
            this._timeRemap.values(times, audioMode.sampleDuration, this._arContext.getEvaluationResolution(), this._arContext);
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            Object[] timeArray = (Object[])times.getArray();
            int i = 0;
            int n = times.getLength();
            while (i < n) {
                min = Math.min(min, (Double)timeArray[i]);
                max = Math.max(max, (Double)timeArray[i]);
                ++i;
            }
            long timeValueMin = (long)Math.floor(min * (double)sampleRate);
            long timeValueMax = (long)Math.ceil(max * (double)sampleRate);
            this._arContext.setFrameCount((int)(timeValueMax - timeValueMin) + 1);
            ab2 = input.getAudioChunk(new Time(timeValueMin, sampleRate));
            if (ab2 == null) {
                return null;
            }
            Object data1 = ab1.getData();
            Object data2 = ab2.getData();
            int n1 = ab1.getFrameCount();
            switch (audioMode.dataType) {
                case SHORT: {
                    Object[] array1 = (short[])data1;
                    short[] array2 = (short[])data2;
                    int i2 = 0;
                    while (i2 < n1) {
                        int j = (int)(Math.round((Double)timeArray[i2] * (double)sampleRate) - timeValueMin);
                        array1[i2 * 2] = array2[j * 2];
                        array1[i2 * 2 + 1] = array2[j * 2 + 1];
                        ++i2;
                    }
                    break;
                }
                case INT: {
                    Object[] array1 = (int[])data1;
                    int[] array2 = (int[])data2;
                    int i3 = 0;
                    while (i3 < n1) {
                        int j = (int)(Math.round((Double)timeArray[i3] * (double)sampleRate) - timeValueMin);
                        array1[i3 * 2] = array2[j * 2];
                        array1[i3 * 2 + 1] = array2[j * 2 + 1];
                        ++i3;
                    }
                    break;
                }
                case FLOAT: {
                    Object[] array1 = (float[])data1;
                    float[] array2 = (float[])data2;
                    int i4 = 0;
                    while (i4 < n1) {
                        int j = (int)(Math.round((Double)timeArray[i4] * (double)sampleRate) - timeValueMin);
                        array1[i4 * 2] = (short)array2[j * 2];
                        array1[i4 * 2 + 1] = (short)array2[j * 2 + 1];
                        ++i4;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audioMode.dataType);
                }
            }
            AudioBuffer result = ab1;
            ab1 = null;
            AudioBuffer audioBuffer = result;
            return audioBuffer;
        }
        finally {
            if (ab1 != null) {
                ab1.dispose();
            }
            if (ab2 != null) {
                ab2.dispose();
            }
            if (times != null) {
                times.release();
            }
        }
    }

    private AudioBuffer getRateChangedAudioChunk(MediaInput input, Time time, double rate) {
        AudioBuffer ab1 = null;
        AudioBuffer ab2 = null;
        try {
            long timeValueMax;
            Time t;
            long timeValueMin;
            AudioMode audioMode = this._arContext.getAudioMode();
            int sampleRate = audioMode.sampleRate;
            ab1 = this._arSupport.createAudioBuffer();
            double duration = input.getDuration().toSecond();
            if (rate >= 0.0) {
                timeValueMin = (long)Math.floor(time.toSecond() * (double)sampleRate * rate);
                t = time.add(new Time((long)this._arContext.getFrameCount(), sampleRate));
                timeValueMax = (long)Math.ceil(t.toSecond() * (double)sampleRate * rate);
            } else {
                timeValueMax = (long)Math.ceil(duration * (double)sampleRate + time.toSecond() * (double)sampleRate * rate);
                t = time.add(new Time((long)this._arContext.getFrameCount(), sampleRate));
                timeValueMin = (long)Math.floor(duration * (double)sampleRate + t.toSecond() * (double)sampleRate * rate);
            }
            this._arContext.setFrameCount((int)(timeValueMax - timeValueMin) + 1);
            ab2 = input.getAudioChunk(new Time(timeValueMin, sampleRate));
            if (ab2 == null) {
                return null;
            }
            Object data1 = ab1.getData();
            Object data2 = ab2.getData();
            int n1 = ab1.getFrameCount();
            switch (audioMode.dataType) {
                case SHORT: {
                    Object[] array1 = (short[])data1;
                    short[] array2 = (short[])data2;
                    int i = 0;
                    while (i < n1) {
                        int j = rate >= 0.0 ? (int)(Math.round((time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin) : (int)(Math.round(duration * (double)sampleRate + (time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin);
                        array1[i * 2] = array2[j * 2];
                        array1[i * 2 + 1] = array2[j * 2 + 1];
                        ++i;
                    }
                    break;
                }
                case INT: {
                    Object[] array1 = (int[])data1;
                    int[] array2 = (int[])data2;
                    int i = 0;
                    while (i < n1) {
                        int j = rate >= 0.0 ? (int)(Math.round((time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin) : (int)(Math.round(duration * (double)sampleRate + (time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin);
                        array1[i * 2] = array2[j * 2];
                        array1[i * 2 + 1] = array2[j * 2 + 1];
                        ++i;
                    }
                    break;
                }
                case FLOAT: {
                    Object[] array1 = (float[])data1;
                    float[] array2 = (float[])data2;
                    int i = 0;
                    while (i < n1) {
                        int j = rate >= 0.0 ? (int)(Math.round((time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin) : (int)(Math.round(duration * (double)sampleRate + (time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin);
                        array1[i * 2] = (short)array2[j * 2];
                        array1[i * 2 + 1] = (short)array2[j * 2 + 1];
                        ++i;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audioMode.dataType);
                }
            }
            AudioBuffer result = ab1;
            ab1 = null;
            AudioBuffer audioBuffer = result;
            return audioBuffer;
        }
        finally {
            if (ab1 != null) {
                ab1.dispose();
            }
            if (ab2 != null) {
                ab2.dispose();
            }
        }
    }

    @Override
    public AudioBuffer renderAudioChunk() {
        if (!LayerNature.isAudioEnabled(this)) {
            return null;
        }
        final MediaInput input = this.getMediaInput();
        if (input == null || !input.isAudioAvailable()) {
            return null;
        }
        WrappedOperation<AudioBuffer> inputOperation = new WrappedOperation<AudioBuffer>(){

            @Override
            public AudioBuffer execute() {
                if (LayerNature.isTimeRemapEnabled(AbstractMediaLayer.this)) {
                    return AbstractMediaLayer.this.getTimeRemappedAudioChunk(input);
                }
                Time time = AbstractMediaLayer.this._arContext.getTime().subtract(AbstractMediaLayer.this.getStartTime());
                double rate = AbstractMediaLayer.this.getRate();
                if (rate == 1.0) {
                    return input.getAudioChunk(time);
                }
                return AbstractMediaLayer.this.getRateChangedAudioChunk(input, time, rate);
            }
        };
        AudioBuffer ab = this._aePipeline.doAudioEffects(this._effectsEnabled ? this._effects : Collections.emptyList(), inputOperation);
        if (this._audioLevels.hasKeyframe() || this._audioLevels.getExpression() != null || !((Vec2d)this._audioLevels.getStaticValue()).equals((Object)Vec2d.ZERO)) {
            IObjectArray audioLevels = this._arrayPools.getObjectArray(ab.getFrameCount());
            this._audioLevels.values(audioLevels, ab.getAudioMode().sampleDuration, this._arContext.getEvaluationResolution(), this._arContext);
            this._arSupport.amplify(ab, (IObjectArray<Vec2d>)audioLevels);
            audioLevels.release();
        }
        Time time = this._arContext.getTime();
        Time sampleDuration = this._arContext.getAudioMode().sampleDuration;
        int clearFrameCount = (int)this.getInPoint().subtract(time).toFrameNumber(sampleDuration);
        if (clearFrameCount > 0) {
            this._arSupport.clear(ab, 0, clearFrameCount);
        }
        int clearFrameOffset = (int)this.getOutPoint().subtract(time).toFrameNumber(sampleDuration);
        clearFrameCount = this._arContext.getFrameCount() - clearFrameOffset;
        if (clearFrameCount > 0) {
            this._arSupport.clear(ab, clearFrameOffset, clearFrameCount);
        }
        return ab;
    }

    @Override
    public void afterDecode(Project p, LayerComposition c) throws ProjectDecodeException {
        super.afterDecode(p, c);
        for (Effect effect : this._effects) {
            effect.afterDecode(p);
        }
    }

    @Override
    public Object createExpressionElement(RenderContext renderContext) {
        return new MediaLayerExpressionElement(renderContext);
    }

    public class MediaLayerExpressionElement
    extends AbstractTransformableLayer.TransformableLayerExpressionElement {
        public MediaLayerExpressionElement(RenderContext renderContext) {
            super(renderContext);
        }

        public Object getDepthBase() {
            return this.elem(AbstractMediaLayer.this._depthBase);
        }

        public Object getIntersectionGroup() {
            return this.elem(AbstractMediaLayer.this._intersectionGroup);
        }

        public Object getOpacity() {
            return this.elem(AbstractMediaLayer.this._opacity);
        }

        public Object getAudioLevels() {
            return this.elem(AbstractMediaLayer.this._audioLevels);
        }

        public Object getTimeRemap() {
            return LayerNature.isTimeRemapEnabled(AbstractMediaLayer.this) ? this.elem(AbstractMediaLayer.this._timeRemap) : null;
        }

        public Object effect(int index) {
            Effect effect = (Effect)AbstractMediaLayer.this._effects.get(index - 1);
            return this.renderContext.getExpressionElement(effect);
        }
    }

    private static interface MotionBlurSampler {
        public void sample(double[] var1, double[] var2, VideoBuffer var3);
    }
}

