/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.core.AudioBuffer;
import com.google.inject.Inject;

public class AudioBufferImpl
implements AudioBuffer,
IAudioBuffer {
    private final AudioMode _audioMode;
    private final int _frameCount;
    private final int _dataLength;
    private final int _dataLengthInBytes;
    private IArray<?> _data;
    @Inject
    private IArrayPools _arrayPools;

    public AudioBufferImpl(AudioMode audioMode, int frameCount) {
        this._audioMode = audioMode;
        this._frameCount = frameCount;
        this._dataLength = frameCount * audioMode.channels;
        this._dataLengthInBytes = this._dataLength * audioMode.sampleSize;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this._data != null) {
            this._data.release();
            this._data = null;
        }
    }

    public AudioMode getAudioMode() {
        return this._audioMode;
    }

    public int getFrameCount() {
        return this._frameCount;
    }

    public int getDataLength() {
        return this._dataLength;
    }

    public int getDataLengthInBytes() {
        return this._dataLengthInBytes;
    }

    public Object getData() {
        if (this._data == null) {
            switch (this._audioMode.dataType) {
                case SHORT: {
                    this._data = this._arrayPools.getShortArray(this._dataLength);
                    break;
                }
                case INT: {
                    this._data = this._arrayPools.getIntArray(this._dataLength);
                    break;
                }
                case FLOAT: {
                    this._data = this._arrayPools.getFloatArray(this._dataLength);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + this._audioMode.dataType);
                }
            }
        }
        return this._data.getArray();
    }
}

