/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoBufferImpl
implements VideoBuffer,
IVideoBuffer {
    private static final Logger _logger = LoggerFactory.getLogger(VideoBufferImpl.class);
    @Inject
    private VideoRenderSupport _vrSupport;
    private final ColorMode _colorMode;
    private final Size2i _imageSize;
    private final VideoBounds _bounds;
    private int _texture;
    private IArray<?> _array;

    public VideoBufferImpl(ColorMode colorMode, Size2i imageSize) {
        this._colorMode = colorMode;
        this._imageSize = imageSize;
        this._bounds = new VideoBounds(imageSize.width, imageSize.height);
    }

    public VideoBufferImpl(ColorMode colorMode, VideoBounds bounds) {
        this._colorMode = colorMode;
        this._imageSize = new Size2i(bounds.width, bounds.height);
        this._bounds = bounds;
    }

    protected void finalize() throws Throwable {
        if (this._texture != 0 || this._array != null) {
            _logger.warn("finalizing a VideoBufferImpl object, but the object is not disposed.");
            if (this._array != null) {
                this._array.release();
                this._array = null;
            }
        }
        super.finalize();
    }

    public void dispose() {
        if (this._texture != 0) {
            this._vrSupport.deleteTexture(this._texture);
            this._texture = 0;
        }
        if (this._array != null) {
            this._array.release();
            this._array = null;
        }
    }

    public void allocateAsTexture() {
        this.allocate(true);
    }

    public void allocateAsArray() {
        this.allocate(false);
    }

    private void allocate(boolean asTexture) {
        if (this._texture != 0 || this._array != null) {
            throw new IllegalStateException("already allocated");
        }
        if (asTexture) {
            this.getTexture();
        } else {
            this.getArray();
        }
    }

    public boolean isAllocated() {
        return this.isTexture() || this.isArray();
    }

    public boolean isTexture() {
        return this._texture != 0;
    }

    public boolean isArray() {
        return this._array != null;
    }

    public void clear() {
        this._vrSupport.clear(this);
    }

    public int getTexture() {
        if (this._texture == 0) {
            this._texture = this._vrSupport.createTexture(this._colorMode, this._imageSize);
        } else if (this._array != null) {
            throw new IllegalStateException("both texture and array exist.");
        }
        if (this._array != null) {
            this._vrSupport.copyArrayToTexture(this._array.getArray(), this._texture, this._colorMode, this._imageSize);
            this._array.release();
            this._array = null;
        }
        return this._texture;
    }

    public Object getArray() {
        if (this._array == null) {
            this._array = this._vrSupport.createArray(this._colorMode, this._imageSize);
        } else if (this._texture != 0) {
            throw new IllegalStateException("both texture and array exist.");
        }
        if (this._texture != 0) {
            this._vrSupport.copyTextureToArray(this._texture, this._array.getArray(), this._colorMode, this._imageSize);
            this._vrSupport.deleteTexture(this._texture);
            this._texture = 0;
        }
        return this._array.getArray();
    }

    public ColorMode getColorMode() {
        return this._colorMode;
    }

    public Size2i getImageSize() {
        return this._imageSize;
    }

    public VideoBounds getBounds() {
        return this._bounds;
    }
}

