/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.shaders;

import ch.kuramo.javie.api.IShaderSourceFactory;
import ch.kuramo.javie.api.ShaderType;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.GLGlobal;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class BlendModeShaders {
    @ShaderSource(program=false)
    public static final String blend_functions = "blend_functions.frag";
    @ShaderSource(attach={"blend_functions"})
    public static final String[] NORMAL = BlendModeShaders.createProgramSource("normal");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] DISSOLVE = BlendModeShaders.createProgramSource("dissolve");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] DANCING_DISSOLVE = BlendModeShaders.createProgramSource("dancing_dissolve", true);
    @ShaderSource(attach={"blend_functions"})
    public static final String[] DARKEN = BlendModeShaders.createProgramSource("darken");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] MULTIPLY = BlendModeShaders.createProgramSource("multiply");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] COLOR_BURN = BlendModeShaders.createProgramSource("color_burn");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] LINEAR_BURN = BlendModeShaders.createProgramSource("linear_burn");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] DARKER_COLOR = BlendModeShaders.createProgramSource("darker_color");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] ADD = BlendModeShaders.createProgramSource("add");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] LIGHTEN = BlendModeShaders.createProgramSource("lighten");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] SCREEN = BlendModeShaders.createProgramSource("screen");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] COLOR_DODGE = BlendModeShaders.createProgramSource("color_dodge");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] LINEAR_DODGE = BlendModeShaders.createProgramSource("linear_dodge");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] LIGHTER_COLOR = BlendModeShaders.createProgramSource("lighter_color");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] OVERLAY = BlendModeShaders.createProgramSource("overlay");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] SOFT_LIGHT = BlendModeShaders.createProgramSource("soft_light");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] HARD_LIGHT = BlendModeShaders.createProgramSource("hard_light");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] LINEAR_LIGHT = BlendModeShaders.createProgramSource("linear_light");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] VIVID_LIGHT = BlendModeShaders.createProgramSource("vivid_light");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] PIN_LIGHT = BlendModeShaders.createProgramSource("pin_light");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] HARD_MIX = BlendModeShaders.createProgramSource("hard_mix");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] DIFFERENCE = BlendModeShaders.createProgramSource("difference");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] EXCLUSION = BlendModeShaders.createProgramSource("exclusion");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] HUE = BlendModeShaders.createProgramSource("hue");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] SATURATION = BlendModeShaders.createProgramSource("saturation");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] COLOR = BlendModeShaders.createProgramSource("color");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] LUMINOSITY = BlendModeShaders.createProgramSource("luminosity");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] STENCIL_ALPHA = BlendModeShaders.createProgramSource("stencil_alpha");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] STENCIL_LUMA = BlendModeShaders.createProgramSource("stencil_luma");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] SILHOUETTE_ALPHA = BlendModeShaders.createProgramSource("silhouette_alpha");
    @ShaderSource(attach={"blend_functions"})
    public static final String[] SILHOUETTE_LUMA = BlendModeShaders.createProgramSource("silhouette_luma");
    @ShaderSource(program=false)
    public final String[] intersecting_blend_main;
    private static int _maxIntersectingLayers;

    private static final String[] createProgramSource(String name, boolean temporal) {
        return new String[]{"uniform sampler2DRect texDst;", "uniform sampler2DRect texSrc;", "uniform float opacity;", temporal ? "uniform float time;" : "", "", String.format("vec4 blend_%s(vec4 pDst, vec4 pSrc, float opacity%s);", name, temporal ? ", float time" : ""), "", "void main(void)", "{", "\tvec2 texCoord = gl_TexCoord[0].st;", "\tvec4 dst = texture2DRect(texDst, texCoord);", "\tvec4 src = texture2DRect(texSrc, texCoord);", String.format("\tdst = blend_%s(vec4(dst.rgb*dst.a, dst.a), src, opacity%s);", name, temporal ? ", time" : ""), "\tgl_FragColor = (dst.a != 0.0) ? vec4(dst.rgb/dst.a, dst.a) : vec4(0.0);", "}"};
    }

    private static final String[] createProgramSource(String name) {
        return BlendModeShaders.createProgramSource(name, false);
    }

    public static int getMaxIntersectingLayers() {
        return _maxIntersectingLayers;
    }

    private String[] createIntersectingBlendMain() {
        List<String> source = Util.newList();
        source.add(String.format("const int maxLayers = %d;", _maxIntersectingLayers));
        source.add("uniform int nLayers;");
        source.add("uniform sampler2DRect texDst;");
        int i = 0;
        while (i < _maxIntersectingLayers) {
            source.add(String.format("uniform sampler2DRect texSrc%d;", i));
            source.add(String.format("uniform sampler2DRect texDep%d;", i));
            source.add(String.format("uniform int blendMode%d;", i));
            ++i;
        }
        source.add("uniform float opacity[maxLayers];");
        source.add("uniform float time;");
        source.add("vec2 texCoord = gl_TexCoord[0].st;");
        source.add("vec4 getSrc(int i) {");
        source.add("\treturn");
        i = 0;
        while (i < _maxIntersectingLayers) {
            source.add(String.format("\t\t(i == %1$d) ? texture2DRect(texSrc%1$d, texCoord) :", i));
            ++i;
        }
        source.add("\t\tvec4(0.0);");
        source.add("}");
        source.add("float getDep(int i) {");
        source.add("\treturn");
        i = 0;
        while (i < _maxIntersectingLayers) {
            source.add(String.format("\t\t(i == %1$d) ? texture2DRect(texDep%1$d, texCoord).r :", i));
            ++i;
        }
        source.add("\t\t-1.0;");
        source.add("}");
        source.add("int getBlendMode(int i) {");
        source.add("\treturn");
        i = 0;
        while (i < _maxIntersectingLayers) {
            source.add(String.format("\t\t(i == %1$d) ? blendMode%1$d :", i));
            ++i;
        }
        source.add("\t\t0;");
        source.add("}");
        i = 0;
        while (i < _maxIntersectingLayers) {
            source.add(String.format("int ord%1$d = %1$d;", i));
            ++i;
        }
        source.add("int getOrd(int i) {");
        source.add("\treturn");
        i = 0;
        while (i < _maxIntersectingLayers) {
            source.add(String.format("\t\t(i == %1$d) ? ord%1$d :", i));
            ++i;
        }
        source.add("\t\t-1;");
        source.add("}");
        source.add("void setOrd(int i, int ord) {");
        i = 0;
        while (i < _maxIntersectingLayers - 1) {
            source.add(String.format("\tif (i == %1$d) ord%1$d = ord; else ", i));
            ++i;
        }
        source.add(String.format("\tif (i == %1$d) ord%1$d = ord;", _maxIntersectingLayers - 1));
        source.add("}");
        source.addAll(Arrays.asList("vec4 blend(int mode, vec4 pDst, vec4 pSrc, float opacity, float time);", "", "void main(void)", "{", "\tvec4 dst = texture2DRect(texDst, texCoord);", "", "\tint nzaCount = 0;", "\tint nzaLayer;", "\tvec4 nzaColor;", "\tfor (int i = 0; i < nLayers; ++i) {", "\t\tvec4 s = getSrc(i);", "\t\tif (s.a > 0.0) {", "\t\t\tif (++nzaCount > 1) {", "\t\t\t\tbreak;", "\t\t\t}", "\t\t\tnzaLayer = i;", "\t\t\tnzaColor = s;", "\t\t}", "\t}", "\tif (nzaCount == 1) {", "\t\tdst = vec4(dst.rgb*dst.a, dst.a);", "\t\tdst = blend(getBlendMode(nzaLayer), dst, nzaColor, opacity[nzaLayer], time);", "\t\tdst = (dst.a != 0.0) ? vec4(dst.rgb/dst.a, dst.a) : vec4(0.0);", "", "\t} else if (nzaCount > 1) {", "\t\tdst = vec4(dst.rgb*dst.a, dst.a);", "\t\t", "\t\tfor (int i = nLayers - 2; i >= 0; --i) {", "\t\t\tint ord = getOrd(i);", "\t\t\tfloat dep = getDep(ord);", "\t\t\tint j, ord2;", "\t\t\tfor (j = i + 1; j < nLayers && getDep(ord2 = getOrd(j)) > dep; ++j) {", "\t\t\t\tsetOrd(j - 1, ord2);", "\t\t\t}", "\t\t\tsetOrd(j - 1, ord);", "\t\t}", "\t\t", "\t\tfor (int i = 0; i < nLayers; ++i) {", "\t\t\tint ord = getOrd(i);", "\t\t\tdst = blend(getBlendMode(ord), dst, getSrc(ord), opacity[ord], time);", "\t\t}", "\t\tdst = (dst.a != 0.0) ? vec4(dst.rgb/dst.a, dst.a) : vec4(0.0);", "\t}", "", "\tgl_FragColor = dst;", "}"));
        return source.toArray(new String[source.size()]);
    }

    @Inject
    public BlendModeShaders(GLGlobal glGlobal) {
        _maxIntersectingLayers = (Math.min(32, glGlobal.getMaxTextureImageUnits()) - 1) / 2;
        this.intersecting_blend_main = this.createIntersectingBlendMain();
    }

    public static IShaderSourceFactory getIntersectingBlendSourceFactory(int[] blendModes) {
        final Set<Integer> set = Util.newSet();
        int i = 0;
        while (i < blendModes.length) {
            set.add(blendModes[i]);
            ++i;
        }
        Object[] array = set.toArray(new Integer[set.size()]);
        Arrays.sort(array);
        StringBuilder sb = new StringBuilder(String.valueOf(BlendModeShaders.class.getName()) + ".INTERSECTING_BLEND");
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object i2 = objectArray[n2];
            sb.append(":").append(i2);
            ++n2;
        }
        final String name = sb.toString();
        final String[] attach = new String[]{String.valueOf(BlendModeShaders.class.getName()) + ".blend_functions", String.valueOf(BlendModeShaders.class.getName()) + ".intersecting_blend_main"};
        return new IShaderSourceFactory(){

            public String getName() {
                return name;
            }

            public ShaderType getType() {
                return ShaderType.FRAGMENT_SHADER;
            }

            public boolean isProgram() {
                return true;
            }

            public String[] getAttach() {
                return attach;
            }

            public String[] getSource() {
                return new String[]{"vec4 blend_normal(vec4 pDst, vec4 pSrc, float opacity);", set.contains(1) ? "vec4 blend_dissolve(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(2) ? "vec4 blend_dancing_dissolve(vec4 pDst, vec4 pSrc, float opacity, float time);" : "", set.contains(3) ? "vec4 blend_darken(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(4) ? "vec4 blend_multiply(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(5) ? "vec4 blend_color_burn(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(6) ? "vec4 blend_linear_burn(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(7) ? "vec4 blend_darker_color(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(8) ? "vec4 blend_add(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(9) ? "vec4 blend_lighten(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(10) ? "vec4 blend_screen(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(11) ? "vec4 blend_color_dodge(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(12) ? "vec4 blend_linear_dodge(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(13) ? "vec4 blend_lighter_color(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(14) ? "vec4 blend_overlay(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(15) ? "vec4 blend_soft_light(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(16) ? "vec4 blend_hard_light(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(17) ? "vec4 blend_linear_light(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(18) ? "vec4 blend_vivid_light(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(19) ? "vec4 blend_pin_light(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(20) ? "vec4 blend_hard_mix(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(21) ? "vec4 blend_difference(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(22) ? "vec4 blend_exclusion(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(23) ? "vec4 blend_hue(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(24) ? "vec4 blend_saturation(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(25) ? "vec4 blend_color(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(26) ? "vec4 blend_luminosity(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(29) ? "vec4 blend_silhouette_alpha(vec4 pDst, vec4 pSrc, float opacity);" : "", set.contains(30) ? "vec4 blend_silhouette_luma(vec4 pDst, vec4 pSrc, float opacity);" : "", "vec4 blend(int mode, vec4 pDst, vec4 pSrc, float opacity, float time)", "{", "\treturn", set.contains(0) ? "\t\t(mode == 0) ? blend_normal(pDst, pSrc, opacity) :" : "", set.contains(1) ? "\t\t(mode == 1) ? blend_dissolve(pDst, pSrc, opacity) :" : "", set.contains(2) ? "\t\t(mode == 2) ? blend_dancing_dissolve(pDst, pSrc, opacity, time) :" : "", set.contains(3) ? "\t\t(mode == 3) ? blend_darken(pDst, pSrc, opacity) :" : "", set.contains(4) ? "\t\t(mode == 4) ? blend_multiply(pDst, pSrc, opacity) :" : "", set.contains(5) ? "\t\t(mode == 5) ? blend_color_burn(pDst, pSrc, opacity) :" : "", set.contains(6) ? "\t\t(mode == 6) ? blend_linear_burn(pDst, pSrc, opacity) :" : "", set.contains(7) ? "\t\t(mode == 7) ? blend_darker_color(pDst, pSrc, opacity) :" : "", set.contains(8) ? "\t\t(mode == 8) ? blend_add(pDst, pSrc, opacity) :" : "", set.contains(9) ? "\t\t(mode == 9) ? blend_lighten(pDst, pSrc, opacity) :" : "", set.contains(10) ? "\t\t(mode == 10) ? blend_screen(pDst, pSrc, opacity) :" : "", set.contains(11) ? "\t\t(mode == 11) ? blend_color_dodge(pDst, pSrc, opacity) :" : "", set.contains(12) ? "\t\t(mode == 12) ? blend_linear_dodge(pDst, pSrc, opacity) :" : "", set.contains(13) ? "\t\t(mode == 13) ? blend_lighter_color(pDst, pSrc, opacity) :" : "", set.contains(14) ? "\t\t(mode == 14) ? blend_overlay(pDst, pSrc, opacity) :" : "", set.contains(15) ? "\t\t(mode == 15) ? blend_soft_light(pDst, pSrc, opacity) :" : "", set.contains(16) ? "\t\t(mode == 16) ? blend_hard_light(pDst, pSrc, opacity) :" : "", set.contains(17) ? "\t\t(mode == 17) ? blend_linear_light(pDst, pSrc, opacity) :" : "", set.contains(18) ? "\t\t(mode == 18) ? blend_vivid_light(pDst, pSrc, opacity) :" : "", set.contains(19) ? "\t\t(mode == 19) ? blend_pin_light(pDst, pSrc, opacity) :" : "", set.contains(20) ? "\t\t(mode == 20) ? blend_hard_mix(pDst, pSrc, opacity) :" : "", set.contains(21) ? "\t\t(mode == 21) ? blend_difference(pDst, pSrc, opacity) :" : "", set.contains(22) ? "\t\t(mode == 22) ? blend_exclusion(pDst, pSrc, opacity) :" : "", set.contains(23) ? "\t\t(mode == 23) ? blend_hue(pDst, pSrc, opacity) :" : "", set.contains(24) ? "\t\t(mode == 24) ? blend_saturation(pDst, pSrc, opacity) :" : "", set.contains(25) ? "\t\t(mode == 25) ? blend_color(pDst, pSrc, opacity) :" : "", set.contains(26) ? "\t\t(mode == 26) ? blend_luminosity(pDst, pSrc, opacity) :" : "", set.contains(29) ? "\t\t(mode == 29) ? blend_silhouette_alpha(pDst, pSrc, opacity) :" : "", set.contains(30) ? "\t\t(mode == 30) ? blend_silhouette_luma(pDst, pSrc, opacity) :" : "", "\t\t\t\t\t   blend_normal(pDst, pSrc, opacity);", "}"};
            }
        };
    }
}

