/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.app.ApplicationWorkbenchWindowAdvisor;
import ch.kuramo.javie.app.Initializer;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.Perspective;
import ch.kuramo.javie.app.SaveUtil;
import ch.kuramo.javie.app.player.GLCanvasFactory;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.GLGlobal;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.media.opengl.GLCapabilities;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.LinearUndoEnforcer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    public void initialize(final IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
        IOperationHistory history = configurer.getWorkbench().getOperationSupport().getOperationHistory();
        history.addOperationApprover((IOperationApprover)new LinearUndoEnforcer());
        String os = Platform.getOS();
        boolean win32 = os.equals("win32");
        boolean macosx = os.equals("macosx");
        final GLGlobal glGlobal = (GLGlobal)InjectorHolder.getInjector().getInstance(GLGlobal.class);
        if (glGlobal.getInitError() == null) {
            boolean intel = glGlobal.isIntel();
            if (win32 || macosx && intel) {
                int poolSize = win32 && intel ? 8 : 20;
                GLCapabilities canvasCap = glGlobal.getCanvasCapabilities();
                canvasCap.setDoubleBuffered(win32);
                glGlobal.enterPoolMode(poolSize);
                glGlobal.setCanvasCapabilities(canvasCap);
                GLCanvasFactory.getFactory().enterPoolMode(poolSize);
            }
        } else {
            configurer.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError(null, (String)"OpenGL\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (String)glGlobal.getInitError());
                    configurer.getWorkbench().close();
                }
            });
        }
        Initializer.initialize();
    }

    public boolean preShutdown() {
        LinkedHashSet windows = Util.newLinkedHashSet();
        IWorkbench workbench = this.getWorkbenchConfigurer().getWorkbench();
        IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
        if (activeWindow != null) {
            windows.add(activeWindow);
        }
        windows.addAll(Arrays.asList(workbench.getWorkbenchWindows()));
        for (IWorkbenchWindow window : windows) {
            ProjectManager pm = ProjectManager.forWorkbenchWindow(window);
            if (pm == null || !ApplicationWorkbenchWindowAdvisor.saveConfirmationRequired(window)) continue;
            switch (SaveUtil.saveIfDirty(pm)) {
                case NOT_DIRTY: 
                case SAVED: 
                case UNSAVED: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        for (IWorkbenchWindow window : windows) {
            Perspective.reset(window);
        }
        return true;
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return "ch.kuramo.javie.app.perspective";
    }
}

