/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.api.plugin.JaviePlugin;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.services.EffectRegistry;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import ch.kuramo.javie.core.services.ShaderRegistry;
import ch.kuramo.javie.core.services.ShaderRegistryException;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.scannotation.AnnotationDB;
import org.scannotation.ClasspathUrlFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Initializer {
    private static final Logger _logger = LoggerFactory.getLogger(Initializer.class);
    @Inject
    private EffectRegistry _effectRegistry;
    @Inject
    private ProjectElementFactory _elementFactory;
    @Inject
    private ShaderRegistry _shaderRegistry;

    public static void initialize() {
        Initializer initializer = (Initializer)InjectorHolder.getInjector().getInstance(Initializer.class);
        initializer.scanCoreClasses();
        initializer.scanExtensions();
    }

    Initializer() {
    }

    private void scanCoreClasses() {
        try {
            URL url = FileLocator.resolve((URL)ClasspathUrlFinder.findClassBase(Project.class));
            AnnotationDB db = new AnnotationDB();
            db.scanArchives(new URL[]{url});
            ClassLoader cl = Project.class.getClassLoader();
            this._effectRegistry.searchClasses(db, cl);
            this._elementFactory.searchClasses(db, cl);
            this._shaderRegistry.scanShaders(db, cl);
        }
        catch (IOException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        catch (ShaderRegistryException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    private void scanExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("ch.kuramo.javie.api.plugin");
        if (point == null) {
            return;
        }
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                block9: {
                    IConfigurationElement cfgElem = iConfigurationElementArray[n4];
                    if ("javie-plugin".equals(cfgElem.getName())) {
                        JaviePlugin plugin;
                        String id = ext.getUniqueIdentifier();
                        String name = ext.getLabel();
                        _logger.info(String.format("loading JaviePlugin: %s [%s]", name, id));
                        try {
                            plugin = (JaviePlugin)cfgElem.createExecutableExtension("class");
                        }
                        catch (CoreException e) {
                            _logger.warn("can't load JaviePlugin: " + id, (Throwable)e);
                            break block9;
                        }
                        catch (ClassCastException e) {
                            _logger.warn("can't load JaviePlugin: " + id, (Throwable)e);
                            break block9;
                        }
                        try {
                            Class<?> clazz = plugin.getClass();
                            URL url = FileLocator.resolve((URL)ClasspathUrlFinder.findClassBase(clazz));
                            AnnotationDB db = new AnnotationDB();
                            db.scanArchives(new URL[]{url});
                            ClassLoader cl = clazz.getClassLoader();
                            this._effectRegistry.searchClasses(db, cl);
                            this._elementFactory.searchClasses(db, cl);
                            this._shaderRegistry.scanShaders(db, cl);
                        }
                        catch (Exception e) {
                            _logger.warn("can't load JaviePlugin: " + id, (Throwable)e);
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }
}

