/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIUtil {
    public static <T extends IViewPart> T showView(IWorkbenchPage page, String viewId) {
        return UIUtil.showView(page, viewId, null, 1);
    }

    public static <T extends IViewPart> T showView(IWorkbenchPage page, String viewId, String secondaryId, int mode) {
        try {
            IViewPart viewPart = page.showView(viewId, secondaryId, mode);
            return (T)viewPart;
        }
        catch (PartInitException e) {
            UIUtil.errorDialog(page, "Error", (Throwable)e);
            return null;
        }
    }

    public static <T extends IViewPart> T findView(IWorkbenchPage page, String viewId) {
        IViewPart viewPart = page.findView(viewId);
        return (T)viewPart;
    }

    public static <T extends IViewPart> T findView(IWorkbenchPage page, String viewId, String secondaryId) {
        IViewReference viewRef = page.findViewReference(viewId, secondaryId);
        if (viewRef != null) {
            IViewPart viewPart = viewRef.getView(true);
            return (T)viewPart;
        }
        return null;
    }

    public static void hideView(IWorkbenchPage page, IViewPart view) {
        page.hideView(view);
    }

    public static void errorDialog(Shell shell, String title, Throwable t) {
        MessageDialog.openError((Shell)shell, (String)title, (String)t.getMessage());
    }

    public static void errorDialog(IWorkbenchWindow window, String title, Throwable t) {
        UIUtil.errorDialog(window.getShell(), title, t);
    }

    public static void errorDialog(IWorkbenchPage page, String title, Throwable t) {
        UIUtil.errorDialog(page.getWorkbenchWindow(), title, t);
    }

    private UIUtil() {
    }
}

