/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.misc.AtiIntelLock;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import ch.kuramo.javie.core.services.VideoRenderContext;
import com.google.inject.Inject;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.ImageIO;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;

public class SequenceOutputAction
extends Action {
    private static File defaultFolder;
    private final LayerCompositionView view;
    @Inject
    private ProjectEncoder encoder;
    @Inject
    private ProjectDecoder decoder;
    @Inject
    private VideoRenderContext vrContext;
    @Inject
    private GLGlobal glGlobal;
    @Inject
    private IArrayPools _arrayPools;

    public SequenceOutputAction(LayerCompositionView view) {
        super("\u30a4\u30e1\u30fc\u30b8\u30b7\u30fc\u30b1\u30f3\u30b9...");
        InjectorHolder.getInjector().injectMembers((Object)this);
        this.view = view;
        this.setId("ch.kuramo.javie.app.commands.sequenceOutput");
        this.setActionDefinitionId("ch.kuramo.javie.app.commands.sequenceOutput");
    }

    public void run() {
        CompositionItem compItem;
        File file;
        File file2;
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.getWindow());
        if (pm == null) {
            return;
        }
        if (defaultFolder == null && (file2 = pm.getFile()) != null) {
            defaultFolder = file2.getParentFile();
        }
        if ((file = this.showSaveDialog(defaultFolder, (compItem = this.view.getCompositionItem()).getName())) != null) {
            defaultFolder = file.getParentFile();
            this.doOutput(pm.getProject(), compItem.getId(), file);
        }
    }

    private IWorkbenchWindow getWindow() {
        return this.view.getSite().getWorkbenchWindow();
    }

    private File showSaveDialog(File folder, String name) {
        String[] filterNames = new String[]{"All Files (*)"};
        String[] filterExtensions = new String[]{"*"};
        String platform = SWT.getPlatform();
        if (platform.equals("win32") || platform.equals("wpf")) {
            filterNames = new String[]{"All Files (*.*)"};
            filterExtensions = new String[]{"*.*"};
        }
        FileDialog dialog = new FileDialog(this.getWindow().getShell(), 0x10002000);
        dialog.setFilterNames(filterNames);
        dialog.setFilterExtensions(filterExtensions);
        dialog.setFilterPath(folder != null ? folder.getAbsolutePath() : null);
        dialog.setFileName(name);
        dialog.setOverwrite(false);
        String path = dialog.open();
        return path != null ? new File(path) : null;
    }

    /*
     * Unable to fully structure code
     */
    private void doOutput(Project project, String compItemId, File file) {
        block11: {
            block10: {
                block12: {
                    copy = null;
                    try {
                        try {
                            copy = (Project)this.decoder.decodeElement((CharSequence)this.encoder.encodeElement((Object)project), Project.class);
                            copy.afterDecode();
                            dialog = new ProgressMonitorDialog(this.getWindow().getShell());
                            dialog.create();
                            dialog.getShell().setText("\u66f8\u304d\u51fa\u3057");
                            dialog.run(true, true, (IRunnableWithProgress)new SequenceOutput((CompositionItem)copy.getItem(compItemId), file));
                            break block10;
                        }
                        catch (ProjectDecodeException e) {
                            throw new JavieRuntimeException((Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            throw new JavieRuntimeException((Throwable)e);
                        }
                        catch (InterruptedException v0) {
                            if (copy == null) break block11;
                            ** for (i : copy.getItems())
                        }
                    }
                    catch (Throwable var6_14) {
                        if (copy == null) break block12;
                        ** for (i : copy.getItems())
                    }
lbl-1000:
                    // 1 sources

                    {
                        i.dispose();
                        continue;
lbl20:
                        // 1 sources

                        break block11;
                    }
lbl-1000:
                    // 1 sources

                    {
                        i.dispose();
                        continue;
                    }
                }
                throw var6_14;
            }
            if (copy != null) {
                for (Item i : copy.getItems()) {
                    i.dispose();
                }
            }
        }
    }

    private class SequenceOutput
    implements IRunnableWithProgress {
        private final CompositionItem compItem;
        private final File file;
        private final boolean png;

        private SequenceOutput(CompositionItem compItem, File file) {
            this.compItem = compItem;
            this.file = file;
            this.png = compItem.getComposition().getColorMode() == ColorMode.RGBA16 || file.getName().toLowerCase().endsWith(".png");
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            AtiIntelLock atiIntelLock = AtiIntelLock.get((GLGlobal)SequenceOutputAction.this.glGlobal);
            Composition comp = this.compItem.getComposition();
            Time frameDuration = comp.getFrameDuration();
            long numFrames = comp.getDuration().toFrameNumber(frameDuration);
            String filenameFormat = this.filenameFormat(this.file.getName(), numFrames);
            monitor.beginTask(String.format("\u66f8\u304d\u51fa\u3057: %s", this.compItem.getName()), (int)numFrames);
            SequenceOutputAction.this.vrContext.activate();
            try {
                comp.prepareExpression(SequenceOutputAction.this.vrContext.createInitialExpressionScope(comp));
                long i = 0L;
                while (i < numFrames) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    monitor.subTask(String.format("\u30d5\u30ec\u30fc\u30e0: %d/%d", i, numFrames));
                    Time time = Time.fromFrameNumber((long)i, (Time)frameDuration);
                    SequenceOutputAction.this.vrContext.reset();
                    SequenceOutputAction.this.vrContext.setRenderResolution(RenderResolution.FULL);
                    SequenceOutputAction.this.vrContext.setFrameDuration(frameDuration);
                    SequenceOutputAction.this.vrContext.setTime(time);
                    VideoBuffer vb = null;
                    try {
                        try {
                            atiIntelLock.lock();
                            try {
                                vb = comp.renderVideoFrame();
                                this.writeToFile(vb, String.format(filenameFormat, i));
                            }
                            finally {
                                atiIntelLock.unlock();
                            }
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        if (vb != null) {
                            vb.dispose();
                        }
                    }
                    monitor.worked(1);
                    ++i;
                }
            }
            finally {
                SequenceOutputAction.this.vrContext.deactivate();
            }
            monitor.done();
        }

        private String filenameFormat(String baseFilename, long numFrames) {
            int lastDot = baseFilename.lastIndexOf(46);
            if (lastDot != -1) {
                baseFilename = baseFilename.substring(0, lastDot);
            }
            return String.valueOf(baseFilename.replaceAll("%", "%%")) + " %0" + String.valueOf(numFrames - 1L).length() + "d." + (this.png ? "png" : "bmp");
        }

        private void writeToFile(VideoBuffer vb, String filename) throws IOException {
            File file = new File(this.file.getParentFile(), filename);
            Size2i size = vb.getImageSize();
            int width = size.width;
            int height = size.height;
            switch (vb.getColorMode()) {
                case RGBA8: {
                    byte[] array = (byte[])vb.getArray();
                    if (this.png) {
                        int[] nArray = new int[4];
                        nArray[0] = 2;
                        nArray[1] = 1;
                        nArray[3] = 3;
                        WritableRaster wr = Raster.createInterleavedRaster(new DataBufferByte(array, width * height * 4), width, height, width * 4, 4, nArray, null);
                        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
                        BufferedImage image = new BufferedImage(cm, wr, false, null);
                        ImageIO.write((RenderedImage)image, "png", file);
                        break;
                    }
                    IArray pa = SequenceOutputAction.this._arrayPools.getByteArray(width * height * 3);
                    byte[] array2 = (byte[])pa.getArray();
                    try {
                        int i = 0;
                        int n = width * height;
                        while (i < n) {
                            array2[i * 3] = array[i * 4];
                            array2[i * 3 + 1] = array[i * 4 + 1];
                            array2[i * 3 + 2] = array[i * 4 + 2];
                            ++i;
                        }
                        int[] nArray = new int[3];
                        nArray[0] = 2;
                        nArray[1] = 1;
                        WritableRaster wr = Raster.createInterleavedRaster(new DataBufferByte(array2, width * height * 3), width, height, width * 3, 3, nArray, null);
                        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
                        BufferedImage image = new BufferedImage(cm, wr, false, null);
                        ImageIO.write((RenderedImage)image, "bmp", file);
                        break;
                    }
                    finally {
                        pa.release();
                    }
                }
                case RGBA16: {
                    short[] array = (short[])vb.getArray();
                    int[] nArray = new int[4];
                    nArray[0] = 2;
                    nArray[1] = 1;
                    nArray[3] = 3;
                    WritableRaster wr = Raster.createInterleavedRaster(new DataBufferUShort(array, width * height * 4), width, height, width * 4, 4, nArray, null);
                    ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 1);
                    BufferedImage image = new BufferedImage(cm, wr, false, null);
                    ImageIO.write((RenderedImage)image, "png", file);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported ColorMode: " + vb.getColorMode());
                }
            }
        }
    }
}

