/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import java.util.SortedMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyLayerKeyframeOperation<V>
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;
    private final String _property;
    private final Keyframe<V> _oldKeyframe;
    private volatile Keyframe<V> _newKeyframe;

    public ModifyLayerKeyframeOperation(ProjectManager projectManager, Layer layer, String property, Time time, V value, String relation, String name) {
        super(projectManager, String.valueOf(name) + "\u306e\u5909\u66f4", relation);
        LayerComposition comp = projectManager.checkLayer(layer);
        AnimatableValue avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
        Keyframe oldKeyframe = avalue.getKeyframe(time);
        this.setLabel(avalue.hasKeyframe(), oldKeyframe != null, value != null);
        this._compId = comp.getId();
        this._layerId = layer.getId();
        this._property = property;
        this._oldKeyframe = oldKeyframe;
        this._newKeyframe = value != null ? new Keyframe(time, value, this.defaultInterpolation(avalue, oldKeyframe, time)) : null;
    }

    private void setLabel(boolean hasKeyframe, boolean oldKeyframe, boolean newKeyframe) {
        if (!oldKeyframe) {
            if (!newKeyframe) {
                throw new IllegalArgumentException();
            }
            if (hasKeyframe) {
                this.setLabel("\u30ad\u30fc\u30d5\u30ec\u30fc\u30e0\u306e\u8ffd\u52a0");
            } else {
                this.setLabel("\u30b9\u30c8\u30c3\u30d7\u30a6\u30a9\u30c3\u30c1\u306e\u4f7f\u7528");
            }
        } else if (!newKeyframe) {
            this.setLabel("\u30ad\u30fc\u30d5\u30ec\u30fc\u30e0\u306e\u6d88\u53bb");
        }
    }

    private Interpolation defaultInterpolation(AnimatableValue<V> avalue, Keyframe<V> oldKeyframe, Time time) {
        if (oldKeyframe != null) {
            return oldKeyframe.interpolation;
        }
        SortedMap head = avalue.headKeyframeMap(time);
        if (!head.isEmpty()) {
            return ((Keyframe)head.get(head.lastKey())).interpolation;
        }
        return avalue.getDefaultInterpolation();
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.replaceKeyframe(this._oldKeyframe, this._newKeyframe, project, pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.replaceKeyframe(this._newKeyframe, this._oldKeyframe, project, pm);
        return Status.OK_STATUS;
    }

    private void replaceKeyframe(Keyframe<V> target, Keyframe<V> replacement, Project project, ProjectManager pm) {
        Time time;
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Layer layer = comp.getLayer(this._layerId);
        AnimatableValue avalue = (AnimatableValue)PropertyUtil.getProperty(layer, this._property);
        if (replacement != null) {
            avalue.putKeyframe(replacement);
            time = replacement.time;
        } else {
            avalue.removeKeyframe(target.time);
            time = target.time;
        }
        if (pm != null) {
            pm.fireKeyframesChange(comp, new Object[][]{{layer, -1, this._property, time}});
        }
    }

    @Override
    protected boolean merge(ProjectOperation operation, IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) {
        if (pm == null) {
            this.replaceKeyframe(null, this._newKeyframe, project, pm);
            return true;
        }
        if (!(operation instanceof ModifyLayerKeyframeOperation)) {
            return false;
        }
        ModifyLayerKeyframeOperation newOp = (ModifyLayerKeyframeOperation)operation;
        if (!(newOp._compId.equals(this._compId) && newOp._layerId.equals(this._layerId) && newOp._property.equals(this._property))) {
            return false;
        }
        Keyframe<V> newKeyframe = newOp._newKeyframe;
        if (this._newKeyframe == null || newKeyframe == null) {
            return false;
        }
        if (!this._newKeyframe.time.equals((Object)newKeyframe.time) || !this._newKeyframe.interpolation.equals((Object)newKeyframe.interpolation)) {
            return false;
        }
        if (!this._newKeyframe.value.equals(newKeyframe.value)) {
            this._newKeyframe = newKeyframe;
            this.replaceKeyframe(null, this._newKeyframe, project, pm);
            this._noEffect = this._oldKeyframe != null && this._oldKeyframe.value.equals(this._newKeyframe.value);
        }
        return true;
    }
}

