/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.AnimatableVec3d;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.TransformableLayer;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreeDSwitchOperation
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;
    private final boolean _oldValue;
    private final List<String> _data;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public ThreeDSwitchOperation(ProjectManager projectManager, TransformableLayer layer) {
        super(projectManager, "3D\u30b9\u30a4\u30c3\u30c1\u306e\u5909\u66f4");
        InjectorHolder.getInjector().injectMembers((Object)this);
        LayerComposition comp = projectManager.checkLayer((Layer)layer);
        this._compId = comp.getId();
        this._layerId = layer.getId();
        this._oldValue = LayerNature.isThreeD((Layer)layer);
        this._data = this.save(layer);
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        TransformableLayer layer = this.getLayer(project);
        if (this._oldValue) {
            this.clear3D(layer);
        } else {
            this.to3D(layer);
        }
        LayerNature.setThreeD((Layer)layer, (!this._oldValue ? 1 : 0) != 0);
        if (pm != null) {
            pm.fireLayerPropertyChange((Layer)layer, "threeD");
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        TransformableLayer layer = this.getLayer(project);
        this.restore(layer);
        LayerNature.setThreeD((Layer)layer, (boolean)this._oldValue);
        if (pm != null) {
            pm.fireLayerPropertyChange((Layer)layer, "threeD");
        }
        return Status.OK_STATUS;
    }

    private TransformableLayer getLayer(Project project) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        return (TransformableLayer)comp.getLayer(this._layerId);
    }

    private List<String> save(TransformableLayer layer) {
        List data = Util.newList();
        data.add(this._encoder.encodeElement((Object)layer.getAnchorPoint()));
        data.add(this._encoder.encodeElement((Object)layer.getScale()));
        data.add(this._encoder.encodeElement((Object)layer.getOrientation()));
        data.add(this._encoder.encodeElement((Object)layer.getRotationX()));
        data.add(this._encoder.encodeElement((Object)layer.getRotationY()));
        data.add(this._encoder.encodeElement((Object)layer.getPosition()));
        if (layer instanceof MediaLayer) {
            MediaLayer ml = (MediaLayer)layer;
            data.add(this._encoder.encodeElement((Object)ml.getDepthBase()));
            data.add(this._encoder.encodeElement((Object)ml.getIntersectionGroup()));
        }
        return data;
    }

    private void to3D(TransformableLayer layer) {
        MediaLayer mediaLayer;
        VideoBounds bounds;
        this.clear3D(layer);
        AnimatableVec3d scale = layer.getScale();
        if (!scale.hasKeyframe()) {
            Vec3d value = (Vec3d)scale.getStaticValue();
            if (value.x == value.y) {
                this.setZ(scale, value.x);
            }
        }
        if (layer instanceof MediaLayer && (bounds = (mediaLayer = (MediaLayer)layer).getMediaInput().getVideoFrameBounds()) != null) {
            mediaLayer.getDepthBase().reset((Object)new Vec2d((double)bounds.width / 2.0 + bounds.x, (double)bounds.height / 2.0 + bounds.y));
        }
    }

    private void setZ(AnimatableVec3d avalue, double z) {
        List newKeyframes = Util.newList();
        for (Keyframe kf : avalue.getKeyframes()) {
            Vec3d v = (Vec3d)kf.value;
            newKeyframes.add(new Keyframe(kf.time, (Object)new Vec3d(v.x, v.y, z), kf.interpolation));
        }
        Vec3d sv = (Vec3d)avalue.getStaticValue();
        avalue.clearKeyframes((Object)new Vec3d(sv.x, sv.y, z));
        for (Keyframe kf : newKeyframes) {
            avalue.putKeyframe(kf);
        }
    }

    private void clear3D(TransformableLayer layer) {
        this.setZ(layer.getAnchorPoint(), 0.0);
        this.setZ(layer.getScale(), 100.0);
        this.clear((AnimatableValue)layer.getOrientation(), (Object)new Vec3d(0.0, 0.0, 0.0));
        this.clear((AnimatableValue)layer.getRotationX(), 0.0);
        this.clear((AnimatableValue)layer.getRotationY(), 0.0);
        this.setZ(layer.getPosition(), 0.0);
        if (layer instanceof MediaLayer) {
            MediaLayer ml = (MediaLayer)layer;
            this.clear((AnimatableValue)ml.getDepthBase(), (Object)new Vec2d(0.0, 0.0));
            this.clear((AnimatableValue)ml.getIntersectionGroup(), (Object)"");
        }
    }

    private <V> void clear(AnimatableValue<V> avalue, V staticValue) {
        avalue.reset(staticValue);
    }

    private void restore(TransformableLayer layer) throws ExecutionException {
        this.restore(this._data.get(0), layer.getAnchorPoint());
        this.restore(this._data.get(1), layer.getScale());
        this.restore(this._data.get(2), layer.getOrientation());
        this.restore(this._data.get(3), layer.getRotationX());
        this.restore(this._data.get(4), layer.getRotationY());
        this.restore(this._data.get(5), layer.getPosition());
        if (layer instanceof MediaLayer) {
            MediaLayer ml = (MediaLayer)layer;
            this.restore(this._data.get(6), ml.getDepthBase());
            this.restore(this._data.get(7), ml.getIntersectionGroup());
        }
    }

    private <V, A extends AnimatableValue<V>> void restore(String data, A dst) throws ExecutionException {
        try {
            AnimatableValue src = (AnimatableValue)this._decoder.decodeElement((CharSequence)data, dst.getClass());
            dst.reset(src.getStaticValue());
            dst.setExpression(src.getExpression());
            for (Keyframe kf : src.getKeyframes()) {
                dst.putKeyframe(kf);
            }
        }
        catch (ProjectDecodeException e) {
            throw new ExecutionException("error decoding AnimatableValue data", (Throwable)e);
        }
    }
}

