/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.directorywatcher;

import java.io.File;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class DirectoryWatcher {
    private static final String DEL_EXT = ".del";
    public static final String POLL = "eclipse.p2.directory.watcher.poll";
    public static final String DIR = "eclipse.p2.directory.watcher.dir";
    private static final long DEFAULT_POLL_FREQUENCY = 2000L;
    final File[] directories;
    long poll = 2000L;
    private Set listeners = new HashSet();
    private HashSet scannedFiles = new HashSet();
    private HashSet removals;
    private Set pendingDeletions;
    private WatcherThread watcher;

    public static void log(String string, Throwable e) {
        System.err.println(String.valueOf(string) + ": " + e);
    }

    public DirectoryWatcher(Dictionary properties, BundleContext context) {
        String dir = (String)properties.get(DIR);
        if (dir == null) {
            dir = "./load";
        }
        File targetDirectory = new File(dir);
        targetDirectory.mkdirs();
        this.directories = new File[]{targetDirectory};
    }

    public DirectoryWatcher(File directory) {
        if (directory == null) {
            throw new IllegalArgumentException(Messages.null_folder);
        }
        this.directories = new File[]{directory};
    }

    public DirectoryWatcher(File[] directories) {
        if (directories == null) {
            throw new IllegalArgumentException(Messages.null_folder);
        }
        this.directories = directories;
    }

    public synchronized void addListener(DirectoryChangeListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(DirectoryChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void start() {
        this.start(2000L);
    }

    public synchronized void poll() {
        this.startPoll();
        this.scanDirectories();
        this.stopPoll();
    }

    public synchronized void start(long pollFrequency) {
        if (this.watcher != null) {
            throw new IllegalStateException(Messages.thread_started);
        }
        this.watcher = new WatcherThread(pollFrequency);
        this.watcher.start();
    }

    public synchronized void stop() {
        if (this.watcher == null) {
            throw new IllegalStateException(Messages.thread_not_started);
        }
        this.watcher.done();
        this.watcher = null;
    }

    public File[] getDirectories() {
        return this.directories;
    }

    private void startPoll() {
        this.removals = this.scannedFiles;
        this.scannedFiles = new HashSet();
        this.pendingDeletions = new HashSet();
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((DirectoryChangeListener)i.next()).startPoll();
        }
    }

    private void scanDirectories() {
        int index = 0;
        while (index < this.directories.length) {
            File directory = this.directories[index];
            File[] list = directory.listFiles();
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    File file = list[i];
                    if (list[i].getPath().endsWith(DEL_EXT)) {
                        File target = new File(file.getPath().substring(0, file.getPath().length() - 4));
                        this.removals.add(target);
                        this.pendingDeletions.add(target);
                    } else {
                        this.scannedFiles.add(file);
                        this.removals.remove(file);
                        Iterator iterator = this.listeners.iterator();
                        while (iterator.hasNext()) {
                            DirectoryChangeListener listener = (DirectoryChangeListener)iterator.next();
                            if (!this.isInterested(listener, file)) continue;
                            this.processFile(file, listener);
                        }
                    }
                    ++i;
                }
            }
            ++index;
        }
    }

    private void stopPoll() {
        this.notifyRemovals();
        this.removals = this.scannedFiles;
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((DirectoryChangeListener)i.next()).stopPoll();
        }
        this.processPendingDeletions();
    }

    private boolean isInterested(DirectoryChangeListener listener, File file) {
        return listener.isInterested(file);
    }

    private void notifyRemovals() {
        HashSet removed = this.removals;
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            DirectoryChangeListener listener = (DirectoryChangeListener)i.next();
            Iterator j = removed.iterator();
            while (j.hasNext()) {
                File file = (File)j.next();
                if (!this.isInterested(listener, file)) continue;
                listener.removed(file);
            }
        }
    }

    private void processFile(File file, DirectoryChangeListener listener) {
        try {
            Long oldTimestamp = listener.getSeenFile(file);
            if (oldTimestamp == null) {
                listener.added(file);
            } else {
                long lastModified = file.lastModified();
                if (oldTimestamp != lastModified) {
                    listener.changed(file);
                }
            }
        }
        catch (Exception e) {
            DirectoryWatcher.log(NLS.bind((String)Messages.error_processing, (Object)listener), e);
        }
    }

    private void processPendingDeletions() {
        Iterator iterator = this.pendingDeletions.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.exists() || file.delete()) {
                iterator.remove();
            }
            new File(String.valueOf(file.getPath()) + DEL_EXT).delete();
        }
    }

    public class WatcherThread
    extends Thread {
        private final long pollFrequency;
        private boolean done = false;

        public WatcherThread(long pollFrequency) {
            super("Directory Watcher");
            this.pollFrequency = pollFrequency;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            do {
                try {
                    DirectoryWatcher.this.poll();
                    WatcherThread watcherThread = this;
                    synchronized (watcherThread) {
                        this.wait(this.pollFrequency);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable e) {
                    DirectoryWatcher.log(Messages.error_main_loop, e);
                    this.done = true;
                }
            } while (!this.done);
        }

        public synchronized void done() {
            this.done = true;
            this.notify();
        }
    }
}

