/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.audio.windows.waveout;

import java.io.IOException;
import java.io.InputStream;

class SoundBuffer {
    private byte[] data;
    private boolean needsByteSwap;
    private int numBytes;
    private int bytesPerSample;
    private int numSamples;
    private boolean playing;
    private boolean empty;

    SoundBuffer(int n, int n2, boolean bl) {
        this.bytesPerSample = n2;
        this.needsByteSwap = bl;
        this.data = new byte[n * n2];
        this.empty = true;
    }

    boolean playing() {
        return this.playing;
    }

    void playing(boolean bl) {
        this.playing = bl;
    }

    boolean empty() {
        return this.empty;
    }

    void empty(boolean bl) {
        this.empty = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fill(InputStream inputStream) throws IOException {
        SoundBuffer soundBuffer = this;
        synchronized (soundBuffer) {
            if (this.playing) {
                throw new IllegalStateException("Can not fill a buffer that is playing");
            }
        }
        this.empty(true);
        int n = inputStream.read(this.data);
        if (n > 0) {
            this.numBytes = n;
            this.numSamples = this.numBytes / this.bytesPerSample;
            this.empty(false);
            if (this.numBytes % this.bytesPerSample != 0) {
                System.out.println("WARNING: needed integral multiple of " + this.bytesPerSample + " bytes, but read " + this.numBytes + " bytes");
            }
        } else {
            this.numBytes = 0;
        }
    }

    int numSamples() {
        return this.numSamples;
    }

    float getSample(int n) {
        int n2 = n * this.bytesPerSample;
        int n3 = 0;
        if (this.needsByteSwap) {
            for (int i = n2 + this.bytesPerSample - 1; i >= n2; --i) {
                n3 <<= 8;
                n3 |= this.data[i] & 0xFF;
            }
        } else {
            int n4 = n2 + this.bytesPerSample - 1;
            for (int i = n2; i <= n4; ++i) {
                n3 <<= 8;
                n3 |= this.data[i] & 0xFF;
            }
        }
        if (this.bytesPerSample == 2) {
            n3 = (short)n3;
        } else if (this.bytesPerSample == 1) {
            n3 = (byte)n3;
        }
        return n3;
    }
}

