/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util;

import com.sun.opengl.util.AnimatorImpl;
import java.util.ArrayList;
import java.util.Iterator;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLException;

public class Animator {
    private volatile ArrayList drawables = new ArrayList();
    private AnimatorImpl impl;
    private Runnable runnable;
    private boolean runAsFastAsPossible;
    protected Thread thread;
    protected volatile boolean shouldStop;
    protected boolean ignoreExceptions;
    protected boolean printExceptions;

    public Animator() {
        try {
            this.impl = (AnimatorImpl)Class.forName("com.sun.opengl.util.awt.AWTAnimatorImpl").newInstance();
        }
        catch (Exception exception) {
            this.impl = new AnimatorImpl();
        }
    }

    public Animator(GLAutoDrawable gLAutoDrawable) {
        this();
        this.add(gLAutoDrawable);
    }

    public synchronized void add(GLAutoDrawable gLAutoDrawable) {
        ArrayList arrayList = (ArrayList)this.drawables.clone();
        arrayList.add(gLAutoDrawable);
        this.drawables = arrayList;
        this.notifyAll();
    }

    public synchronized void remove(GLAutoDrawable gLAutoDrawable) {
        ArrayList arrayList = (ArrayList)this.drawables.clone();
        arrayList.remove(gLAutoDrawable);
        this.drawables = arrayList;
    }

    public Iterator drawableIterator() {
        return this.drawables.iterator();
    }

    public void setIgnoreExceptions(boolean bl) {
        this.ignoreExceptions = bl;
    }

    public void setPrintExceptions(boolean bl) {
        this.printExceptions = bl;
    }

    public final void setRunAsFastAsPossible(boolean bl) {
        this.runAsFastAsPossible = bl;
    }

    protected void display() {
        this.impl.display(this, this.ignoreExceptions, this.printExceptions);
    }

    public synchronized void start() {
        if (this.thread != null) {
            throw new GLException("Already started");
        }
        if (this.runnable == null) {
            this.runnable = new MainLoop();
        }
        this.thread = new Thread(this.runnable);
        this.thread.start();
    }

    public synchronized boolean isAnimating() {
        return this.thread != null;
    }

    public synchronized void stop() {
        this.shouldStop = true;
        this.notifyAll();
        if (this.impl.skipWaitForStop(this.thread)) {
            return;
        }
        while (this.shouldStop && this.thread != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    class MainLoop
    implements Runnable {
        MainLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Animator animator;
            try {
                while (!Animator.this.shouldStop) {
                    if (Animator.this.drawables.size() == 0) {
                        animator = Animator.this;
                        synchronized (animator) {
                            while (Animator.this.drawables.size() == 0 && !Animator.this.shouldStop) {
                                try {
                                    Animator.this.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    }
                    Animator.this.display();
                    if (Animator.this.runAsFastAsPossible) continue;
                    Thread.yield();
                }
            }
            finally {
                Animator.this.shouldStop = false;
                animator = Animator.this;
                synchronized (animator) {
                    Animator.this.thread = null;
                    Animator.this.notify();
                }
            }
        }
    }
}

