/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow;

import javax.media.nativewindow.NativeWindowException;

public class Capabilities
implements Cloneable {
    private int redBits = 8;
    private int greenBits = 8;
    private int blueBits = 8;
    private int alphaBits = 0;
    private boolean backgroundOpaque = true;
    private int transparentValueRed = -1;
    private int transparentValueGreen = -1;
    private int transparentValueBlue = -1;
    private int transparentValueAlpha = -1;
    private boolean onscreen = true;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NativeWindowException(cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof Capabilities)) {
            return false;
        }
        Capabilities capabilities = (Capabilities)object;
        boolean bl2 = bl = capabilities.getRedBits() == this.redBits && capabilities.getGreenBits() == this.greenBits && capabilities.getBlueBits() == this.blueBits && capabilities.getAlphaBits() == this.alphaBits && capabilities.isBackgroundOpaque() == this.backgroundOpaque && capabilities.isOnscreen() == this.onscreen;
        if (!this.backgroundOpaque) {
            bl = bl && capabilities.getTransparentRedValue() == this.transparentValueRed && capabilities.getTransparentGreenValue() == this.transparentValueGreen && capabilities.getTransparentBlueValue() == this.transparentValueBlue && capabilities.getTransparentAlphaValue() == this.transparentValueAlpha;
        }
        return bl;
    }

    public int getRedBits() {
        return this.redBits;
    }

    public void setRedBits(int n) {
        this.redBits = n;
    }

    public int getGreenBits() {
        return this.greenBits;
    }

    public void setGreenBits(int n) {
        this.greenBits = n;
    }

    public int getBlueBits() {
        return this.blueBits;
    }

    public void setBlueBits(int n) {
        this.blueBits = n;
    }

    public int getAlphaBits() {
        return this.alphaBits;
    }

    public void setAlphaBits(int n) {
        this.alphaBits = n;
    }

    public void setBackgroundOpaque(boolean bl) {
        this.backgroundOpaque = bl;
        if (!bl) {
            if (this.transparentValueRed < 0) {
                this.transparentValueRed = (1 << this.getRedBits() - 1) - 1;
            }
            if (this.transparentValueGreen < 0) {
                this.transparentValueGreen = (1 << this.getGreenBits() - 1) - 1;
            }
            if (this.transparentValueBlue < 0) {
                this.transparentValueBlue = (1 << this.getBlueBits() - 1) - 1;
            }
            if (this.transparentValueAlpha < 0) {
                this.transparentValueAlpha = (1 << this.getAlphaBits() - 1) - 1;
            }
        }
    }

    public boolean isBackgroundOpaque() {
        return this.backgroundOpaque;
    }

    public void setOnscreen(boolean bl) {
        this.onscreen = bl;
    }

    public boolean isOnscreen() {
        return this.onscreen;
    }

    public int getTransparentRedValue() {
        return this.transparentValueRed;
    }

    public int getTransparentGreenValue() {
        return this.transparentValueGreen;
    }

    public int getTransparentBlueValue() {
        return this.transparentValueBlue;
    }

    public int getTransparentAlphaValue() {
        return this.transparentValueAlpha;
    }

    public void setTransparentRedValue(int n) {
        this.transparentValueRed = n;
    }

    public void setTransparentGreenValue(int n) {
        this.transparentValueGreen = n;
    }

    public void setTransparentBlueValue(int n) {
        this.transparentValueBlue = n;
    }

    public void setTransparentAlphaValue(int n) {
        this.transparentValueAlpha = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Capabilities[");
        stringBuffer.append("Onscreen: " + this.onscreen + ", Red: " + this.redBits + ", Green: " + this.greenBits + ", Blue: " + this.blueBits + ", Alpha: " + this.alphaBits + ", Opaque: " + this.backgroundOpaque);
        if (!this.backgroundOpaque) {
            stringBuffer.append(", Transparent RGBA: [0x" + Integer.toHexString(this.transparentValueRed) + " 0x" + Integer.toHexString(this.transparentValueGreen) + " 0x" + Integer.toHexString(this.transparentValueBlue) + " 0x" + Integer.toHexString(this.transparentValueAlpha) + "] ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

