/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.player;

import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractClock implements Clock {

	private final int scale;

	private final AtomicLong lastValue = new AtomicLong(rawValue());


	public AbstractClock(int scale) {
		super();
		this.scale = scale;
	}

	public int getScale() {
		return scale;
	}

	public long getValue() {
		// rawValue()が逆戻りした場合は前回と同じ値を返す。
		long oldValue = lastValue.get();
		long newValue = Math.max(oldValue, rawValue());
		if (lastValue.compareAndSet(oldValue, newValue)) {
			return newValue;
		} else {
			// 更新失敗＝他のスレッドがほぼ同時に更新ということなので、その値をそのまま使う。
			return lastValue.get();
		}
	}

	protected abstract long rawValue();

}
