/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.project;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;

public class ModifyLayerParentOperation extends ProjectOperation {

	private final String _compId;

	private final String _layerId;

	private final String _oldParentId;

	private final String _newParentId;


	public ModifyLayerParentOperation(ProjectManager projectManager, Layer layer, Layer newParent) {
		super(projectManager, "親の変更");

		LayerComposition comp = projectManager.checkLayer(layer);

		if (newParent != null && projectManager.checkLayer(newParent) != comp) {
			throw new IllegalArgumentException("layer and parent must belong to same composition");
		}

		Layer oldParent = layer.getParent();
		_noEffect = (newParent == oldParent);

		_compId = comp.getId();
		_layerId = layer.getId();
		_oldParentId = (oldParent != null) ? oldParent.getId() : null;
		_newParentId = (newParent != null) ? newParent.getId() : null;
	}

	@Override
	protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info,
			Project project, ProjectManager pm) throws ExecutionException {

		modifyParent(_newParentId, project, pm);
		return Status.OK_STATUS;
	}

	@Override
	protected IStatus undo(IProgressMonitor monitor, IAdaptable info,
			Project project, ProjectManager pm) throws ExecutionException {

		modifyParent(_oldParentId, project, pm);
		return Status.OK_STATUS;
	}

	private void modifyParent(String parentId, Project project, ProjectManager pm) {
		LayerComposition comp = project.getComposition(_compId);
		Layer layer = comp.getLayer(_layerId);
		Layer parent = (parentId != null) ? comp.getLayer(parentId) : null;

		layer.setParent(parent);

		if (pm != null) {
			pm.fireLayerPropertyChange(layer, "parent");
		}
	}

}
