/*******************************************************************************
 * Copyright (c) 2008 Tom Schindl and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tom Schindl <tom.schindl@bestsolution.at> - initial API and implementation (bug 174739)
 ******************************************************************************/

/*******************************************************************************
 * This file is copied from org.eclipse.jface.viewers.AbstractComboBoxCellEditor
 * and modified by Yoshikazu Kuramochi.
 ******************************************************************************/

package ch.kuramo.javie.app.views;

import java.awt.AWTException;
import java.awt.Robot;
import java.awt.event.InputEvent;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * Abstract base class for Cell-Editors presented as combo boxes
 *
 * @since 3.4
 *
 */
abstract class AbstractComboBoxCellEditor extends CellEditor {
	/**
	 * The list is dropped down when the activation is done through the mouse
	 */
	public static final int DROP_DOWN_ON_MOUSE_ACTIVATION = 1;

	/**
	 * The list is dropped down when the activation is done through the keyboard
	 */
	public static final int DROP_DOWN_ON_KEY_ACTIVATION = 1 << 1;

	/**
	 * The list is dropped down when the activation is done without
	 * ui-interaction
	 */
	public static final int DROP_DOWN_ON_PROGRAMMATIC_ACTIVATION = 1 << 2;

	/**
	 * The list is dropped down when the activation is done by traversing from
	 * cell to cell
	 */
	public static final int DROP_DOWN_ON_TRAVERSE_ACTIVATION = 1 << 3;


	private static final boolean COCOA = SWT.getPlatform().equals("cocoa");

	private static final Robot robot;

	static {
		Robot r = null;
		if (COCOA) {
			try {
				r = new Robot();
			} catch (AWTException e) {
				e.printStackTrace();
			}
		}
		robot = r;
	}


	private int activationStyle = SWT.NONE;

	/**
	 * Create a new cell-editor
	 *
	 * @param parent
	 *            the parent of the combo
	 * @param style
	 *            the style used to create the combo
	 */
	AbstractComboBoxCellEditor(Composite parent, int style) {
		super(parent, style);
	}

	/**
	 * Creates a new cell editor with no control and no st of choices.
	 * Initially, the cell editor has no cell validator.
	 *
	 */
	AbstractComboBoxCellEditor() {
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.eclipse.jface.viewers.CellEditor#activate(org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent)
	 */
	public void activate(ColumnViewerEditorActivationEvent activationEvent) {
		super.activate(activationEvent);
		if (activationStyle != SWT.NONE) {
			boolean dropDown = false;
			if ((activationEvent.eventType == ColumnViewerEditorActivationEvent.MOUSE_CLICK_SELECTION || activationEvent.eventType == ColumnViewerEditorActivationEvent.MOUSE_DOUBLE_CLICK_SELECTION)
					&& (activationStyle & DROP_DOWN_ON_MOUSE_ACTIVATION) != 0 ) {
				dropDown = true;
			} else if (activationEvent.eventType == ColumnViewerEditorActivationEvent.KEY_PRESSED
					&& (activationStyle & DROP_DOWN_ON_KEY_ACTIVATION) != 0 ) {
				dropDown = true;
			} else if (activationEvent.eventType == ColumnViewerEditorActivationEvent.PROGRAMMATIC
					&& (activationStyle & DROP_DOWN_ON_PROGRAMMATIC_ACTIVATION) != 0) {
				dropDown = true;
			} else if (activationEvent.eventType == ColumnViewerEditorActivationEvent.TRAVERSAL
					&& (activationStyle & DROP_DOWN_ON_TRAVERSE_ACTIVATION) != 0) {
				dropDown = true;
			}

			if (dropDown) {
				getControl().getDisplay().asyncExec(new Runnable() {

					public void run() {
						if (robot != null) {
							Control control = getControl();
							Rectangle bounds = control.getBounds();
							Point origLocation = control.getDisplay().getCursorLocation();
							Point pt = control.toDisplay(bounds.width-10, bounds.height/2);
							robot.mouseRelease(InputEvent.BUTTON1_MASK);
							robot.mouseMove(pt.x, pt.y);
							robot.mousePress(InputEvent.BUTTON1_MASK);
							robot.mouseRelease(InputEvent.BUTTON1_MASK);
							robot.mouseMove(origLocation.x, origLocation.y);

						} else if (!COCOA) {
							((Combo) getControl()).setListVisible(true);
						}
					}

				});

			}
		}
	}

	/**
	 * This method allows to control how the combo reacts when activated
	 *
	 * @param activationStyle
	 *            the style used
	 */
	public void setActivationStyle(int activationStyle) {
		this.activationStyle = activationStyle;
	}
}
