/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import java.util.Map;

import org.eclipse.swt.graphics.GC;

import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableInteger;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.TextLayer;

public class TextLeadingElement extends LayerAnimatableValueElement {

	public TextLeadingElement(Element parent, TextLayer layer) {
		super(parent, layer, "leading", "行送り", "px");
	}

	protected AnimatableValueElementDelegate<?> createDelegate() {
		AnimatableDouble avalue = PropertyUtil.getProperty(layer, property);
		return new TextLeadingElementDelegate(this, (TextLayer)layer, name, avalue, unit);
	}

}

class TextLeadingElementDelegate extends AnimatableDoubleElementDelegate {

	private final AnimatableInteger fontSizeAvalue;


	public TextLeadingElementDelegate(
			AnimatableValueElement element, TextLayer layer,
			String name, AnimatableDouble avalue, String unit) {

		super(element, name, avalue, unit);
		fontSizeAvalue = PropertyUtil.getProperty(layer, "fontSize");
	}

	protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
		if (value < 0) {
			drawValue(gc, x, y, height, focused, AUTO);
		} else {
			super.drawValue(gc, x, y, height, focused);
		}
	}

	protected Double dragGesture(double dx, double dy) {
		if (value < 0 && originalValue < 0) {
			originalValue = autoValue();
		}
		return Math.max(0, super.dragGesture(dx, dy));
	}

	public Object getCellEditorValue(int columnIndex) {
		if (columnIndex == LayerCompositionView.VALUE_COL && value < 0) {
			return autoValueAsCellEditorValue();
		} else {
			return super.getCellEditorValue(columnIndex);
		}
	}

	public void setCellEditorValue(int columnIndex, Object value) {
		if (columnIndex == LayerCompositionView.VALUE_COL) {
			value = ((String) value).trim();
			try {
				if (value.equals(autoValueAsCellEditorValue())
						|| value.equals(AUTO) || Double.valueOf((String) value) < 0) {
					if (this.value >= 0) {
						super.setCellEditorValue(columnIndex, "-1");
					}
				} else {
					super.setCellEditorValue(columnIndex, value);
				}
			} catch (NumberFormatException e) {
				element.viewer.getTree().getDisplay().beep();
			}
		}
	}

	private double autoValue() {
		@SuppressWarnings("unchecked")
		Map<AnimatableValue<?>, ?> animatableValues = (Map<AnimatableValue<?>, ?>)
				element.viewer.getData(LayerCompositionView.ANIMATABLE_VALUES);

		int fontSize = (Integer) animatableValues.get(fontSizeAvalue);
		return fontSize * 1.2;
	}

	private static final String AUTO = "自動";

	private String autoValueAsCellEditorValue() {
		return String.format("%s (%s)", AUTO, formatValue(autoValue(), 1));
	}

}
