/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import java.util.regex.Pattern;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.TextLayer;

public class TextSourceElement extends LayerAnimatableValueElement {

	public TextSourceElement(Element parent, TextLayer layer) {
		super(parent, layer, "sourceText", "ソーステキスト");
	}

	protected AnimatableValueElementDelegate<?> createDelegate() {
		AnimatableString avalue = PropertyUtil.getProperty(layer, property);
		return new TextSourceElementDelegate(this, name, avalue);
	}

}

class TextSourceElementDelegate extends AnimatableStringElementDelegate {

	private static final String EDITOR_KEY = "TextSourceElementDelegate.TextCellEditor";


	public TextSourceElementDelegate(
			AnimatableValueElement element, String name, AnimatableString avalue) {

		super(element, name, avalue);
	}

	public CellEditor getCellEditor(int columnIndex) {
		if (columnIndex == LayerCompositionView.VALUE_COL) {
			TextCellEditor editor = (TextCellEditor) element.viewer.getData(EDITOR_KEY);
			if (editor == null) {
				editor = new TextCellEditor(element.viewer.getTree(), SWT.MULTI | SWT.V_SCROLL | SWT.BORDER) {
					public LayoutData getLayoutData() {
						LayoutData data = super.getLayoutData();
						data.minimumHeight = 80;
						data.verticalAlignment = SWT.TOP;
						return data;
					}
				};
				Control control = editor.getControl();
				control.setBackground(control.getDisplay().getSystemColor(SWT.COLOR_WHITE));
				element.viewer.setData(EDITOR_KEY, editor);
			}
			return editor;

		} else {
			return super.getCellEditor(columnIndex);
		}
	}

	private static final Pattern LF = Pattern.compile("\\n");
	private static final Pattern CR_OR_CRLF = Pattern.compile("\\r\\n?");

	public Object getCellEditorValue(int columnIndex) {
		if (columnIndex == LayerCompositionView.VALUE_COL) {
			return LF.matcher(value).replaceAll(Text.DELIMITER);
		} else {
			return super.getCellEditorValue(columnIndex);
		}
	}

	public void setCellEditorValue(int columnIndex, Object value) {
		if (columnIndex == LayerCompositionView.VALUE_COL) {
			value = CR_OR_CRLF.matcher((String) value).replaceAll("\n");
		}
		super.setCellEditorValue(columnIndex, value);
	}

}
