package ch.kuramo.javie.app.widgets;

import org.eclipse.swt.SWT;

import com.sun.jna.Library;
import com.sun.jna.Native;

public class WSWin32 {

	private static final boolean WIN32 = SWT.getPlatform().equals("win32");

	private static final boolean WINXP = WIN32 && System.getProperty("os.name").equals("Windows XP");

	private static final UxTheme uxTheme;

	static {
		UxTheme lib = null;
		if (WIN32) {
			try {
				lib = (UxTheme) Native.loadLibrary("UxTheme", UxTheme.class);
			} catch (Throwable t) {
			}
		}
		uxTheme = lib;
	}


	public static boolean isWin32() {
		return WIN32;
	}

	public static boolean isWinXP() {
		return WINXP;
	}

	public static boolean isAppThemed() {
		return (uxTheme != null) && uxTheme.IsAppThemed();
	}

	public static boolean isXPThemed() {
		return isWinXP() && isAppThemed();
	}

	public static boolean isXPClassic() {
		return isWinXP() && !isAppThemed();
	}


	private WSWin32() { }

}

interface UxTheme extends Library {

	boolean IsAppThemed();

}
