/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.blurSharpen;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import com.google.inject.Inject;

@Effect(id="ch.kuramo.javie.GaussianBlur", category="ch.kuramo.javie.api.effectCategory.blurAndSharpen")
public class GaussianBlur {
    @Property(min="0", max="500")
    private IAnimatableDouble blurriness;
    @Property
    private IAnimatableEnum<IBlurSupport.BlurDimensions> blurDimensions;
    @Property
    private IAnimatableBoolean repeatEdgePixels;
    @Property(value="true")
    private IAnimatableBoolean fast;
    private final IVideoEffectContext context;
    private final IBlurSupport blurSupport;

    @Inject
    public GaussianBlur(IVideoEffectContext context, IBlurSupport blurSupport) {
        this.context = context;
        this.blurSupport = blurSupport;
    }

    public VideoBounds getVideoBounds() {
        VideoBounds bounds = this.context.getPreviousBounds();
        if (bounds.isEmpty()) {
            return bounds;
        }
        double blur = (Double)this.context.value((IAnimatableValue)this.blurriness);
        if (blur == 0.0) {
            return bounds;
        }
        if (((Boolean)this.context.value((IAnimatableValue)this.repeatEdgePixels)).booleanValue()) {
            return bounds;
        }
        boolean fast = blur > 50.0 || (Boolean)this.context.value((IAnimatableValue)this.fast) != false;
        blur = this.context.getVideoResolution().scale(blur);
        IBlurSupport.BlurDimensions dimensions = (IBlurSupport.BlurDimensions)this.context.value(this.blurDimensions);
        return this.blurSupport.calcGaussianBlurredBounds(bounds, blur, dimensions, fast);
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer input = this.context.doPreviousEffect();
        if (input.getBounds().isEmpty()) {
            return input;
        }
        double blur = (Double)this.context.value((IAnimatableValue)this.blurriness);
        if (blur == 0.0) {
            return input;
        }
        try {
            boolean fast = blur > 50.0 || (Boolean)this.context.value((IAnimatableValue)this.fast) != false;
            blur = this.context.getVideoResolution().scale(blur);
            IBlurSupport.BlurDimensions dimensions = (IBlurSupport.BlurDimensions)this.context.value(this.blurDimensions);
            boolean repeatEdgePixels = (Boolean)this.context.value((IAnimatableValue)this.repeatEdgePixels);
            IVideoBuffer iVideoBuffer = this.blurSupport.gaussianBlur(input, blur, dimensions, repeatEdgePixels, fast);
            return iVideoBuffer;
        }
        finally {
            input.dispose();
        }
    }
}

