/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.channel;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.Invert", category="ch.kuramo.javie.api.effectCategory.channel")
public class Invert {
    @Property
    private IAnimatableEnum<Channel> channel;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble blendWithOriginal;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final Map<Channel, IShaderProgram> programs = new HashMap<Channel, IShaderProgram>();
    @ShaderSource
    public static final String[] RGB = Invert.createRGBASource(Channel.RGB);
    @ShaderSource
    public static final String[] RED = Invert.createRGBASource(Channel.RED);
    @ShaderSource
    public static final String[] GREEN = Invert.createRGBASource(Channel.GREEN);
    @ShaderSource
    public static final String[] BLUE = Invert.createRGBASource(Channel.BLUE);
    @ShaderSource
    public static final String[] ALPHA = Invert.createRGBASource(Channel.ALPHA);
    private static final String RGB2HSL = "ch.kuramo.javie.effects.keying.KeyingShaders.rgb2hsl";
    private static final String HSL2RGB = "ch.kuramo.javie.effects.noiseGrain.FractalNoise.hsl2rgb";
    @ShaderSource(attach={"ch.kuramo.javie.effects.keying.KeyingShaders.rgb2hsl", "ch.kuramo.javie.effects.noiseGrain.FractalNoise.hsl2rgb"})
    public static final String[] HSL = Invert.createHSLSource(Channel.HSL);
    @ShaderSource(attach={"ch.kuramo.javie.effects.keying.KeyingShaders.rgb2hsl", "ch.kuramo.javie.effects.noiseGrain.FractalNoise.hsl2rgb"})
    public static final String[] HUE = Invert.createHSLSource(Channel.HUE);
    @ShaderSource(attach={"ch.kuramo.javie.effects.keying.KeyingShaders.rgb2hsl", "ch.kuramo.javie.effects.noiseGrain.FractalNoise.hsl2rgb"})
    public static final String[] SATURATION = Invert.createHSLSource(Channel.SATURATION);
    @ShaderSource(attach={"ch.kuramo.javie.effects.keying.KeyingShaders.rgb2hsl", "ch.kuramo.javie.effects.noiseGrain.FractalNoise.hsl2rgb"})
    public static final String[] LUMINOSITY = Invert.createHSLSource(Channel.LUMINOSITY);

    @Inject
    public Invert(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        Channel[] channelArray = Channel.values();
        int n = channelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Channel ch = channelArray[n2];
            this.programs.put(ch, shaders.getProgram(Invert.class, ch.name()));
            ++n2;
        }
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        if (source.getBounds().isEmpty()) {
            return source;
        }
        Channel ch = (Channel)((Object)this.context.value(this.channel));
        double blend = (Double)this.context.value((IAnimatableValue)this.blendWithOriginal) / 100.0;
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        uniforms.add(new GLUniformData("texture", 0));
        uniforms.add(new GLUniformData("blend", (float)blend));
        try {
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(this.programs.get((Object)ch), uniforms, null, new IVideoBuffer[]{source});
            return iVideoBuffer;
        }
        finally {
            source.dispose();
        }
    }

    private static String[] createRGBASource(Channel channel) {
        String alphaNew;
        String rgbNew;
        switch (channel) {
            case RGB: {
                rgbNew = "(vec3(1.0)-rgb)";
                alphaNew = "src.a";
                break;
            }
            case RED: {
                rgbNew = "vec3(1.0-rgb.r, rgb.gb)";
                alphaNew = "src.a";
                break;
            }
            case GREEN: {
                rgbNew = "vec3(rgb.r, 1.0-rgb.g, rgb.b)";
                alphaNew = "src.a";
                break;
            }
            case BLUE: {
                rgbNew = "vec3(rgb.rg, 1.0-rgb.b)";
                alphaNew = "src.a";
                break;
            }
            case ALPHA: {
                rgbNew = "rgb";
                alphaNew = "(1.0-src.a)";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new String[]{"uniform sampler2DRect texture;", "uniform float blend;", "", "void main(void)", "{", "\tvec4 src = texture2DRect(texture, gl_TexCoord[0].st);", "\tvec3 rgb = (src.a != 0.0) ? src.rgb/src.a : vec3(0.0);", String.format("\tgl_FragColor = vec4(%s, 1.0)*%s*(1.0-blend) + src*blend;", rgbNew, alphaNew), "}"};
    }

    private static String[] createHSLSource(Channel channel) {
        String hslNew;
        switch (channel) {
            case HSL: {
                hslNew = "vec3(1.5, 1.0, 1.0) - hsl";
                break;
            }
            case HUE: {
                hslNew = "vec3(1.5-hsl.x, hsl.yz)";
                break;
            }
            case SATURATION: {
                hslNew = "vec3(hsl.x, 1.0-hsl.y, hsl.z)";
                break;
            }
            case LUMINOSITY: {
                hslNew = "vec3(hsl.xy, 1.0-hsl.z)";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new String[]{"uniform sampler2DRect texture;", "uniform float blend;", "", "vec3 rgb2hsl(vec3 rgb);", "vec3 hsl2rgb(vec3 rgb);", "", "void main(void)", "{", "\tvec4 src = texture2DRect(texture, gl_TexCoord[0].st);", "\tvec3 rgb = (src.a != 0.0) ? src.rgb/src.a : vec3(0.0);", "\tvec3 hsl = rgb2hsl(rgb);", String.format("\trgb = hsl2rgb(%s);", hslNew), "\tgl_FragColor = vec4(rgb, 1.0)*src.a*(1.0-blend) + src*blend;", "}"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Channel {
        RGB,
        RED,
        GREEN,
        BLUE,
        HSL,
        HUE,
        SATURATION,
        LUMINOSITY,
        ALPHA;

    }
}

